/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.gossip;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.gossip.ReputationType;

public class Reputation {
    public static final Codec<Reputation> CODEC = b.CODEC.listOf().xmap(Reputation::new, var0 -> var0.unpack().toList());
    public static final int DISCARD_THRESHOLD = 2;
    private final Map<UUID, a> gossips = new HashMap<UUID, a>();

    public Reputation() {
    }

    private Reputation(List<b> var02) {
        var02.forEach(var0 -> this.getOrCreate((UUID)var0.target).entries.put((Object)var0.type, var0.value));
    }

    @VisibleForDebug
    public Map<UUID, Object2IntMap<ReputationType>> getGossipEntries() {
        HashMap var0 = Maps.newHashMap();
        this.gossips.keySet().forEach(var1 -> {
            a var2 = this.gossips.get(var1);
            var0.put(var1, var2.entries);
        });
        return var0;
    }

    public void decay() {
        Iterator<a> var0 = this.gossips.values().iterator();
        while (var0.hasNext()) {
            a var1 = var0.next();
            var1.decay();
            if (!var1.isEmpty()) continue;
            var0.remove();
        }
    }

    private Stream<b> unpack() {
        return this.gossips.entrySet().stream().flatMap(var0 -> ((a)var0.getValue()).unpack((UUID)var0.getKey()));
    }

    private Collection<b> selectGossipsForTransfer(RandomSource var0, int var1) {
        List<b> var2 = this.unpack().toList();
        if (var2.isEmpty()) {
            return Collections.emptyList();
        }
        int[] var3 = new int[var2.size()];
        int var4 = 0;
        for (int var5 = 0; var5 < var2.size(); ++var5) {
            b var6 = var2.get(var5);
            var3[var5] = (var4 += Math.abs(var6.weightedValue())) - 1;
        }
        Set var5 = Sets.newIdentityHashSet();
        for (int var6 = 0; var6 < var1; ++var6) {
            int var7 = var0.nextInt(var4);
            int var8 = Arrays.binarySearch(var3, var7);
            var5.add(var2.get(var8 < 0 ? -var8 - 1 : var8));
        }
        return var5;
    }

    private a getOrCreate(UUID var02) {
        return this.gossips.computeIfAbsent(var02, var0 -> new a());
    }

    public void transferFrom(Reputation var02, RandomSource var1, int var2) {
        Collection<b> var3 = var02.selectGossipsForTransfer(var1, var2);
        var3.forEach(var0 -> {
            int var1 = var0.value - var0.type.decayPerTransfer;
            if (var1 >= 2) {
                this.getOrCreate((UUID)var0.target).entries.mergeInt((Object)var0.type, var1, Reputation::mergeValuesForTransfer);
            }
        });
    }

    public int getReputation(UUID var0, Predicate<ReputationType> var1) {
        a var2 = this.gossips.get(var0);
        return var2 != null ? var2.weightedValue(var1) : 0;
    }

    public long getCountForType(ReputationType var0, DoublePredicate var1) {
        return this.gossips.values().stream().filter(var2 -> var1.test(var2.entries.getOrDefault((Object)var0, 0) * var1.weight)).count();
    }

    public void add(UUID var0, ReputationType var12, int var22) {
        a var3 = this.getOrCreate(var0);
        var3.entries.mergeInt((Object)var12, var22, (var1, var2) -> this.mergeValuesForAddition(var12, var1, var2));
        var3.makeSureValueIsntTooLowOrTooHigh(var12);
        if (var3.isEmpty()) {
            this.gossips.remove(var0);
        }
    }

    public void remove(UUID var0, ReputationType var1, int var2) {
        this.add(var0, var1, -var2);
    }

    public void remove(UUID var0, ReputationType var1) {
        a var2 = this.gossips.get(var0);
        if (var2 != null) {
            var2.remove(var1);
            if (var2.isEmpty()) {
                this.gossips.remove(var0);
            }
        }
    }

    public void remove(ReputationType var0) {
        Iterator<a> var1 = this.gossips.values().iterator();
        while (var1.hasNext()) {
            a var2 = var1.next();
            var2.remove(var0);
            if (!var2.isEmpty()) continue;
            var1.remove();
        }
    }

    public void clear() {
        this.gossips.clear();
    }

    public void putAll(Reputation var02) {
        var02.gossips.forEach((var0, var1) -> this.getOrCreate((UUID)var0).entries.putAll(var1.entries));
    }

    private static int mergeValuesForTransfer(int var0, int var1) {
        return Math.max(var0, var1);
    }

    private int mergeValuesForAddition(ReputationType var0, int var1, int var2) {
        int var3 = var1 + var2;
        return var3 > var0.max ? Math.max(var0.max, var1) : var3;
    }

    public Reputation copy() {
        Reputation var0 = new Reputation();
        var0.putAll(this);
        return var0;
    }

    static class a {
        final Object2IntMap<ReputationType> entries = new Object2IntOpenHashMap();

        a() {
        }

        public int weightedValue(Predicate<ReputationType> var02) {
            return this.entries.object2IntEntrySet().stream().filter(var1 -> var02.test((ReputationType)var1.getKey())).mapToInt(var0 -> var0.getIntValue() * ((ReputationType)var0.getKey()).weight).sum();
        }

        public Stream<b> unpack(UUID var0) {
            return this.entries.object2IntEntrySet().stream().map(var1 -> new b(var0, (ReputationType)var1.getKey(), var1.getIntValue()));
        }

        public void decay() {
            ObjectIterator var0 = this.entries.object2IntEntrySet().iterator();
            while (var0.hasNext()) {
                Object2IntMap.Entry var1 = (Object2IntMap.Entry)var0.next();
                int var2 = var1.getIntValue() - ((ReputationType)var1.getKey()).decayPerDay;
                if (var2 < 2) {
                    var0.remove();
                    continue;
                }
                var1.setValue(var2);
            }
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public void makeSureValueIsntTooLowOrTooHigh(ReputationType var0) {
            int var1 = this.entries.getInt((Object)var0);
            if (var1 > var0.max) {
                this.entries.put((Object)var0, var0.max);
            }
            if (var1 < 2) {
                this.remove(var0);
            }
        }

        public void remove(ReputationType var0) {
            this.entries.removeInt((Object)var0);
        }
    }

    static final class b
    extends Record {
        final UUID target;
        final ReputationType type;
        final int value;
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)UUIDUtil.CODEC.fieldOf("Target").forGetter(b::target), (App)ReputationType.CODEC.fieldOf("Type").forGetter(b::type), (App)ExtraCodecs.POSITIVE_INT.fieldOf("Value").forGetter(b::value)).apply((Applicative)var0, b::new));

        b(UUID var0, ReputationType var1, int var2) {
            this.target = var0;
            this.type = var1;
            this.value = var2;
        }

        public int weightedValue() {
            return this.value * this.type.weight;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "target;type;value", "target", "type", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "target;type;value", "target", "type", "value"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "target;type;value", "target", "type", "value"}, this, var0);
        }

        public UUID target() {
            return this.target;
        }

        public ReputationType type() {
            return this.type;
        }

        public int value() {
            return this.value;
        }
    }
}

