/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;

public abstract class NearestVisibleLivingEntitySensor
extends Sensor<EntityLiving> {
    protected abstract boolean isMatchingEntity(WorldServer var1, EntityLiving var2, EntityLiving var3);

    protected abstract MemoryModuleType<EntityLiving> getMemory();

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(this.getMemory());
    }

    @Override
    protected void doTick(WorldServer var0, EntityLiving var1) {
        var1.getBrain().setMemory(this.getMemory(), this.getNearestEntity(var0, var1));
    }

    private Optional<EntityLiving> getNearestEntity(WorldServer var0, EntityLiving var1) {
        return this.getVisibleEntities(var1).flatMap(var22 -> var22.findClosest(var2 -> this.isMatchingEntity(var0, var1, (EntityLiving)var2)));
    }

    protected Optional<NearestVisibleLivingEntities> getVisibleEntities(EntityLiving var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }
}

