/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class SensorVillagerBabies
extends Sensor<EntityLiving> {
    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.VISIBLE_VILLAGER_BABIES);
    }

    @Override
    protected void doTick(WorldServer var0, EntityLiving var1) {
        var1.getBrain().setMemory(MemoryModuleType.VISIBLE_VILLAGER_BABIES, this.getNearestVillagerBabies(var1));
    }

    private List<EntityLiving> getNearestVillagerBabies(EntityLiving var0) {
        return ImmutableList.copyOf(this.getVisibleEntities(var0).findAll(this::isVillagerBaby));
    }

    private boolean isVillagerBaby(EntityLiving var0) {
        return var0.getType() == EntityTypes.VILLAGER && var0.isBaby();
    }

    private NearestVisibleLivingEntities getVisibleEntities(EntityLiving var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
    }
}

