/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class EntityPolarBear
extends EntityAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> DATA_STANDING_ID = DataWatcher.defineId(EntityPolarBear.class, DataWatcherRegistry.BOOLEAN);
    private static final float STAND_ANIMATION_TICKS = 6.0f;
    private float clientSideStandAnimationO;
    private float clientSideStandAnimation;
    private int warningSoundTicks;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeRange.rangeOfSeconds(20, 39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public EntityPolarBear(EntityTypes<? extends EntityPolarBear> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.POLAR_BEAR.create(var0, EntitySpawnReason.BREEDING);
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return false;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new c());
        this.goalSelector.addGoal(1, new PathfinderGoalPanic((EntityCreature)this, 2.0, var0 -> var0.isBaby() ? DamageTypeTags.PANIC_CAUSES : DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(4, new PathfinderGoalFollowParent(this, 1.25));
        this.goalSelector.addGoal(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.goalSelector.addGoal(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new b());
        this.targetSelector.addGoal(2, new a());
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::isAngryAt));
        this.targetSelector.addGoal(4, new PathfinderGoalNearestAttackableTarget<EntityFox>(this, EntityFox.class, 10, true, true, null));
        this.targetSelector.addGoal(5, new PathfinderGoalUniversalAngerReset<EntityPolarBear>(this, false));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MAX_HEALTH, 30.0).add(GenericAttributes.FOLLOW_RANGE, 20.0).add(GenericAttributes.MOVEMENT_SPEED, 0.25).add(GenericAttributes.ATTACK_DAMAGE, 6.0);
    }

    public static boolean checkPolarBearSpawnRules(EntityTypes<EntityPolarBear> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        Holder<BiomeBase> var5 = var1.getBiome(var3);
        if (var5.is(BiomeTags.POLAR_BEARS_SPAWN_ON_ALTERNATE_BLOCKS)) {
            return EntityPolarBear.isBrightEnoughToSpawn(var1, var3) && var1.getBlockState(var3.below()).is(TagsBlock.POLAR_BEARS_SPAWNABLE_ON_ALTERNATE);
        }
        return EntityPolarBear.checkAnimalSpawnRules(var0, var1, var2, var3, var4);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.readPersistentAngerSaveData(this.level(), var0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        this.addPersistentAngerSaveData(var0);
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    public void setRemainingPersistentAngerTime(int var0) {
        this.remainingPersistentAngerTime = var0;
    }

    @Override
    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable UUID var0) {
        this.persistentAngerTarget = var0;
    }

    @Override
    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.isBaby()) {
            return SoundEffects.POLAR_BEAR_AMBIENT_BABY;
        }
        return SoundEffects.POLAR_BEAR_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.POLAR_BEAR_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.POLAR_BEAR_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.POLAR_BEAR_STEP, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.makeSound(SoundEffects.POLAR_BEAR_WARNING);
            this.warningSoundTicks = 40;
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_STANDING_ID, false);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            if (this.clientSideStandAnimation != this.clientSideStandAnimationO) {
                this.refreshDimensions();
            }
            this.clientSideStandAnimationO = this.clientSideStandAnimation;
            this.clientSideStandAnimation = this.isStanding() ? MathHelper.clamp(this.clientSideStandAnimation + 1.0f, 0.0f, 6.0f) : MathHelper.clamp(this.clientSideStandAnimation - 1.0f, 0.0f, 6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((WorldServer)this.level(), true);
        }
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        if (this.clientSideStandAnimation > 0.0f) {
            float var1 = this.clientSideStandAnimation / 6.0f;
            float var2 = 1.0f + var1;
            return super.getDefaultDimensions(var0).scale(1.0f, var2);
        }
        return super.getDefaultDimensions(var0);
    }

    public boolean isStanding() {
        return this.entityData.get(DATA_STANDING_ID);
    }

    public void setStanding(boolean var0) {
        this.entityData.set(DATA_STANDING_ID, var0);
    }

    public float getStandingAnimationScale(float var0) {
        return MathHelper.lerp(var0, this.clientSideStandAnimationO, this.clientSideStandAnimation) / 6.0f;
    }

    @Override
    protected float getWaterSlowDown() {
        return 0.98f;
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        if (var3 == null) {
            var3 = new EntityAgeable.a(1.0f);
        }
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    class c
    extends PathfinderGoalMeleeAttack {
        public c() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        protected void checkAndPerformAttack(EntityLiving var0) {
            if (this.canPerformAttack(var0)) {
                this.resetAttackCooldown();
                this.mob.doHurtTarget(c.getServerLevel(this.mob), var0);
                EntityPolarBear.this.setStanding(false);
            } else if (this.mob.distanceToSqr(var0) < (double)((var0.getBbWidth() + 3.0f) * (var0.getBbWidth() + 3.0f))) {
                if (this.isTimeToAttack()) {
                    EntityPolarBear.this.setStanding(false);
                    this.resetAttackCooldown();
                }
                if (this.getTicksUntilNextAttack() <= 10) {
                    EntityPolarBear.this.setStanding(true);
                    EntityPolarBear.this.playWarningSound();
                }
            } else {
                this.resetAttackCooldown();
                EntityPolarBear.this.setStanding(false);
            }
        }

        @Override
        public void stop() {
            EntityPolarBear.this.setStanding(false);
            super.stop();
        }
    }

    class b
    extends PathfinderGoalHurtByTarget {
        public b() {
            super(EntityPolarBear.this, new Class[0]);
        }

        @Override
        public void start() {
            super.start();
            if (EntityPolarBear.this.isBaby()) {
                this.alertOthers();
                this.stop();
            }
        }

        @Override
        protected void alertOther(EntityInsentient var0, EntityLiving var1) {
            if (var0 instanceof EntityPolarBear && !var0.isBaby()) {
                super.alertOther(var0, var1);
            }
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public a() {
            super(EntityPolarBear.this, EntityHuman.class, 20, true, true, null);
        }

        @Override
        public boolean canUse() {
            if (EntityPolarBear.this.isBaby()) {
                return false;
            }
            if (super.canUse()) {
                List<EntityPolarBear> var0 = EntityPolarBear.this.level().getEntitiesOfClass(EntityPolarBear.class, EntityPolarBear.this.getBoundingBox().inflate(8.0, 4.0, 8.0));
                for (EntityPolarBear var2 : var0) {
                    if (!var2.isBaby()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected double getFollowDistance() {
            return super.getFollowDistance() * 0.5;
        }
    }
}

