/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;

public class EntityHorseZombie
extends EntityHorseAbstract {
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.ZOMBIE_HORSE.getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityTypes.ZOMBIE_HORSE.getHeight() - 0.03125f, 0.0f)).scale(0.5f);

    public EntityHorseZombie(EntityTypes<? extends EntityHorseZombie> var0, World var1) {
        super((EntityTypes<? extends EntityHorseAbstract>)var0, var1);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityHorseZombie.createBaseHorseAttributes().add(GenericAttributes.MAX_HEALTH, 15.0).add(GenericAttributes.MOVEMENT_SPEED, 0.2f);
    }

    public static boolean checkZombieHorseSpawnRules(EntityTypes<? extends EntityAnimal> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        if (EntitySpawnReason.isSpawner(var2)) {
            return EntitySpawnReason.ignoresLightRequirements(var2) || EntityHorseZombie.isBrightEnoughToSpawn(var1, var3);
        }
        return EntityAnimal.checkAnimalSpawnRules(var0, var1, var2, var3, var4);
    }

    @Override
    protected void randomizeAttributes(RandomSource var0) {
        this.getAttribute(GenericAttributes.JUMP_STRENGTH).setBaseValue(EntityHorseZombie.generateJumpStrength(var0::nextDouble));
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.ZOMBIE_HORSE_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.ZOMBIE_HORSE_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ZOMBIE_HORSE_HURT;
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.ZOMBIE_HORSE.create(var0, EntitySpawnReason.BREEDING);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        if (!this.isTamed()) {
            return EnumInteractionResult.PASS;
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    protected void addBehaviourGoals() {
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(var0);
    }
}

