/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.creaking;

import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.creaking.CreakingAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class Creaking
extends EntityMonster {
    private static final DataWatcherObject<Boolean> CAN_MOVE = DataWatcher.defineId(Creaking.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> IS_ACTIVE = DataWatcher.defineId(Creaking.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> IS_TEARING_DOWN = DataWatcher.defineId(Creaking.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Optional<BlockPosition>> HOME_POS = DataWatcher.defineId(Creaking.class, DataWatcherRegistry.OPTIONAL_BLOCK_POS);
    private static final int ATTACK_ANIMATION_DURATION = 15;
    private static final int MAX_HEALTH = 1;
    private static final float ATTACK_DAMAGE = 3.0f;
    private static final float FOLLOW_RANGE = 32.0f;
    private static final float ACTIVATION_RANGE_SQ = 144.0f;
    public static final int ATTACK_INTERVAL = 40;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.4f;
    public static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.3f;
    public static final int CREAKING_ORANGE = 16545810;
    public static final int CREAKING_GRAY = 0x5F5F5F;
    public static final int INVULNERABILITY_ANIMATION_DURATION = 8;
    public static final int TWITCH_DEATH_DURATION = 45;
    private static final int MAX_PLAYER_STUCK_COUNTER = 4;
    private int attackAnimationRemainingTicks;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState invulnerabilityAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();
    private int invulnerabilityAnimationRemainingTicks;
    private boolean eyesGlowing;
    private int nextFlickerTime;
    private int playerStuckCounter;

    public Creaking(EntityTypes<? extends Creaking> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
        this.lookControl = new c(this);
        this.moveControl = new d(this);
        this.jumpControl = new b(this);
        Navigation var2 = (Navigation)this.getNavigation();
        var2.setCanFloat(true);
        this.xpReward = 0;
    }

    public void setTransient(BlockPosition var0) {
        this.setHomePos(var0);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 8.0f);
        this.setPathfindingMalus(PathType.POWDER_SNOW, 8.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
    }

    public boolean isHeartBound() {
        return this.getHomePos() != null;
    }

    @Override
    protected EntityAIBodyControl createBodyControl() {
        return new a(this);
    }

    protected BehaviorController.b<Creaking> brainProvider() {
        return CreakingAi.brainProvider();
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return CreakingAi.makeBrain(this, this.brainProvider().makeBrain(var0));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(CAN_MOVE, true);
        var0.define(IS_ACTIVE, false);
        var0.define(IS_TEARING_DOWN, false);
        var0.define(HOME_POS, Optional.empty());
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 1.0).add(GenericAttributes.MOVEMENT_SPEED, 0.4f).add(GenericAttributes.ATTACK_DAMAGE, 3.0).add(GenericAttributes.FOLLOW_RANGE, 32.0).add(GenericAttributes.STEP_HEIGHT, 1.0625);
    }

    public boolean canMove() {
        return this.entityData.get(CAN_MOVE);
    }

    @Override
    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        if (!(var1 instanceof EntityLiving)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 15;
        this.level().broadcastEntityEvent(this, (byte)4);
        return super.doHurtTarget(var0, var1);
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        CreakingHeartBlockEntity var6;
        BlockPosition var3 = this.getHomePos();
        if (var3 == null || var1.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurtServer(var0, var1, var2);
        }
        if (this.isInvulnerableTo(var0, var1) || this.invulnerabilityAnimationRemainingTicks > 0 || this.isDeadOrDying()) {
            return false;
        }
        EntityHuman var4 = this.blameSourceForDamage(var1);
        Entity var5 = var1.getDirectEntity();
        if (!(var5 instanceof EntityLiving) && !(var5 instanceof IProjectile) && var4 == null) {
            return false;
        }
        this.invulnerabilityAnimationRemainingTicks = 8;
        this.level().broadcastEntityEvent(this, (byte)66);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        TileEntity tileEntity = this.level().getBlockEntity(var3);
        if (tileEntity instanceof CreakingHeartBlockEntity && (var6 = (CreakingHeartBlockEntity)tileEntity).isProtector(this)) {
            if (var4 != null) {
                var6.creakingHurt();
            }
            this.playHurtSound(var1);
        }
        return true;
    }

    public EntityHuman blameSourceForDamage(DamageSource var0) {
        this.resolveMobResponsibleForDamage(var0);
        return this.resolvePlayerResponsibleForDamage(var0);
    }

    @Override
    public boolean isPushable() {
        return super.isPushable() && this.canMove();
    }

    @Override
    public void push(double var0, double var2, double var4) {
        if (!this.canMove()) {
            return;
        }
        super.push(var0, var2, var4);
    }

    public BehaviorController<Creaking> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("creakingBrain");
        this.getBrain().tick((WorldServer)this.level(), this);
        var1.pop();
        CreakingAi.updateActivity(this);
    }

    @Override
    public void aiStep() {
        if (this.invulnerabilityAnimationRemainingTicks > 0) {
            --this.invulnerabilityAnimationRemainingTicks;
        }
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        if (!this.level().isClientSide()) {
            boolean var0 = this.entityData.get(CAN_MOVE);
            boolean var1 = this.checkCanMove();
            if (var1 != var0) {
                this.gameEvent(GameEvent.ENTITY_ACTION);
                if (var1) {
                    this.makeSound(SoundEffects.CREAKING_UNFREEZE);
                } else {
                    this.stopInPlace();
                    this.makeSound(SoundEffects.CREAKING_FREEZE);
                }
            }
            this.entityData.set(CAN_MOVE, var1);
        }
        super.aiStep();
    }

    @Override
    public void tick() {
        BlockPosition var0;
        if (!this.level().isClientSide() && (var0 = this.getHomePos()) != null) {
            CreakingHeartBlockEntity var2;
            boolean var1;
            TileEntity tileEntity = this.level().getBlockEntity(var0);
            boolean bl = var1 = tileEntity instanceof CreakingHeartBlockEntity && (var2 = (CreakingHeartBlockEntity)tileEntity).isProtector(this);
            if (!var1) {
                this.setHealth(0.0f);
            }
        }
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
            this.checkEyeBlink();
        }
    }

    @Override
    protected void tickDeath() {
        if (this.isHeartBound() && this.isTearingDown()) {
            ++this.deathTime;
            if (!this.level().isClientSide() && this.deathTime > 45 && !this.isRemoved()) {
                this.tearDown();
            }
        } else {
            super.tickDeath();
        }
    }

    @Override
    protected void updateWalkAnimation(float var0) {
        float var1 = Math.min(var0 * 25.0f, 3.0f);
        this.walkAnimation.update(var1, 0.4f, 1.0f);
    }

    private void setupAnimationStates() {
        this.attackAnimationState.animateWhen(this.attackAnimationRemainingTicks > 0, this.tickCount);
        this.invulnerabilityAnimationState.animateWhen(this.invulnerabilityAnimationRemainingTicks > 0, this.tickCount);
        this.deathAnimationState.animateWhen(this.isTearingDown(), this.tickCount);
    }

    public void tearDown() {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            AxisAlignedBB var1 = this.getBoundingBox();
            Vec3D var2 = var1.getCenter();
            double var3 = var1.getXsize() * 0.3;
            double var5 = var1.getYsize() * 0.3;
            double var7 = var1.getZsize() * 0.3;
            var0.sendParticles(new ParticleParamBlock(Particles.BLOCK_CRUMBLE, Blocks.PALE_OAK_WOOD.defaultBlockState()), var2.x, var2.y, var2.z, 100, var3, var5, var7, 0.0);
            var0.sendParticles(new ParticleParamBlock(Particles.BLOCK_CRUMBLE, (IBlockData)Blocks.CREAKING_HEART.defaultBlockState().setValue(CreakingHeartBlock.STATE, CreakingHeartState.AWAKE)), var2.x, var2.y, var2.z, 10, var3, var5, var7, 0.0);
        }
        this.makeSound(this.getDeathSound());
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void creakingDeathEffects(DamageSource var0) {
        this.blameSourceForDamage(var0);
        this.die(var0);
        this.makeSound(SoundEffects.CREAKING_TWITCH);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 66) {
            this.invulnerabilityAnimationRemainingTicks = 8;
            this.playHurtSound(this.damageSources().generic());
        } else if (var0 == 4) {
            this.attackAnimationRemainingTicks = 15;
            this.playAttackSound();
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    public boolean fireImmune() {
        return this.isHeartBound() || super.fireImmune();
    }

    @Override
    protected boolean canAddPassenger(Entity var0) {
        return !this.isHeartBound() && super.canAddPassenger(var0);
    }

    @Override
    protected boolean couldAcceptPassenger() {
        return !this.isHeartBound() && super.couldAcceptPassenger();
    }

    @Override
    protected void addPassenger(Entity var0) {
        if (this.isHeartBound()) {
            throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
        }
    }

    @Override
    public boolean canUsePortal(boolean var0) {
        return !this.isHeartBound() && super.canUsePortal(var0);
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new e(this, var0);
    }

    public boolean playerIsStuckInYou() {
        List var0 = this.brain.getMemory(MemoryModuleType.NEAREST_PLAYERS).orElse(List.of());
        if (var0.isEmpty()) {
            this.playerStuckCounter = 0;
            return false;
        }
        AxisAlignedBB var1 = this.getBoundingBox();
        for (EntityHuman var3 : var0) {
            if (!var1.contains(var3.getEyePosition())) continue;
            ++this.playerStuckCounter;
            return this.playerStuckCounter > 4;
        }
        this.playerStuckCounter = 0;
        return false;
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        var0.read("home_pos", BlockPosition.CODEC).ifPresent(this::setTransient);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.storeNullable("home_pos", BlockPosition.CODEC, this.getHomePos());
    }

    public void setHomePos(BlockPosition var0) {
        this.entityData.set(HOME_POS, Optional.of(var0));
    }

    @Nullable
    public BlockPosition getHomePos() {
        return this.entityData.get(HOME_POS).orElse(null);
    }

    public void setTearingDown() {
        this.entityData.set(IS_TEARING_DOWN, true);
    }

    public boolean isTearingDown() {
        return this.entityData.get(IS_TEARING_DOWN);
    }

    public boolean hasGlowingEyes() {
        return this.eyesGlowing;
    }

    public void checkEyeBlink() {
        if (this.deathTime > this.nextFlickerTime) {
            this.nextFlickerTime = this.deathTime + this.getRandom().nextIntBetweenInclusive(this.eyesGlowing ? 2 : this.deathTime / 4, this.eyesGlowing ? 8 : this.deathTime / 2);
            this.eyesGlowing = !this.eyesGlowing;
        }
    }

    @Override
    public void playAttackSound() {
        this.makeSound(SoundEffects.CREAKING_ATTACK);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.isActive()) {
            return null;
        }
        return SoundEffects.CREAKING_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return this.isHeartBound() ? SoundEffects.CREAKING_SWAY : super.getHurtSound(var0);
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.CREAKING_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.CREAKING_STEP, 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public EntityLiving getTarget() {
        return this.getTargetFromBrain();
    }

    @Override
    public void knockback(double var0, double var2, double var4) {
        if (!this.canMove()) {
            return;
        }
        super.knockback(var0, var2, var4);
    }

    public boolean checkCanMove() {
        List var0 = this.brain.getMemory(MemoryModuleType.NEAREST_PLAYERS).orElse(List.of());
        boolean var1 = this.isActive();
        if (var0.isEmpty()) {
            if (var1) {
                this.deactivate();
            }
            return true;
        }
        boolean var2 = false;
        for (EntityHuman var4 : var0) {
            if (!this.canAttack(var4) || this.isAlliedTo(var4)) continue;
            var2 = true;
            if (var1 && !EntityLiving.PLAYER_NOT_WEARING_DISGUISE_ITEM.test(var4) || !this.isLookingAtMe(var4, 0.5, false, true, this.getEyeY(), this.getY() + 0.5 * (double)this.getScale(), (this.getEyeY() + this.getY()) / 2.0)) continue;
            if (var1) {
                return false;
            }
            if (!(var4.distanceToSqr(this) < 144.0)) continue;
            this.activate(var4);
            return false;
        }
        if (!var2 && var1) {
            this.deactivate();
        }
        return true;
    }

    public void activate(EntityHuman var0) {
        this.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, var0);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.makeSound(SoundEffects.CREAKING_ACTIVATE);
        this.setIsActive(true);
    }

    public void deactivate() {
        this.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.makeSound(SoundEffects.CREAKING_DEACTIVATE);
        this.setIsActive(false);
    }

    public void setIsActive(boolean var0) {
        this.entityData.set(IS_ACTIVE, var0);
    }

    public boolean isActive() {
        return this.entityData.get(IS_ACTIVE);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        return 0.0f;
    }

    class c
    extends ControllerLook {
        public c(Creaking var1) {
            super(var1);
        }

        @Override
        public void tick() {
            if (Creaking.this.canMove()) {
                super.tick();
            }
        }
    }

    class d
    extends ControllerMove {
        public d(Creaking var1) {
            super(var1);
        }

        @Override
        public void tick() {
            if (Creaking.this.canMove()) {
                super.tick();
            }
        }
    }

    class b
    extends ControllerJump {
        public b(Creaking var1) {
            super(var1);
        }

        @Override
        public void tick() {
            if (Creaking.this.canMove()) {
                super.tick();
            } else {
                Creaking.this.setJumping(false);
            }
        }
    }

    class a
    extends EntityAIBodyControl {
        public a(Creaking var1) {
            super(var1);
        }

        @Override
        public void clientTick() {
            if (Creaking.this.canMove()) {
                super.clientTick();
            }
        }
    }

    class e
    extends Navigation {
        e(Creaking var1, World var2) {
            super(var1, var2);
        }

        @Override
        public void tick() {
            if (Creaking.this.canMove()) {
                super.tick();
            }
        }

        @Override
        protected Pathfinder createPathFinder(int var0) {
            this.nodeEvaluator = new f();
            this.nodeEvaluator.setCanPassDoors(true);
            return new Pathfinder(this.nodeEvaluator, var0);
        }
    }

    class f
    extends PathfinderNormal {
        private static final int MAX_DISTANCE_TO_HOME_SQ = 1024;

        f() {
        }

        @Override
        public PathType getPathType(PathfindingContext var0, int var1, int var2, int var3) {
            BlockPosition var4 = Creaking.this.getHomePos();
            if (var4 == null) {
                return super.getPathType(var0, var1, var2, var3);
            }
            double var5 = var4.distSqr(new BaseBlockPosition(var1, var2, var3));
            if (var5 > 1024.0 && var5 >= var4.distSqr(var0.mobPosition())) {
                return PathType.BLOCKED;
            }
            return super.getPathType(var0, var1, var2, var3);
        }
    }
}

