/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class EntityArrow
extends IProjectile {
    private static final double ARROW_BASE_DAMAGE = 2.0;
    private static final int SHAKE_TIME = 7;
    private static final float WATER_INERTIA = 0.6f;
    private static final float INERTIA = 0.99f;
    private static final short DEFAULT_LIFE = 0;
    private static final byte DEFAULT_SHAKE = 0;
    private static final boolean DEFAULT_IN_GROUND = false;
    private static final boolean DEFAULT_CRIT = false;
    private static final byte DEFAULT_PIERCE_LEVEL = 0;
    private static final DataWatcherObject<Byte> ID_FLAGS = DataWatcher.defineId(EntityArrow.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Byte> PIERCE_LEVEL = DataWatcher.defineId(EntityArrow.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Boolean> IN_GROUND = DataWatcher.defineId(EntityArrow.class, DataWatcherRegistry.BOOLEAN);
    private static final int FLAG_CRIT = 1;
    private static final int FLAG_NOPHYSICS = 2;
    @Nullable
    private IBlockData lastState;
    protected int inGroundTime;
    public PickupStatus pickup = PickupStatus.DISALLOWED;
    public int shakeTime = 0;
    public int life = 0;
    public double baseDamage = 2.0;
    private SoundEffect soundEvent = this.getDefaultHitGroundSoundEvent();
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;
    public ItemStack pickupItemStack = this.getDefaultPickupItem();
    @Nullable
    public ItemStack firedFromWeapon = null;

    protected EntityArrow(EntityTypes<? extends EntityArrow> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> var0, double var1, double var3, double var5, World var7, ItemStack var8, @Nullable ItemStack var9) {
        this(var0, var7);
        this.pickupItemStack = var8.copy();
        this.applyComponentsFromItemStack(var8);
        Unit var10 = var8.remove(DataComponents.INTANGIBLE_PROJECTILE);
        if (var10 != null) {
            this.pickup = PickupStatus.CREATIVE_ONLY;
        }
        this.setPos(var1, var3, var5);
        if (var9 != null && var7 instanceof WorldServer) {
            WorldServer var11 = (WorldServer)var7;
            if (var9.isEmpty()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.firedFromWeapon = var9.copy();
            int var12 = EnchantmentManager.getPiercingCount(var11, var9, this.pickupItemStack);
            if (var12 > 0) {
                this.setPierceLevel((byte)var12);
            }
        }
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> var0, EntityLiving var1, World var2, ItemStack var3, @Nullable ItemStack var4) {
        this(var0, var1.getX(), var1.getEyeY() - (double)0.1f, var1.getZ(), var2, var3, var4);
        this.setOwner(var1);
    }

    public void setSoundEvent(SoundEffect var0) {
        this.soundEvent = var0;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(var2)) {
            var2 = 1.0;
        }
        return var0 < (var2 *= 64.0 * EntityArrow.getViewScale()) * var2;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(ID_FLAGS, (byte)0);
        var0.define(PIERCE_LEVEL, (byte)0);
        var0.define(IN_GROUND, false);
    }

    @Override
    public void shoot(double var0, double var2, double var4, float var6, float var7) {
        super.shoot(var0, var2, var4, var6, var7);
        this.life = 0;
    }

    @Override
    public void lerpMotion(Vec3D var0) {
        super.lerpMotion(var0);
        this.life = 0;
        if (this.isInGround() && var0.lengthSqr() > 0.0) {
            this.setInGround(false);
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (!this.firstTick && this.shakeTime <= 0 && var0.equals(IN_GROUND) && this.isInGround()) {
            this.shakeTime = 7;
        }
    }

    @Override
    public void tick() {
        Object var4;
        boolean var0 = !this.isNoPhysics();
        Vec3D var1 = this.getDeltaMovement();
        BlockPosition var2 = this.blockPosition();
        IBlockData var3 = this.level().getBlockState(var2);
        if (!var3.isAir() && var0 && !((VoxelShape)(var4 = var3.getCollisionShape(this.level(), var2))).isEmpty()) {
            Vec3D var5 = this.position();
            for (AxisAlignedBB axisAlignedBB : ((VoxelShape)var4).toAabbs()) {
                if (!axisAlignedBB.move(var2).contains(var5)) continue;
                this.setDeltaMovement(Vec3D.ZERO);
                this.setInGround(true);
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.isInWaterOrRain()) {
            this.clearFire();
        }
        if (this.isInGround() && var0) {
            if (!this.level().isClientSide()) {
                if (this.lastState != var3 && this.shouldFall()) {
                    this.startFalling();
                } else {
                    this.tickDespawn();
                }
            }
            ++this.inGroundTime;
            if (this.isAlive()) {
                this.applyEffectsFromBlocks();
            }
            if (!this.level().isClientSide()) {
                this.setSharedFlagOnFire(this.getRemainingFireTicks() > 0);
            }
            return;
        }
        this.inGroundTime = 0;
        var4 = this.position();
        if (this.isInWater()) {
            this.applyInertia(this.getWaterInertia());
            this.addBubbleParticles((Vec3D)var4);
        }
        if (this.isCritArrow()) {
            for (int var5 = 0; var5 < 4; ++var5) {
                this.level().addParticle(Particles.CRIT, ((Vec3D)var4).x + var1.x * (double)var5 / 4.0, ((Vec3D)var4).y + var1.y * (double)var5 / 4.0, ((Vec3D)var4).z + var1.z * (double)var5 / 4.0, -var1.x, -var1.y + 0.2, -var1.z);
            }
        }
        float var5 = !var0 ? (float)(MathHelper.atan2(-var1.x, -var1.z) * 57.2957763671875) : (float)(MathHelper.atan2(var1.x, var1.z) * 57.2957763671875);
        float var6 = (float)(MathHelper.atan2(var1.y, var1.horizontalDistance()) * 57.2957763671875);
        this.setXRot(EntityArrow.lerpRotation(this.getXRot(), var6));
        this.setYRot(EntityArrow.lerpRotation(this.getYRot(), var5));
        this.checkLeftOwner();
        if (var0) {
            MovingObjectPositionBlock movingObjectPositionBlock = this.level().clipIncludingBorder(new RayTrace((Vec3D)var4, ((Vec3D)var4).add(var1), RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, this));
            this.stepMoveAndHit(movingObjectPositionBlock);
        } else {
            this.setPos(((Vec3D)var4).add(var1));
            this.applyEffectsFromBlocks();
        }
        if (!this.isInWater()) {
            this.applyInertia(0.99f);
        }
        if (var0 && !this.isInGround()) {
            this.applyGravity();
        }
        super.tick();
    }

    private void stepMoveAndHit(MovingObjectPositionBlock var0) {
        while (this.isAlive()) {
            Vec3D var1 = this.position();
            MovingObjectPositionEntity var2 = this.findHitEntity(var1, var0.getLocation());
            Vec3D var3 = ((MovingObjectPosition)Objects.requireNonNullElse(var2, var0)).getLocation();
            this.setPos(var3);
            this.applyEffectsFromBlocks(var1, var3);
            if (this.portalProcess != null && this.portalProcess.isInsidePortalThisTick()) {
                this.handlePortal();
            }
            if (var2 == null) {
                if (!this.isAlive() || var0.getType() == MovingObjectPosition.EnumMovingObjectType.MISS) break;
                this.hitTargetOrDeflectSelf(var0);
                this.hasImpulse = true;
                break;
            }
            if (!this.isAlive() || this.noPhysics) continue;
            ProjectileDeflection var4 = this.hitTargetOrDeflectSelf(var2);
            this.hasImpulse = true;
            if (this.getPierceLevel() > 0 && var4 == ProjectileDeflection.NONE) continue;
            break;
        }
    }

    private void applyInertia(float var0) {
        Vec3D var1 = this.getDeltaMovement();
        this.setDeltaMovement(var1.scale(var0));
    }

    private void addBubbleParticles(Vec3D var0) {
        Vec3D var1 = this.getDeltaMovement();
        for (int var2 = 0; var2 < 4; ++var2) {
            float var3 = 0.25f;
            this.level().addParticle(Particles.BUBBLE, var0.x - var1.x * 0.25, var0.y - var1.y * 0.25, var0.z - var1.z * 0.25, var1.x, var1.y, var1.z);
        }
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    private boolean shouldFall() {
        return this.isInGround() && this.level().noCollision(new AxisAlignedBB(this.position(), this.position()).inflate(0.06));
    }

    private void startFalling() {
        this.setInGround(false);
        Vec3D var0 = this.getDeltaMovement();
        this.setDeltaMovement(var0.multiply(this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f));
        this.life = 0;
    }

    public boolean isInGround() {
        return this.entityData.get(IN_GROUND);
    }

    protected void setInGround(boolean var0) {
        this.entityData.set(IN_GROUND, var0);
    }

    @Override
    public boolean isPushedByFluid() {
        return !this.isInGround();
    }

    @Override
    public void move(EnumMoveType var0, Vec3D var1) {
        super.move(var0, var1);
        if (var0 != EnumMoveType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= 1200) {
            this.discard();
        }
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    @Override
    protected void onItemBreak(Item var0) {
        this.firedFromWeapon = null;
    }

    @Override
    public void onAboveBubbleColumn(boolean var0, BlockPosition var1) {
        if (this.isInGround()) {
            return;
        }
        super.onAboveBubbleColumn(var0, var1);
    }

    @Override
    public void onInsideBubbleColumn(boolean var0) {
        if (this.isInGround()) {
            return;
        }
        super.onInsideBubbleColumn(var0);
    }

    @Override
    public void push(double var0, double var2, double var4) {
        if (this.isInGround()) {
            return;
        }
        super.push(var0, var2, var4);
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        World world;
        super.onHitEntity(var0);
        Entity var1 = var0.getEntity();
        float var2 = (float)this.getDeltaMovement().length();
        double var3 = this.baseDamage;
        Entity var5 = this.getOwner();
        DamageSource var6 = this.damageSources().arrow(this, var5 != null ? var5 : this);
        if (this.getWeaponItem() != null && (world = this.level()) instanceof WorldServer) {
            WorldServer var7 = (WorldServer)world;
            var3 = EnchantmentManager.modifyDamage(var7, this.getWeaponItem(), var1, var6, (float)var3);
        }
        int var7 = MathHelper.ceil(MathHelper.clamp((double)var2 * var3, 0.0, 2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() < this.getPierceLevel() + 1) {
                this.piercingIgnoreEntityIds.add(var1.getId());
            } else {
                this.discard();
                return;
            }
        }
        if (this.isCritArrow()) {
            long var8 = this.random.nextInt(var7 / 2 + 2);
            var7 = (int)Math.min(var8 + (long)var7, Integer.MAX_VALUE);
        }
        if (var5 instanceof EntityLiving) {
            EntityLiving var8 = (EntityLiving)var5;
            var8.setLastHurtMob(var1);
        }
        boolean var8 = var1.getType() == EntityTypes.ENDERMAN;
        int var9 = var1.getRemainingFireTicks();
        if (this.isOnFire() && !var8) {
            var1.igniteForSeconds(5.0f);
        }
        if (var1.hurtOrSimulate(var6, var7)) {
            if (var8) {
                return;
            }
            if (var1 instanceof EntityLiving) {
                Object var11;
                EntityLiving var10 = (EntityLiving)var1;
                if (!this.level().isClientSide() && this.getPierceLevel() <= 0) {
                    var10.setArrowCount(var10.getArrowCount() + 1);
                }
                this.doKnockback(var10, var6);
                World world2 = this.level();
                if (world2 instanceof WorldServer) {
                    var11 = (WorldServer)world2;
                    EnchantmentManager.doPostAttackEffectsWithItemSource((WorldServer)var11, var10, var6, this.getWeaponItem());
                }
                this.doPostHurtEffects(var10);
                if (var10 instanceof EntityHuman && var5 instanceof EntityPlayer) {
                    var11 = (EntityPlayer)var5;
                    if (!this.isSilent() && var10 != var11) {
                        ((EntityPlayer)var11).connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.PLAY_ARROW_HIT_SOUND, 0.0f));
                    }
                }
                if (!var1.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add(var10);
                }
                if (!this.level().isClientSide() && var5 instanceof EntityPlayer) {
                    var11 = (EntityPlayer)var5;
                    if (this.piercedAndKilledEntities != null) {
                        CriterionTriggers.KILLED_BY_ARROW.trigger((EntityPlayer)var11, this.piercedAndKilledEntities, this.firedFromWeapon);
                    } else if (!var1.isAlive()) {
                        CriterionTriggers.KILLED_BY_ARROW.trigger((EntityPlayer)var11, List.of(var1), this.firedFromWeapon);
                    }
                }
            }
            this.playSound(this.soundEvent, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.discard();
            }
        } else {
            var1.setRemainingFireTicks(var9);
            this.deflect(ProjectileDeflection.REVERSE, var1, this.owner, false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            World world3 = this.level();
            if (world3 instanceof WorldServer) {
                WorldServer var10 = (WorldServer)world3;
                if (this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                    if (this.pickup == PickupStatus.ALLOWED) {
                        this.spawnAtLocation(var10, this.getPickupItem(), 0.1f);
                    }
                    this.discard();
                }
            }
        }
    }

    protected void doKnockback(EntityLiving var0, DamageSource var1) {
        float f2;
        World world;
        if (this.firedFromWeapon != null && (world = this.level()) instanceof WorldServer) {
            WorldServer var4 = (WorldServer)world;
            f2 = EnchantmentManager.modifyKnockback(var4, this.firedFromWeapon, var0, var1, 0.0f);
        } else {
            f2 = 0.0f;
        }
        double var2 = f2;
        if (var2 > 0.0) {
            double var4 = Math.max(0.0, 1.0 - var0.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE));
            Vec3D var6 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(var2 * 0.6 * var4);
            if (var6.lengthSqr() > 0.0) {
                var0.push(var6.x, 0.1, var6.z);
            }
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        Object var2;
        this.lastState = this.level().getBlockState(var0.getBlockPos());
        super.onHitBlock(var0);
        ItemStack var1 = this.getWeaponItem();
        World world = this.level();
        if (world instanceof WorldServer) {
            var2 = (WorldServer)world;
            if (var1 != null) {
                this.hitBlockEnchantmentEffects((WorldServer)var2, var0, var1);
            }
        }
        var2 = this.getDeltaMovement();
        Vec3D var3 = new Vec3D(Math.signum(((Vec3D)var2).x), Math.signum(((Vec3D)var2).y), Math.signum(((Vec3D)var2).z));
        Vec3D var4 = var3.scale(0.05f);
        this.setPos(this.position().subtract(var4));
        this.setDeltaMovement(Vec3D.ZERO);
        this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        this.setInGround(true);
        this.shakeTime = 7;
        this.setCritArrow(false);
        this.setPierceLevel((byte)0);
        this.setSoundEvent(SoundEffects.ARROW_HIT);
        this.resetPiercedEntities();
    }

    protected void hitBlockEnchantmentEffects(WorldServer var02, MovingObjectPositionBlock var1, ItemStack var2) {
        EntityLiving var4;
        Vec3D var3 = var1.getBlockPos().clampLocationWithin(var1.getLocation());
        Entity entity = this.getOwner();
        EnchantmentManager.onHitBlock(var02, var2, entity instanceof EntityLiving ? (var4 = (EntityLiving)entity) : null, this, null, var3, var02.getBlockState(var1.getBlockPos()), var0 -> {
            this.firedFromWeapon = null;
        });
    }

    @Override
    @Nullable
    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    protected SoundEffect getDefaultHitGroundSoundEvent() {
        return SoundEffects.ARROW_HIT;
    }

    protected final SoundEffect getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(EntityLiving var0) {
    }

    @Nullable
    protected MovingObjectPositionEntity findHitEntity(Vec3D var0, Vec3D var1) {
        return ProjectileHelper.getEntityHitResult(this.level(), this, var0, var1, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    @Override
    protected boolean canHitEntity(Entity var0) {
        EntityHuman var1;
        Entity entity;
        if (var0 instanceof EntityHuman && (entity = this.getOwner()) instanceof EntityHuman && !(var1 = (EntityHuman)entity).canHarmPlayer((EntityHuman)var0)) {
            return false;
        }
        return super.canHitEntity(var0) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(var0.getId()));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putShort("life", (short)this.life);
        var0.storeNullable("inBlockState", IBlockData.CODEC, this.lastState);
        var0.putByte("shake", (byte)this.shakeTime);
        var0.putBoolean("inGround", this.isInGround());
        var0.store("pickup", PickupStatus.LEGACY_CODEC, this.pickup);
        var0.putDouble("damage", this.baseDamage);
        var0.putBoolean("crit", this.isCritArrow());
        var0.putByte("PierceLevel", this.getPierceLevel());
        var0.store("SoundEvent", BuiltInRegistries.SOUND_EVENT.byNameCodec(), this.soundEvent);
        var0.store("item", ItemStack.CODEC, this.pickupItemStack);
        var0.storeNullable("weapon", ItemStack.CODEC, this.firedFromWeapon);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.life = var0.getShortOr("life", (short)0);
        this.lastState = var0.read("inBlockState", IBlockData.CODEC).orElse(null);
        this.shakeTime = var0.getByteOr("shake", (byte)0) & 0xFF;
        this.setInGround(var0.getBooleanOr("inGround", false));
        this.baseDamage = var0.getDoubleOr("damage", 2.0);
        this.pickup = var0.read("pickup", PickupStatus.LEGACY_CODEC).orElse(PickupStatus.DISALLOWED);
        this.setCritArrow(var0.getBooleanOr("crit", false));
        this.setPierceLevel(var0.getByteOr("PierceLevel", (byte)0));
        this.soundEvent = var0.read("SoundEvent", BuiltInRegistries.SOUND_EVENT.byNameCodec()).orElse(this.getDefaultHitGroundSoundEvent());
        this.setPickupItemStack(var0.read("item", ItemStack.CODEC).orElse(this.getDefaultPickupItem()));
        this.firedFromWeapon = var0.read("weapon", ItemStack.CODEC).orElse(null);
    }

    @Override
    public void setOwner(@Nullable Entity var0) {
        PickupStatus pickupStatus;
        super.setOwner(var0);
        Entity entity = var0;
        int n2 = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHuman.class, OminousItemSpawner.class}, (Object)entity, n2)) {
                case 0: {
                    EntityHuman var3 = (EntityHuman)entity;
                    if (this.pickup != PickupStatus.DISALLOWED) {
                        n2 = 1;
                        continue block4;
                    }
                    pickupStatus = PickupStatus.ALLOWED;
                    break block4;
                }
                case 1: {
                    OminousItemSpawner var4 = (OminousItemSpawner)entity;
                    pickupStatus = PickupStatus.DISALLOWED;
                    break block4;
                }
                default: {
                    pickupStatus = this.pickup;
                    break block4;
                }
            }
            break;
        }
        this.pickup = pickupStatus;
    }

    @Override
    public void playerTouch(EntityHuman var0) {
        if (this.level().isClientSide() || !this.isInGround() && !this.isNoPhysics() || this.shakeTime > 0) {
            return;
        }
        if (this.tryPickup(var0)) {
            var0.take(this, 1);
            this.discard();
        }
    }

    protected boolean tryPickup(EntityHuman var0) {
        return switch (this.pickup.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> false;
            case 1 -> var0.getInventory().add(this.getPickupItem());
            case 2 -> var0.hasInfiniteMaterials();
        };
    }

    protected ItemStack getPickupItem() {
        return this.pickupItemStack.copy();
    }

    protected abstract ItemStack getDefaultPickupItem();

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public ItemStack getPickupItemStackOrigin() {
        return this.pickupItemStack;
    }

    public void setBaseDamage(double var0) {
        this.baseDamage = var0;
    }

    @Override
    public boolean isAttackable() {
        return this.getType().is(TagsEntity.REDIRECTABLE_PROJECTILE);
    }

    public void setCritArrow(boolean var0) {
        this.setFlag(1, var0);
    }

    public void setPierceLevel(byte var0) {
        this.entityData.set(PIERCE_LEVEL, var0);
    }

    private void setFlag(int var0, boolean var1) {
        byte var2 = this.entityData.get(ID_FLAGS);
        if (var1) {
            this.entityData.set(ID_FLAGS, (byte)(var2 | var0));
        } else {
            this.entityData.set(ID_FLAGS, (byte)(var2 & ~var0));
        }
    }

    protected void setPickupItemStack(ItemStack var0) {
        this.pickupItemStack = !var0.isEmpty() ? var0 : this.getDefaultPickupItem();
    }

    public boolean isCritArrow() {
        byte var0 = this.entityData.get(ID_FLAGS);
        return (var0 & 1) != 0;
    }

    public byte getPierceLevel() {
        return this.entityData.get(PIERCE_LEVEL);
    }

    public void setBaseDamageFromMob(float var0) {
        this.setBaseDamage((double)(var0 * 2.0f) + this.random.triangle((double)this.level().getDifficulty().getId() * 0.11, 0.57425));
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public void setNoPhysics(boolean var0) {
        this.noPhysics = var0;
        this.setFlag(2, var0);
    }

    public boolean isNoPhysics() {
        if (!this.level().isClientSide()) {
            return this.noPhysics;
        }
        return (this.entityData.get(ID_FLAGS) & 2) != 0;
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.isInGround();
    }

    @Override
    public SlotAccess getSlot(int var0) {
        if (var0 == 0) {
            return SlotAccess.of(this::getPickupItemStackOrigin, this::setPickupItemStack);
        }
        return super.getSlot(var0);
    }

    @Override
    protected boolean shouldBounceOnWorldBorder() {
        return true;
    }

    public static final class PickupStatus
    extends Enum<PickupStatus> {
        public static final /* enum */ PickupStatus DISALLOWED = new PickupStatus();
        public static final /* enum */ PickupStatus ALLOWED = new PickupStatus();
        public static final /* enum */ PickupStatus CREATIVE_ONLY = new PickupStatus();
        public static final Codec<PickupStatus> LEGACY_CODEC;
        private static final /* synthetic */ PickupStatus[] e;

        public static PickupStatus[] values() {
            return (PickupStatus[])e.clone();
        }

        public static PickupStatus valueOf(String var0) {
            return Enum.valueOf(PickupStatus.class, var0);
        }

        public static PickupStatus byOrdinal(int var0) {
            if (var0 < 0 || var0 > PickupStatus.values().length) {
                var0 = 0;
            }
            return PickupStatus.values()[var0];
        }

        private static /* synthetic */ PickupStatus[] a() {
            return new PickupStatus[]{DISALLOWED, ALLOWED, CREATIVE_ONLY};
        }

        static {
            e = PickupStatus.a();
            LEGACY_CODEC = Codec.BYTE.xmap(PickupStatus::byOrdinal, var0 -> (byte)var0.ordinal());
        }
    }
}

