/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperties;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;

public class ContainerBeacon
extends Container {
    private static final int PAYMENT_SLOT = 0;
    private static final int SLOT_COUNT = 1;
    private static final int DATA_COUNT = 3;
    private static final int INV_SLOT_START = 1;
    private static final int INV_SLOT_END = 28;
    private static final int USE_ROW_SLOT_START = 28;
    private static final int USE_ROW_SLOT_END = 37;
    private static final int NO_EFFECT = 0;
    private final IInventory beacon = new InventorySubcontainer(this, 1){

        @Override
        public boolean canPlaceItem(int var0, ItemStack var1) {
            return var1.is(TagsItem.BEACON_PAYMENT_ITEMS);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }
    };
    private final SlotBeacon paymentSlot;
    private final ContainerAccess access;
    private final IContainerProperties beaconData;

    public ContainerBeacon(int var0, IInventory var1) {
        this(var0, var1, new ContainerProperties(3), ContainerAccess.NULL);
    }

    public ContainerBeacon(int var0, IInventory var1, IContainerProperties var2, ContainerAccess var3) {
        super(Containers.BEACON, var0);
        ContainerBeacon.checkContainerDataCount(var2, 3);
        this.beaconData = var2;
        this.access = var3;
        this.paymentSlot = new SlotBeacon(this.beacon, 0, 136, 110);
        this.addSlot(this.paymentSlot);
        this.addDataSlots(var2);
        this.addStandardInventorySlots(var1, 36, 137);
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        if (var0.level().isClientSide()) {
            return;
        }
        ItemStack var1 = this.paymentSlot.remove(this.paymentSlot.getMaxStackSize());
        if (!var1.isEmpty()) {
            var0.drop(var1, false);
        }
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return ContainerBeacon.stillValid(this.access, var0, Blocks.BEACON);
    }

    @Override
    public void setData(int var0, int var1) {
        super.setData(var0, var1);
        this.broadcastChanges();
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 == 0) {
                if (!this.moveItemStackTo(var4, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (!this.paymentSlot.hasItem() && this.paymentSlot.mayPlace(var4) && var4.getCount() == 1 ? !this.moveItemStackTo(var4, 0, 1, false) : (var1 >= 1 && var1 < 28 ? !this.moveItemStackTo(var4, 28, 37, false) : (var1 >= 28 && var1 < 37 ? !this.moveItemStackTo(var4, 1, 28, false) : !this.moveItemStackTo(var4, 1, 37, false)))) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }

    public int getLevels() {
        return this.beaconData.get(0);
    }

    public static int encodeEffect(@Nullable Holder<MobEffectList> var0) {
        return var0 == null ? 0 : BuiltInRegistries.MOB_EFFECT.asHolderIdMap().getId(var0) + 1;
    }

    @Nullable
    public static Holder<MobEffectList> decodeEffect(int var0) {
        return var0 == 0 ? null : BuiltInRegistries.MOB_EFFECT.asHolderIdMap().byId(var0 - 1);
    }

    @Nullable
    public Holder<MobEffectList> getPrimaryEffect() {
        return ContainerBeacon.decodeEffect(this.beaconData.get(1));
    }

    @Nullable
    public Holder<MobEffectList> getSecondaryEffect() {
        return ContainerBeacon.decodeEffect(this.beaconData.get(2));
    }

    public void updateEffects(Optional<Holder<MobEffectList>> var0, Optional<Holder<MobEffectList>> var1) {
        if (this.paymentSlot.hasItem()) {
            this.beaconData.set(1, ContainerBeacon.encodeEffect(var0.orElse(null)));
            this.beaconData.set(2, ContainerBeacon.encodeEffect(var1.orElse(null)));
            this.paymentSlot.remove(1);
            this.access.execute(World::blockEntityChanged);
        }
    }

    public boolean hasPayment() {
        return !this.beacon.getItem(0).isEmpty();
    }

    static class SlotBeacon
    extends Slot {
        public SlotBeacon(IInventory var0, int var1, int var2, int var3) {
            super(var0, var1, var2, var3);
        }

        @Override
        public boolean mayPlace(ItemStack var0) {
            return var0.is(TagsItem.BEACON_PAYMENT_ITEMS);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }
    }
}

