/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;

public class ItemCarrotStick<T extends Entity>
extends Item {
    private final EntityTypes<T> canInteractWith;
    private final int consumeItemDamage;

    public ItemCarrotStick(EntityTypes<T> var0, int var1, Item.Info var2) {
        super(var2);
        this.canInteractWith = var0;
        this.consumeItemDamage = var1;
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (var0.isClientSide()) {
            return EnumInteractionResult.PASS;
        }
        Entity var4 = var1.getControlledVehicle();
        if (var1.isPassenger() && var4 instanceof ISteerable) {
            ISteerable var5 = (ISteerable)((Object)var4);
            if (var4.getType() == this.canInteractWith && var5.boost()) {
                EnumItemSlot var6 = var2.asEquipmentSlot();
                ItemStack var7 = var3.hurtAndConvertOnBreak(this.consumeItemDamage, Items.FISHING_ROD, var1, var6);
                return EnumInteractionResult.SUCCESS_SERVER.heldItemTransformedTo(var7);
            }
        }
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        return EnumInteractionResult.PASS;
    }
}

