/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DebugStickState;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class ItemDebugStick
extends Item {
    public ItemDebugStick(Item.Info var0) {
        super(var0);
    }

    @Override
    public boolean canDestroyBlock(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityLiving var4) {
        if (!var2.isClientSide() && var4 instanceof EntityHuman) {
            EntityHuman var5 = (EntityHuman)var4;
            this.handleInteraction(var5, var1, var2, var3, false, var0);
        }
        return false;
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var3;
        EntityHuman var1 = var0.getPlayer();
        World var2 = var0.getLevel();
        if (!var2.isClientSide() && var1 != null && !this.handleInteraction(var1, var2.getBlockState(var3 = var0.getClickedPos()), var2, var3, true, var0.getItemInHand())) {
            return EnumInteractionResult.FAIL;
        }
        return EnumInteractionResult.SUCCESS;
    }

    public boolean handleInteraction(EntityHuman var0, IBlockData var1, GeneratorAccess var2, BlockPosition var3, boolean var4, ItemStack var5) {
        if (!var0.canUseGameMasterBlocks()) {
            return false;
        }
        Holder<Block> var6 = var1.getBlockHolder();
        BlockStateList<Block, IBlockData> var7 = var6.value().getStateDefinition();
        Collection<IBlockState<?>> var8 = var7.getProperties();
        if (var8.isEmpty()) {
            ItemDebugStick.message(var0, IChatBaseComponent.translatable(this.descriptionId + ".empty", var6.getRegisteredName()));
            return false;
        }
        DebugStickState var9 = var5.get(DataComponents.DEBUG_STICK_STATE);
        if (var9 == null) {
            return false;
        }
        IBlockState<?> var10 = var9.properties().get(var6);
        if (var4) {
            if (var10 == null) {
                var10 = var8.iterator().next();
            }
            IBlockData var11 = ItemDebugStick.cycleState(var1, var10, var0.isSecondaryUseActive());
            var2.setBlock(var3, var11, 18);
            ItemDebugStick.message(var0, IChatBaseComponent.translatable(this.descriptionId + ".update", var10.getName(), ItemDebugStick.getNameHelper(var11, var10)));
        } else {
            var10 = ItemDebugStick.getRelative(var8, var10, var0.isSecondaryUseActive());
            var5.set(DataComponents.DEBUG_STICK_STATE, var9.withProperty(var6, var10));
            ItemDebugStick.message(var0, IChatBaseComponent.translatable(this.descriptionId + ".select", var10.getName(), ItemDebugStick.getNameHelper(var1, var10)));
        }
        return true;
    }

    private static <T extends Comparable<T>> IBlockData cycleState(IBlockData var0, IBlockState<T> var1, boolean var2) {
        return (IBlockData)var0.setValue(var1, (Comparable)ItemDebugStick.getRelative(var1.getPossibleValues(), var0.getValue(var1), var2));
    }

    private static <T> T getRelative(Iterable<T> var0, @Nullable T var1, boolean var2) {
        return var2 ? SystemUtils.findPreviousInIterable(var0, var1) : SystemUtils.findNextInIterable(var0, var1);
    }

    private static void message(EntityHuman var0, IChatBaseComponent var1) {
        ((EntityPlayer)var0).sendSystemMessage(var1, true);
    }

    private static <T extends Comparable<T>> String getNameHelper(IBlockData var0, IBlockState<T> var1) {
        return var1.getName(var0.getValue(var1));
    }
}

