/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record InstrumentComponent(EitherHolder<Instrument> instrument) implements TooltipProvider
{
    public static final Codec<InstrumentComponent> CODEC = EitherHolder.codec(Registries.INSTRUMENT, Instrument.CODEC).xmap(InstrumentComponent::new, InstrumentComponent::instrument);
    public static final StreamCodec<RegistryFriendlyByteBuf, InstrumentComponent> STREAM_CODEC = EitherHolder.streamCodec(Registries.INSTRUMENT, Instrument.STREAM_CODEC).map(InstrumentComponent::new, InstrumentComponent::instrument);

    public InstrumentComponent(Holder<Instrument> var0) {
        this(new EitherHolder<Instrument>(var0));
    }

    @Deprecated
    public InstrumentComponent(ResourceKey<Instrument> var0) {
        this(new EitherHolder<Instrument>(var0));
    }

    @Override
    public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
        HolderLookup.a var4 = var0.registries();
        if (var4 == null) {
            return;
        }
        Optional<Holder<Instrument>> var5 = this.unwrap(var4);
        if (var5.isPresent()) {
            IChatMutableComponent var6 = var5.get().value().description().copy();
            ChatComponentUtils.mergeStyles(var6, ChatModifier.EMPTY.withColor(EnumChatFormat.GRAY));
            var1.accept(var6);
        }
    }

    public Optional<Holder<Instrument>> unwrap(HolderLookup.a var0) {
        return this.instrument.unwrap(var0);
    }
}

