/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.network.Filterable;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BookContent;
import net.minecraft.world.item.component.TooltipProvider;

public record WrittenBookContent(Filterable<String> title, String author, int generation, List<Filterable<IChatBaseComponent>> pages, boolean resolved) implements BookContent<IChatBaseComponent, WrittenBookContent>,
TooltipProvider
{
    public static final WrittenBookContent EMPTY = new WrittenBookContent(Filterable.passThrough(""), "", 0, List.of(), true);
    public static final int PAGE_LENGTH = Short.MAX_VALUE;
    public static final int TITLE_LENGTH = 16;
    public static final int TITLE_MAX_LENGTH = 32;
    public static final int MAX_GENERATION = 3;
    public static final int MAX_CRAFTABLE_GENERATION = 2;
    public static final Codec<IChatBaseComponent> CONTENT_CODEC = ComponentSerialization.flatRestrictedCodec(Short.MAX_VALUE);
    public static final Codec<List<Filterable<IChatBaseComponent>>> PAGES_CODEC = WrittenBookContent.pagesCodec(CONTENT_CODEC);
    public static final Codec<WrittenBookContent> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Filterable.codec(Codec.string((int)0, (int)32)).fieldOf("title").forGetter(WrittenBookContent::title), (App)Codec.STRING.fieldOf("author").forGetter(WrittenBookContent::author), (App)ExtraCodecs.intRange(0, 3).optionalFieldOf("generation", (Object)0).forGetter(WrittenBookContent::generation), (App)PAGES_CODEC.optionalFieldOf("pages", List.of()).forGetter(WrittenBookContent::pages), (App)Codec.BOOL.optionalFieldOf("resolved", (Object)false).forGetter(WrittenBookContent::resolved)).apply((Applicative)var0, WrittenBookContent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WrittenBookContent> STREAM_CODEC = StreamCodec.composite(Filterable.streamCodec(ByteBufCodecs.stringUtf8(32)), WrittenBookContent::title, ByteBufCodecs.STRING_UTF8, WrittenBookContent::author, ByteBufCodecs.VAR_INT, WrittenBookContent::generation, Filterable.streamCodec(ComponentSerialization.STREAM_CODEC).apply(ByteBufCodecs.list()), WrittenBookContent::pages, ByteBufCodecs.BOOL, WrittenBookContent::resolved, WrittenBookContent::new);

    public WrittenBookContent {
        if (var2 < 0 || var2 > 3) {
            throw new IllegalArgumentException("Generation was " + var2 + ", but must be between 0 and 3");
        }
    }

    private static Codec<Filterable<IChatBaseComponent>> pageCodec(Codec<IChatBaseComponent> var0) {
        return Filterable.codec(var0);
    }

    public static Codec<List<Filterable<IChatBaseComponent>>> pagesCodec(Codec<IChatBaseComponent> var0) {
        return WrittenBookContent.pageCodec(var0).listOf();
    }

    @Nullable
    public WrittenBookContent tryCraftCopy() {
        if (this.generation >= 2) {
            return null;
        }
        return new WrittenBookContent(this.title, this.author, this.generation + 1, this.pages, this.resolved);
    }

    public static boolean resolveForItem(ItemStack var0, CommandListenerWrapper var1, @Nullable EntityHuman var2) {
        WrittenBookContent var3 = var0.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (var3 != null && !var3.resolved()) {
            WrittenBookContent var4 = var3.resolve(var1, var2);
            if (var4 != null) {
                var0.set(DataComponents.WRITTEN_BOOK_CONTENT, var4);
                return true;
            }
            var0.set(DataComponents.WRITTEN_BOOK_CONTENT, var3.markResolved());
        }
        return false;
    }

    @Nullable
    public WrittenBookContent resolve(CommandListenerWrapper var0, @Nullable EntityHuman var1) {
        if (this.resolved) {
            return null;
        }
        ImmutableList.Builder var2 = ImmutableList.builderWithExpectedSize((int)this.pages.size());
        for (Filterable<IChatBaseComponent> var4 : this.pages) {
            Optional<Filterable<IChatBaseComponent>> var5 = WrittenBookContent.resolvePage(var0, var1, var4);
            if (var5.isEmpty()) {
                return null;
            }
            var2.add(var5.get());
        }
        return new WrittenBookContent(this.title, this.author, this.generation, (List<Filterable<IChatBaseComponent>>)var2.build(), true);
    }

    public WrittenBookContent markResolved() {
        return new WrittenBookContent(this.title, this.author, this.generation, this.pages, true);
    }

    private static Optional<Filterable<IChatBaseComponent>> resolvePage(CommandListenerWrapper var0, @Nullable EntityHuman var1, Filterable<IChatBaseComponent> var22) {
        return var22.resolve(var2 -> {
            try {
                IChatMutableComponent var3 = ChatComponentUtils.updateForEntity(var0, var2, (Entity)var1, 0);
                if (WrittenBookContent.isPageTooLarge(var3, var0.registryAccess())) {
                    return Optional.empty();
                }
                return Optional.of(var3);
            }
            catch (Exception var3) {
                return Optional.of(var2);
            }
        });
    }

    private static boolean isPageTooLarge(IChatBaseComponent var0, HolderLookup.a var1) {
        DataResult var2 = ComponentSerialization.CODEC.encodeStart(var1.createSerializationContext(JsonOps.INSTANCE), (Object)var0);
        return var2.isSuccess() && ChatDeserializer.encodesLongerThan((JsonElement)var2.getOrThrow(), Short.MAX_VALUE);
    }

    public List<IChatBaseComponent> getPages(boolean var0) {
        return Lists.transform(this.pages, var1 -> (IChatBaseComponent)var1.get(var0));
    }

    @Override
    public WrittenBookContent withReplacedPages(List<Filterable<IChatBaseComponent>> var0) {
        return new WrittenBookContent(this.title, this.author, this.generation, var0, false);
    }

    @Override
    public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
        if (!UtilColor.isBlank(this.author)) {
            var1.accept(IChatBaseComponent.translatable("book.byAuthor", this.author).withStyle(EnumChatFormat.GRAY));
        }
        var1.accept(IChatBaseComponent.translatable("book.generation." + this.generation).withStyle(EnumChatFormat.GRAY));
    }

    @Override
    public /* synthetic */ Object withReplacedPages(List list) {
        return this.withReplacedPages(list);
    }
}

