/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeSingleItem;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.display.FurnaceRecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public abstract class RecipeCooking
extends RecipeSingleItem {
    private final CookingBookCategory category;
    private final float experience;
    private final int cookingTime;

    public RecipeCooking(String var0, CookingBookCategory var1, RecipeItemStack var2, ItemStack var3, float var4, int var5) {
        super(var0, var2, var3);
        this.category = var1;
        this.experience = var4;
        this.cookingTime = var5;
    }

    @Override
    public abstract RecipeSerializer<? extends RecipeCooking> getSerializer();

    @Override
    public abstract Recipes<? extends RecipeCooking> getType();

    public float experience() {
        return this.experience;
    }

    public int cookingTime() {
        return this.cookingTime;
    }

    public CookingBookCategory category() {
        return this.category;
    }

    protected abstract Item furnaceIcon();

    @Override
    public List<RecipeDisplay> display() {
        return List.of(new FurnaceRecipeDisplay(this.input().display(), SlotDisplay.a.INSTANCE, new SlotDisplay.f(this.result()), new SlotDisplay.d(this.furnaceIcon()), this.cookingTime, this.experience));
    }

    @FunctionalInterface
    public static interface a<T extends RecipeCooking> {
        public T create(String var1, CookingBookCategory var2, RecipeItemStack var3, ItemStack var4, float var5, int var6);
    }

    public static class b<T extends RecipeCooking>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(var2 -> var2.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(RecipeSingleItem::group), (App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter(RecipeCooking::category), (App)RecipeItemStack.CODEC.fieldOf("ingredient").forGetter(RecipeSingleItem::input), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("result").forGetter(RecipeSingleItem::result), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(RecipeCooking::experience), (App)Codec.INT.fieldOf("cookingtime").orElse((Object)var1).forGetter(RecipeCooking::cookingTime)).apply((Applicative)var2, var0::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, RecipeSingleItem::group, CookingBookCategory.STREAM_CODEC, RecipeCooking::category, RecipeItemStack.CONTENTS_STREAM_CODEC, RecipeSingleItem::input, ItemStack.STREAM_CODEC, RecipeSingleItem::result, ByteBufCodecs.FLOAT, RecipeCooking::experience, ByteBufCodecs.INT, RecipeCooking::cookingTime, var0::create);

        public b(a<T> var0, int var1) {
        }

        @Override
        public MapCodec<T> codec() {
            return this.codec;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }
}

