/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.math.PointGroupO;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerGrindstone;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockGrindstone
extends BlockAttachable {
    public static final MapCodec<BlockGrindstone> CODEC = BlockGrindstone.simpleCodec(BlockGrindstone::new);
    private static final IChatBaseComponent CONTAINER_TITLE = IChatBaseComponent.translatable("container.grindstone_title");
    private final Function<IBlockData, VoxelShape> shapes;

    public MapCodec<BlockGrindstone> codec() {
        return CODEC;
    }

    protected BlockGrindstone(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(FACE, BlockPropertyAttachPosition.WALL));
        this.shapes = this.makeShapes();
    }

    private Function<IBlockData, VoxelShape> makeShapes() {
        VoxelShape var0 = VoxelShapes.or(Block.box(2.0, 6.0, 7.0, 4.0, 10.0, 16.0), Block.box(2.0, 5.0, 3.0, 4.0, 11.0, 9.0));
        VoxelShape var12 = VoxelShapes.rotate(var0, PointGroupO.INVERT_X);
        VoxelShape var2 = VoxelShapes.or(Block.boxZ(8.0, 2.0, 14.0, 0.0, 12.0), var0, var12);
        Map<BlockPropertyAttachPosition, Map<EnumDirection, VoxelShape>> var3 = VoxelShapes.rotateAttachFace(var2);
        return this.getShapeForEachState(var1 -> (VoxelShape)((Map)var3.get(var1.getValue(FACE))).get(var1.getValue(FACING)));
    }

    private VoxelShape getVoxelShape(IBlockData var0) {
        return this.shapes.apply(var0);
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.getVoxelShape(var0);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.getVoxelShape(var0);
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return true;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (!var1.isClientSide()) {
            var3.openMenu(var0.getMenuProvider(var1, var2));
            var3.awardStat(StatisticList.INTERACT_WITH_GRINDSTONE);
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected ITileInventory getMenuProvider(IBlockData var0, World var1, BlockPosition var22) {
        return new TileInventory((var2, var3, var4) -> new ContainerGrindstone(var2, var3, ContainerAccess.create(var1, var22)), CONTAINER_TITLE);
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate((EnumDirection)var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation((EnumDirection)var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, FACE);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

