/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerSmithing;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockWorkbench;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockSmithingTable
extends BlockWorkbench {
    public static final MapCodec<BlockSmithingTable> CODEC = BlockSmithingTable.simpleCodec(BlockSmithingTable::new);
    private static final IChatBaseComponent CONTAINER_TITLE = IChatBaseComponent.translatable("container.upgrade");

    public MapCodec<BlockSmithingTable> codec() {
        return CODEC;
    }

    protected BlockSmithingTable(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected ITileInventory getMenuProvider(IBlockData var0, World var1, BlockPosition var22) {
        return new TileInventory((var2, var3, var4) -> new ContainerSmithing(var2, var3, ContainerAccess.create(var1, var22)), CONTAINER_TITLE);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (!var1.isClientSide()) {
            var3.openMenu(var0.getMenuProvider(var1, var2));
            var3.awardStat(StatisticList.INTERACT_WITH_SMITHING_TABLE);
        }
        return EnumInteractionResult.SUCCESS;
    }
}

