/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;

public class CreakingHeartBlock
extends BlockTileEntity {
    public static final MapCodec<CreakingHeartBlock> CODEC = CreakingHeartBlock.simpleCodec(CreakingHeartBlock::new);
    public static final BlockStateEnum<EnumDirection.EnumAxis> AXIS = BlockProperties.AXIS;
    public static final BlockStateEnum<CreakingHeartState> STATE = BlockProperties.CREAKING_HEART_STATE;
    public static final BlockStateBoolean NATURAL = BlockProperties.NATURAL;

    public MapCodec<CreakingHeartBlock> codec() {
        return CODEC;
    }

    protected CreakingHeartBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(AXIS, EnumDirection.EnumAxis.Y)).setValue(STATE, CreakingHeartState.UPROOTED)).setValue(NATURAL, false));
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new CreakingHeartBlockEntity(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        if (var0.isClientSide()) {
            return null;
        }
        if (var1.getValue(STATE) != CreakingHeartState.UPROOTED) {
            return CreakingHeartBlock.createTickerHelper(var2, TileEntityTypes.CREAKING_HEART, CreakingHeartBlockEntity::serverTick);
        }
        return null;
    }

    public static boolean isNaturalNight(World var0) {
        return var0.isMoonVisible();
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (!CreakingHeartBlock.isNaturalNight(var1)) {
            return;
        }
        if (var0.getValue(STATE) == CreakingHeartState.UPROOTED) {
            return;
        }
        if (var3.nextInt(16) == 0 && CreakingHeartBlock.isSurroundedByLogs(var1, var2)) {
            var1.playLocalSound(var2.getX(), var2.getY(), var2.getZ(), SoundEffects.CREAKING_HEART_IDLE, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        var2.scheduleTick(var3, this, 1);
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        IBlockData var4 = CreakingHeartBlock.updateState(var0, var1, var2);
        if (var4 != var0) {
            var1.setBlock(var2, var4, 3);
        }
    }

    private static IBlockData updateState(IBlockData var0, World var1, BlockPosition var2) {
        boolean var4;
        boolean var3 = CreakingHeartBlock.hasRequiredLogs(var0, var1, var2);
        boolean bl = var4 = var0.getValue(STATE) == CreakingHeartState.UPROOTED;
        if (var3 && var4) {
            return (IBlockData)var0.setValue(STATE, CreakingHeartBlock.isNaturalNight(var1) ? CreakingHeartState.AWAKE : CreakingHeartState.DORMANT);
        }
        return var0;
    }

    public static boolean hasRequiredLogs(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        EnumDirection.EnumAxis var3 = var0.getValue(AXIS);
        for (EnumDirection var7 : var3.getDirections()) {
            IBlockData var8 = var1.getBlockState(var2.relative(var7));
            if (var8.is(TagsBlock.PALE_OAK_LOGS) && var8.getValue(AXIS) == var3) continue;
            return false;
        }
        return true;
    }

    private static boolean isSurroundedByLogs(GeneratorAccess var0, BlockPosition var1) {
        for (EnumDirection var5 : EnumDirection.values()) {
            BlockPosition var6 = var1.relative(var5);
            IBlockData var7 = var0.getBlockState(var6);
            if (var7.is(TagsBlock.PALE_OAK_LOGS)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return CreakingHeartBlock.updateState((IBlockData)this.defaultBlockState().setValue(AXIS, var0.getClickedFace().getAxis()), var0.getLevel(), var0.getClickedPos());
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return BlockRotatable.rotatePillar(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AXIS, STATE, NATURAL);
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        InventoryUtils.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    @Override
    protected void onExplosionHit(IBlockData var0, WorldServer var1, BlockPosition var2, Explosion var3, BiConsumer<ItemStack, BlockPosition> var4) {
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (tileEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity var5 = (CreakingHeartBlockEntity)tileEntity;
            if (var3 instanceof ServerExplosion) {
                ServerExplosion var6 = (ServerExplosion)var3;
                if (var3.getBlockInteraction().shouldAffectBlocklikeEntities()) {
                    var5.removeProtector(var6.getDamageSource());
                    EntityLiving entityLiving = var3.getIndirectSourceEntity();
                    if (entityLiving instanceof EntityHuman) {
                        EntityHuman var7 = (EntityHuman)entityLiving;
                        if (var3.getBlockInteraction().shouldAffectBlocklikeEntities()) {
                            this.tryAwardExperience(var7, var0, var1, var2);
                        }
                    }
                }
            }
        }
        super.onExplosionHit(var0, var1, var2, var3, var4);
    }

    @Override
    public IBlockData playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        TileEntity tileEntity = var0.getBlockEntity(var1);
        if (tileEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity var4 = (CreakingHeartBlockEntity)tileEntity;
            var4.removeProtector(var3.damageSources().playerAttack(var3));
            this.tryAwardExperience(var3, var2, var0, var1);
        }
        return super.playerWillDestroy(var0, var1, var2, var3);
    }

    private void tryAwardExperience(EntityHuman var0, IBlockData var1, World var2, BlockPosition var3) {
        if (!var0.preventsBlockDrops() && !var0.isSpectator() && var1.getValue(NATURAL).booleanValue() && var2 instanceof WorldServer) {
            WorldServer var4 = (WorldServer)var2;
            this.popExperience(var4, var3, var2.random.nextIntBetweenInclusive(20, 24));
        }
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3) {
        if (var0.getValue(STATE) == CreakingHeartState.UPROOTED) {
            return 0;
        }
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (!(tileEntity instanceof CreakingHeartBlockEntity)) {
            return 0;
        }
        CreakingHeartBlockEntity var4 = (CreakingHeartBlockEntity)tileEntity;
        return var4.getAnalogOutputSignal();
    }
}

