/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class DecoratedPotBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<DecoratedPotBlock> CODEC = DecoratedPotBlock.simpleCodec(DecoratedPotBlock::new);
    public static final MinecraftKey SHERDS_DYNAMIC_DROP_ID = MinecraftKey.withDefaultNamespace("sherds");
    public static final BlockStateEnum<EnumDirection> HORIZONTAL_FACING = BlockProperties.HORIZONTAL_FACING;
    public static final BlockStateBoolean CRACKED = BlockProperties.CRACKED;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.column(14.0, 0.0, 16.0);

    public MapCodec<DecoratedPotBlock> codec() {
        return CODEC;
    }

    protected DecoratedPotBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(HORIZONTAL_FACING, EnumDirection.NORTH)).setValue(WATERLOGGED, false)).setValue(CRACKED, false));
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        return (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(HORIZONTAL_FACING, var0.getHorizontalDirection())).setValue(WATERLOGGED, var1.getType() == FluidTypes.WATER)).setValue(CRACKED, false);
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        TileEntity tileEntity = var2.getBlockEntity(var3);
        if (!(tileEntity instanceof DecoratedPotBlockEntity)) {
            return EnumInteractionResult.PASS;
        }
        DecoratedPotBlockEntity var7 = (DecoratedPotBlockEntity)tileEntity;
        if (var2.isClientSide()) {
            return EnumInteractionResult.SUCCESS;
        }
        ItemStack var8 = var7.getTheItem();
        if (!var0.isEmpty() && (var8.isEmpty() || ItemStack.isSameItemSameComponents(var8, var0) && var8.getCount() < var8.getMaxStackSize())) {
            float var10;
            var7.wobble(DecoratedPotBlockEntity.a.POSITIVE);
            var4.awardStat(StatisticList.ITEM_USED.get(var0.getItem()));
            ItemStack var9 = var0.consumeAndReturn(1, var4);
            if (var7.isEmpty()) {
                var7.setTheItem(var9);
                var10 = (float)var9.getCount() / (float)var9.getMaxStackSize();
            } else {
                var8.grow(1);
                var10 = (float)var8.getCount() / (float)var8.getMaxStackSize();
            }
            var2.playSound(null, var3, SoundEffects.DECORATED_POT_INSERT, SoundCategory.BLOCKS, 1.0f, 0.7f + 0.5f * var10);
            if (var2 instanceof WorldServer) {
                WorldServer var11 = (WorldServer)var2;
                var11.sendParticles(Particles.DUST_PLUME, (double)var3.getX() + 0.5, (double)var3.getY() + 1.2, (double)var3.getZ() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
            }
            var7.setChanged();
            var2.gameEvent((Entity)var4, GameEvent.BLOCK_CHANGE, var3);
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (!(tileEntity instanceof DecoratedPotBlockEntity)) {
            return EnumInteractionResult.PASS;
        }
        DecoratedPotBlockEntity var5 = (DecoratedPotBlockEntity)tileEntity;
        var1.playSound(null, var2, SoundEffects.DECORATED_POT_INSERT_FAIL, SoundCategory.BLOCKS, 1.0f, 1.0f);
        var5.wobble(DecoratedPotBlockEntity.a.NEGATIVE);
        var1.gameEvent((Entity)var3, GameEvent.BLOCK_CHANGE, var2);
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(HORIZONTAL_FACING, WATERLOGGED, CRACKED);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new DecoratedPotBlockEntity(var0, var1);
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        InventoryUtils.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    @Override
    protected List<ItemStack> getDrops(IBlockData var0, LootParams.a var12) {
        TileEntity var2 = var12.getOptionalParameter(LootContextParameters.BLOCK_ENTITY);
        if (var2 instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity var3 = (DecoratedPotBlockEntity)var2;
            var12.withDynamicDrop(SHERDS_DYNAMIC_DROP_ID, var1 -> {
                for (Item var3 : var3.getDecorations().ordered()) {
                    var1.accept(var3.getDefaultInstance());
                }
            });
        }
        return super.getDrops(var0, var12);
    }

    @Override
    public IBlockData playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        ItemStack var4 = var3.getMainHandItem();
        IBlockData var5 = var2;
        if (var4.is(TagsItem.BREAKS_DECORATED_POTS) && !EnchantmentManager.hasTag(var4, EnchantmentTags.PREVENTS_DECORATED_POT_SHATTERING)) {
            var5 = (IBlockData)var2.setValue(CRACKED, true);
            var0.setBlock(var1, var5, 260);
        }
        return super.playerWillDestroy(var0, var1, var5, var3);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected SoundEffectType getSoundType(IBlockData var0) {
        if (var0.getValue(CRACKED).booleanValue()) {
            return SoundEffectType.DECORATED_POT_CRACKED;
        }
        return SoundEffectType.DECORATED_POT;
    }

    @Override
    protected void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
        WorldServer var5;
        BlockPosition var4 = var2.getBlockPos();
        if (var0 instanceof WorldServer && var3.mayInteract(var5 = (WorldServer)var0, var4) && var3.mayBreak(var5)) {
            var0.setBlock(var4, (IBlockData)var1.setValue(CRACKED, true), 260);
            var0.destroyBlock(var4, true, var3);
        }
    }

    @Override
    protected ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        TileEntity tileEntity = var0.getBlockEntity(var1);
        if (tileEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity var4 = (DecoratedPotBlockEntity)tileEntity;
            PotDecorations var5 = var4.getDecorations();
            return DecoratedPotBlockEntity.createDecoratedPotItem(var5);
        }
        return super.getCloneItemStack(var0, var1, var2, var3);
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3) {
        return Container.getRedstoneSignalFromBlockEntity(var1.getBlockEntity(var2));
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(HORIZONTAL_FACING, var1.rotate(var0.getValue(HORIZONTAL_FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(HORIZONTAL_FACING)));
    }
}

