/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class FrogspawnBlock
extends Block {
    public static final MapCodec<FrogspawnBlock> CODEC = FrogspawnBlock.simpleCodec(FrogspawnBlock::new);
    private static final int MIN_TADPOLES_SPAWN = 2;
    private static final int MAX_TADPOLES_SPAWN = 5;
    private static final int DEFAULT_MIN_HATCH_TICK_DELAY = 3600;
    private static final int DEFAULT_MAX_HATCH_TICK_DELAY = 12000;
    private static final VoxelShape SHAPE = Block.column(16.0, 0.0, 1.5);
    private static int minHatchTickDelay = 3600;
    private static int maxHatchTickDelay = 12000;

    public MapCodec<FrogspawnBlock> codec() {
        return CODEC;
    }

    public FrogspawnBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return FrogspawnBlock.mayPlaceOn(var1, var2.below());
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        var1.scheduleTick(var2, this, FrogspawnBlock.getFrogspawnHatchDelay(var1.getRandom()));
    }

    private static int getFrogspawnHatchDelay(RandomSource var0) {
        return var0.nextInt(minHatchTickDelay, maxHatchTickDelay);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (!this.canSurvive(var0, var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!this.canSurvive(var0, var1, var2)) {
            this.destroyBlock(var1, var2);
            return;
        }
        this.hatchFrogspawn(var1, var2, var3);
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4, boolean var5) {
        if (var3.getType().equals(EntityTypes.FALLING_BLOCK)) {
            this.destroyBlock(var1, var2);
        }
    }

    private static boolean mayPlaceOn(IBlockAccess var0, BlockPosition var1) {
        Fluid var2 = var0.getFluidState(var1);
        Fluid var3 = var0.getFluidState(var1.above());
        return var2.getType() == FluidTypes.WATER && var3.getType() == FluidTypes.EMPTY;
    }

    private void hatchFrogspawn(WorldServer var0, BlockPosition var1, RandomSource var2) {
        this.destroyBlock(var0, var1);
        var0.playSound(null, var1, SoundEffects.FROGSPAWN_HATCH, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.spawnTadpoles(var0, var1, var2);
    }

    private void destroyBlock(World var0, BlockPosition var1) {
        var0.destroyBlock(var1, false);
    }

    private void spawnTadpoles(WorldServer var0, BlockPosition var1, RandomSource var2) {
        int var3 = var2.nextInt(2, 6);
        for (int var4 = 1; var4 <= var3; ++var4) {
            Tadpole var5 = EntityTypes.TADPOLE.create(var0, EntitySpawnReason.BREEDING);
            if (var5 == null) continue;
            double var6 = (double)var1.getX() + this.getRandomTadpolePositionOffset(var2);
            double var8 = (double)var1.getZ() + this.getRandomTadpolePositionOffset(var2);
            int var10 = var2.nextInt(1, 361);
            var5.snapTo(var6, (double)var1.getY() - 0.5, var8, var10, 0.0f);
            var5.setPersistenceRequired();
            var0.addFreshEntity(var5);
        }
    }

    private double getRandomTadpolePositionOffset(RandomSource var0) {
        double var1 = 0.2f;
        return MathHelper.clamp(var0.nextDouble(), (double)0.2f, 0.7999999970197678);
    }

    @VisibleForTesting
    public static void setHatchDelay(int var0, int var1) {
        minHatchTickDelay = var0;
        maxHatchTickDelay = var1;
    }

    @VisibleForTesting
    public static void setDefaultHatchDelay() {
        minHatchTickDelay = 3600;
        maxHatchTickDelay = 12000;
    }
}

