/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;

public class MinecartTrackLogic {
    private final World level;
    private final BlockPosition pos;
    private final BlockMinecartTrackAbstract block;
    private IBlockData state;
    private final boolean isStraight;
    private final List<BlockPosition> connections = Lists.newArrayList();

    public MinecartTrackLogic(World var0, BlockPosition var1, IBlockData var2) {
        this.level = var0;
        this.pos = var1;
        this.state = var2;
        this.block = (BlockMinecartTrackAbstract)var2.getBlock();
        BlockPropertyTrackPosition var3 = var2.getValue(this.block.getShapeProperty());
        this.isStraight = this.block.isStraight();
        this.updateConnections(var3);
    }

    public List<BlockPosition> getConnections() {
        return this.connections;
    }

    private void updateConnections(BlockPropertyTrackPosition var0) {
        this.connections.clear();
        switch (var0) {
            case NORTH_SOUTH: {
                this.connections.add(this.pos.north());
                this.connections.add(this.pos.south());
                break;
            }
            case EAST_WEST: {
                this.connections.add(this.pos.west());
                this.connections.add(this.pos.east());
                break;
            }
            case ASCENDING_EAST: {
                this.connections.add(this.pos.west());
                this.connections.add(this.pos.east().above());
                break;
            }
            case ASCENDING_WEST: {
                this.connections.add(this.pos.west().above());
                this.connections.add(this.pos.east());
                break;
            }
            case ASCENDING_NORTH: {
                this.connections.add(this.pos.north().above());
                this.connections.add(this.pos.south());
                break;
            }
            case ASCENDING_SOUTH: {
                this.connections.add(this.pos.north());
                this.connections.add(this.pos.south().above());
                break;
            }
            case SOUTH_EAST: {
                this.connections.add(this.pos.east());
                this.connections.add(this.pos.south());
                break;
            }
            case SOUTH_WEST: {
                this.connections.add(this.pos.west());
                this.connections.add(this.pos.south());
                break;
            }
            case NORTH_WEST: {
                this.connections.add(this.pos.west());
                this.connections.add(this.pos.north());
                break;
            }
            case NORTH_EAST: {
                this.connections.add(this.pos.east());
                this.connections.add(this.pos.north());
            }
        }
    }

    private void removeSoftConnections() {
        for (int var0 = 0; var0 < this.connections.size(); ++var0) {
            MinecartTrackLogic var1 = this.getRail(this.connections.get(var0));
            if (var1 == null || !var1.connectsTo(this)) {
                this.connections.remove(var0--);
                continue;
            }
            this.connections.set(var0, var1.pos);
        }
    }

    private boolean hasRail(BlockPosition var0) {
        return BlockMinecartTrackAbstract.isRail(this.level, var0) || BlockMinecartTrackAbstract.isRail(this.level, var0.above()) || BlockMinecartTrackAbstract.isRail(this.level, var0.below());
    }

    @Nullable
    private MinecartTrackLogic getRail(BlockPosition var0) {
        BlockPosition var1 = var0;
        IBlockData var2 = this.level.getBlockState(var1);
        if (BlockMinecartTrackAbstract.isRail(var2)) {
            return new MinecartTrackLogic(this.level, var1, var2);
        }
        var1 = var0.above();
        var2 = this.level.getBlockState(var1);
        if (BlockMinecartTrackAbstract.isRail(var2)) {
            return new MinecartTrackLogic(this.level, var1, var2);
        }
        var1 = var0.below();
        var2 = this.level.getBlockState(var1);
        if (BlockMinecartTrackAbstract.isRail(var2)) {
            return new MinecartTrackLogic(this.level, var1, var2);
        }
        return null;
    }

    private boolean connectsTo(MinecartTrackLogic var0) {
        return this.hasConnection(var0.pos);
    }

    private boolean hasConnection(BlockPosition var0) {
        for (int var1 = 0; var1 < this.connections.size(); ++var1) {
            BlockPosition var2 = this.connections.get(var1);
            if (var2.getX() != var0.getX() || var2.getZ() != var0.getZ()) continue;
            return true;
        }
        return false;
    }

    protected int countPotentialConnections() {
        int var0 = 0;
        for (EnumDirection var2 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            if (!this.hasRail(this.pos.relative(var2))) continue;
            ++var0;
        }
        return var0;
    }

    private boolean canConnectTo(MinecartTrackLogic var0) {
        return this.connectsTo(var0) || this.connections.size() != 2;
    }

    private void connectTo(MinecartTrackLogic var0) {
        this.connections.add(var0.pos);
        BlockPosition var1 = this.pos.north();
        BlockPosition var2 = this.pos.south();
        BlockPosition var3 = this.pos.west();
        BlockPosition var4 = this.pos.east();
        boolean var5 = this.hasConnection(var1);
        boolean var6 = this.hasConnection(var2);
        boolean var7 = this.hasConnection(var3);
        boolean var8 = this.hasConnection(var4);
        BlockPropertyTrackPosition var9 = null;
        if (var5 || var6) {
            var9 = BlockPropertyTrackPosition.NORTH_SOUTH;
        }
        if (var7 || var8) {
            var9 = BlockPropertyTrackPosition.EAST_WEST;
        }
        if (!this.isStraight) {
            if (var6 && var8 && !var5 && !var7) {
                var9 = BlockPropertyTrackPosition.SOUTH_EAST;
            }
            if (var6 && var7 && !var5 && !var8) {
                var9 = BlockPropertyTrackPosition.SOUTH_WEST;
            }
            if (var5 && var7 && !var6 && !var8) {
                var9 = BlockPropertyTrackPosition.NORTH_WEST;
            }
            if (var5 && var8 && !var6 && !var7) {
                var9 = BlockPropertyTrackPosition.NORTH_EAST;
            }
        }
        if (var9 == BlockPropertyTrackPosition.NORTH_SOUTH) {
            if (BlockMinecartTrackAbstract.isRail(this.level, var1.above())) {
                var9 = BlockPropertyTrackPosition.ASCENDING_NORTH;
            }
            if (BlockMinecartTrackAbstract.isRail(this.level, var2.above())) {
                var9 = BlockPropertyTrackPosition.ASCENDING_SOUTH;
            }
        }
        if (var9 == BlockPropertyTrackPosition.EAST_WEST) {
            if (BlockMinecartTrackAbstract.isRail(this.level, var4.above())) {
                var9 = BlockPropertyTrackPosition.ASCENDING_EAST;
            }
            if (BlockMinecartTrackAbstract.isRail(this.level, var3.above())) {
                var9 = BlockPropertyTrackPosition.ASCENDING_WEST;
            }
        }
        if (var9 == null) {
            var9 = BlockPropertyTrackPosition.NORTH_SOUTH;
        }
        this.state = (IBlockData)this.state.setValue(this.block.getShapeProperty(), var9);
        this.level.setBlock(this.pos, this.state, 3);
    }

    private boolean hasNeighborRail(BlockPosition var0) {
        MinecartTrackLogic var1 = this.getRail(var0);
        if (var1 == null) {
            return false;
        }
        var1.removeSoftConnections();
        return var1.canConnectTo(this);
    }

    public MinecartTrackLogic place(boolean var0, boolean var1, BlockPropertyTrackPosition var2) {
        boolean var17;
        boolean var13;
        BlockPosition var3 = this.pos.north();
        BlockPosition var4 = this.pos.south();
        BlockPosition var5 = this.pos.west();
        BlockPosition var6 = this.pos.east();
        boolean var7 = this.hasNeighborRail(var3);
        boolean var8 = this.hasNeighborRail(var4);
        boolean var9 = this.hasNeighborRail(var5);
        boolean var10 = this.hasNeighborRail(var6);
        BlockPropertyTrackPosition var11 = null;
        boolean var12 = var7 || var8;
        boolean bl = var13 = var9 || var10;
        if (var12 && !var13) {
            var11 = BlockPropertyTrackPosition.NORTH_SOUTH;
        }
        if (var13 && !var12) {
            var11 = BlockPropertyTrackPosition.EAST_WEST;
        }
        boolean var14 = var8 && var10;
        boolean var15 = var8 && var9;
        boolean var16 = var7 && var10;
        boolean bl2 = var17 = var7 && var9;
        if (!this.isStraight) {
            if (var14 && !var7 && !var9) {
                var11 = BlockPropertyTrackPosition.SOUTH_EAST;
            }
            if (var15 && !var7 && !var10) {
                var11 = BlockPropertyTrackPosition.SOUTH_WEST;
            }
            if (var17 && !var8 && !var10) {
                var11 = BlockPropertyTrackPosition.NORTH_WEST;
            }
            if (var16 && !var8 && !var9) {
                var11 = BlockPropertyTrackPosition.NORTH_EAST;
            }
        }
        if (var11 == null) {
            if (var12 && var13) {
                var11 = var2;
            } else if (var12) {
                var11 = BlockPropertyTrackPosition.NORTH_SOUTH;
            } else if (var13) {
                var11 = BlockPropertyTrackPosition.EAST_WEST;
            }
            if (!this.isStraight) {
                if (var0) {
                    if (var14) {
                        var11 = BlockPropertyTrackPosition.SOUTH_EAST;
                    }
                    if (var15) {
                        var11 = BlockPropertyTrackPosition.SOUTH_WEST;
                    }
                    if (var16) {
                        var11 = BlockPropertyTrackPosition.NORTH_EAST;
                    }
                    if (var17) {
                        var11 = BlockPropertyTrackPosition.NORTH_WEST;
                    }
                } else {
                    if (var17) {
                        var11 = BlockPropertyTrackPosition.NORTH_WEST;
                    }
                    if (var16) {
                        var11 = BlockPropertyTrackPosition.NORTH_EAST;
                    }
                    if (var15) {
                        var11 = BlockPropertyTrackPosition.SOUTH_WEST;
                    }
                    if (var14) {
                        var11 = BlockPropertyTrackPosition.SOUTH_EAST;
                    }
                }
            }
        }
        if (var11 == BlockPropertyTrackPosition.NORTH_SOUTH) {
            if (BlockMinecartTrackAbstract.isRail(this.level, var3.above())) {
                var11 = BlockPropertyTrackPosition.ASCENDING_NORTH;
            }
            if (BlockMinecartTrackAbstract.isRail(this.level, var4.above())) {
                var11 = BlockPropertyTrackPosition.ASCENDING_SOUTH;
            }
        }
        if (var11 == BlockPropertyTrackPosition.EAST_WEST) {
            if (BlockMinecartTrackAbstract.isRail(this.level, var6.above())) {
                var11 = BlockPropertyTrackPosition.ASCENDING_EAST;
            }
            if (BlockMinecartTrackAbstract.isRail(this.level, var5.above())) {
                var11 = BlockPropertyTrackPosition.ASCENDING_WEST;
            }
        }
        if (var11 == null) {
            var11 = var2;
        }
        this.updateConnections(var11);
        this.state = (IBlockData)this.state.setValue(this.block.getShapeProperty(), var11);
        if (var1 || this.level.getBlockState(this.pos) != this.state) {
            this.level.setBlock(this.pos, this.state, 3);
            for (int var18 = 0; var18 < this.connections.size(); ++var18) {
                MinecartTrackLogic var19 = this.getRail(this.connections.get(var18));
                if (var19 == null) continue;
                var19.removeSoftConnections();
                if (!var19.canConnectTo(this)) continue;
                var19.connectTo(this);
            }
        }
        return this;
    }

    public IBlockData getState() {
        return this.state;
    }
}

