/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public interface PlayerDetector {
    public static final PlayerDetector NO_CREATIVE_PLAYERS = (var0, var1, var2, var32, var5) -> var1.getPlayers(var0, var3 -> var3.blockPosition().closerThan(var2, var32) && !var3.isCreative() && !var3.isSpectator()).stream().filter(var3 -> !var5 || PlayerDetector.inLineOfSight(var0, var2.getCenter(), var3.getEyePosition())).map(Entity::getUUID).toList();
    public static final PlayerDetector INCLUDING_CREATIVE_PLAYERS = (var0, var1, var2, var32, var5) -> var1.getPlayers(var0, var3 -> var3.blockPosition().closerThan(var2, var32) && !var3.isSpectator()).stream().filter(var3 -> !var5 || PlayerDetector.inLineOfSight(var0, var2.getCenter(), var3.getEyePosition())).map(Entity::getUUID).toList();
    public static final PlayerDetector SHEEP = (var0, var1, var2, var32, var5) -> {
        AxisAlignedBB var6 = new AxisAlignedBB(var2).inflate(var32);
        return var1.getEntities(var0, EntityTypes.SHEEP, var6, EntityLiving::isAlive).stream().filter(var3 -> !var5 || PlayerDetector.inLineOfSight(var0, var2.getCenter(), var3.getEyePosition())).map(Entity::getUUID).toList();
    };

    public List<UUID> detect(WorldServer var1, a var2, BlockPosition var3, double var4, boolean var6);

    private static boolean inLineOfSight(World var0, Vec3D var1, Vec3D var2) {
        MovingObjectPositionBlock var3 = var0.clip(new RayTrace(var2, var1, RayTrace.BlockCollisionOption.VISUAL, RayTrace.FluidCollisionOption.NONE, VoxelShapeCollision.empty()));
        return var3.getBlockPos().equals(BlockPosition.containing(var1)) || var3.getType() == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    public static interface a {
        public static final a SELECT_FROM_LEVEL = new a(){

            public List<EntityPlayer> getPlayers(WorldServer var0, Predicate<? super EntityHuman> var1) {
                return var0.getPlayers(var1);
            }

            @Override
            public <T extends Entity> List<T> getEntities(WorldServer var0, EntityTypeTest<Entity, T> var1, AxisAlignedBB var2, Predicate<? super T> var3) {
                return var0.getEntities(var1, var2, var3);
            }
        };

        public List<? extends EntityHuman> getPlayers(WorldServer var1, Predicate<? super EntityHuman> var2);

        public <T extends Entity> List<T> getEntities(WorldServer var1, EntityTypeTest<Entity, T> var2, AxisAlignedBB var3, Predicate<? super T> var4);

        public static a onlySelectPlayer(EntityHuman var0) {
            return a.onlySelectPlayers(List.of(var0));
        }

        public static a onlySelectPlayers(final List<EntityHuman> var0) {
            return new a(){

                public List<EntityHuman> getPlayers(WorldServer var02, Predicate<? super EntityHuman> var1) {
                    return var0.stream().filter(var1).toList();
                }

                @Override
                public <T extends Entity> List<T> getEntities(WorldServer var02, EntityTypeTest<Entity, T> var1, AxisAlignedBB var2, Predicate<? super T> var3) {
                    return var0.stream().map(var1::tryCast).filter(Objects::nonNull).filter(var3).toList();
                }
            };
        }
    }
}

