/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.DataBits;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.chunk.Configuration;
import net.minecraft.world.level.chunk.DataPalette;
import net.minecraft.world.level.chunk.DataPaletteExpandable;
import net.minecraft.world.level.chunk.DataPaletteHash;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.Strategy;

public class DataPaletteBlock<T>
implements DataPaletteExpandable<T>,
PalettedContainerRO<T> {
    private static final int MIN_PALETTE_BITS = 0;
    private volatile b<T> data;
    private final Strategy<T> strategy;
    private final ThreadingDetector threadingDetector = new ThreadingDetector("PalettedContainer");

    public void acquire() {
        this.threadingDetector.checkAndLock();
    }

    public void release() {
        this.threadingDetector.checkAndUnlock();
    }

    public static <T> Codec<DataPaletteBlock<T>> codecRW(Codec<T> var0, Strategy<T> var1, T var2) {
        PalettedContainerRO.b var3 = DataPaletteBlock::unpack;
        return DataPaletteBlock.codec(var0, var1, var2, var3);
    }

    public static <T> Codec<PalettedContainerRO<T>> codecRO(Codec<T> var0, Strategy<T> var12, T var2) {
        PalettedContainerRO.b var3 = (var02, var1) -> DataPaletteBlock.unpack(var02, var1).map(var0 -> var0);
        return DataPaletteBlock.codec(var0, var12, var2, var3);
    }

    private static <T, C extends PalettedContainerRO<T>> Codec<C> codec(Codec<T> var0, Strategy<T> var12, T var22, PalettedContainerRO.b<T, C> var3) {
        return RecordCodecBuilder.create(var2 -> var2.group((App)var0.mapResult(ExtraCodecs.orElsePartial(var22)).listOf().fieldOf("palette").forGetter(PalettedContainerRO.a::paletteEntries), (App)Codec.LONG_STREAM.lenientOptionalFieldOf("data").forGetter(PalettedContainerRO.a::storage)).apply((Applicative)var2, PalettedContainerRO.a::new)).comapFlatMap(var2 -> var3.read(var12, (PalettedContainerRO.a)var2), var1 -> var1.pack(var12));
    }

    private DataPaletteBlock(Strategy<T> var0, Configuration var1, DataBits var2, DataPalette<T> var3) {
        this.strategy = var0;
        this.data = new b<T>(var1, var2, var3);
    }

    private DataPaletteBlock(DataPaletteBlock<T> var0) {
        this.strategy = var0.strategy;
        this.data = var0.data.copy();
    }

    public DataPaletteBlock(T var0, Strategy<T> var1) {
        this.strategy = var1;
        this.data = this.createOrReuseData(null, 0);
        this.data.palette.idFor(var0, this);
    }

    private b<T> createOrReuseData(@Nullable b<T> var0, int var1) {
        Configuration var2 = this.strategy.getConfigurationForBitCount(var1);
        if (var0 != null && var2.equals(var0.configuration())) {
            return var0;
        }
        DataBits var3 = var2.bitsInMemory() == 0 ? new ZeroBitStorage(this.strategy.entryCount()) : new SimpleBitStorage(var2.bitsInMemory(), this.strategy.entryCount());
        DataPalette<T> var4 = var2.createPalette(this.strategy, List.of());
        return new b<T>(var2, var3, var4);
    }

    @Override
    public int onResize(int var0, T var1) {
        b<T> var2 = this.data;
        b var3 = this.createOrReuseData(var2, var0);
        var3.copyFrom(var2.palette, var2.storage);
        this.data = var3;
        return var3.palette.idFor(var1, DataPaletteExpandable.noResizeExpected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getAndSet(int var0, int var1, int var2, T var3) {
        this.acquire();
        try {
            T t2 = this.getAndSet(this.strategy.getIndex(var0, var1, var2), var3);
            return t2;
        }
        finally {
            this.release();
        }
    }

    public T getAndSetUnchecked(int var0, int var1, int var2, T var3) {
        return this.getAndSet(this.strategy.getIndex(var0, var1, var2), var3);
    }

    private T getAndSet(int var0, T var1) {
        int var2 = this.data.palette.idFor(var1, this);
        int var3 = this.data.storage.getAndSet(var0, var2);
        return this.data.palette.valueFor(var3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int var0, int var1, int var2, T var3) {
        this.acquire();
        try {
            this.set(this.strategy.getIndex(var0, var1, var2), var3);
        }
        finally {
            this.release();
        }
    }

    private void set(int var0, T var1) {
        int var2 = this.data.palette.idFor(var1, this);
        this.data.storage.set(var0, var2);
    }

    @Override
    public T get(int var0, int var1, int var2) {
        return this.get(this.strategy.getIndex(var0, var1, var2));
    }

    protected T get(int var0) {
        b<T> var1 = this.data;
        return var1.palette.valueFor(var1.storage.get(var0));
    }

    @Override
    public void getAll(Consumer<T> var0) {
        DataPalette var1 = this.data.palette();
        IntArraySet var22 = new IntArraySet();
        this.data.storage.getAll(arg_0 -> ((IntSet)var22).add(arg_0));
        var22.forEach(var2 -> var0.accept(var1.valueFor(var2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(PacketDataSerializer var0) {
        this.acquire();
        try {
            byte var1 = var0.readByte();
            b<T> var2 = this.createOrReuseData(this.data, var1);
            var2.palette.read(var0, this.strategy.globalMap());
            var0.readFixedSizeLongArray(var2.storage.getRaw());
            this.data = var2;
        }
        finally {
            this.release();
        }
    }

    @Override
    public void write(PacketDataSerializer var0) {
        this.acquire();
        try {
            this.data.write(var0, this.strategy.globalMap());
        }
        finally {
            this.release();
        }
    }

    @VisibleForTesting
    public static <T> DataResult<DataPaletteBlock<T>> unpack(Strategy<T> var0, PalettedContainerRO.a<T> var1) {
        DataBits var6;
        DataPalette<T> var7;
        List<T> var2 = var1.paletteEntries();
        int var3 = var0.entryCount();
        Configuration var4 = var0.getConfigurationForPaletteSize(var2.size());
        int var5 = var4.bitsInStorage();
        if (var1.bitsPerEntry() != -1 && var5 != var1.bitsPerEntry()) {
            return DataResult.error(() -> "Invalid bit count, calculated " + var5 + ", but container declared " + var1.bitsPerEntry());
        }
        if (var4.bitsInMemory() == 0) {
            var7 = var4.createPalette(var0, var2);
            var6 = new ZeroBitStorage(var3);
        } else {
            Optional<LongStream> var8 = var1.storage();
            if (var8.isEmpty()) {
                return DataResult.error(() -> "Missing values for non-zero storage");
            }
            long[] var9 = var8.get().toArray();
            try {
                if (var4.alwaysRepack() || var4.bitsInMemory() != var5) {
                    DataPaletteHash<T> var10 = new DataPaletteHash<T>(var5, var2);
                    SimpleBitStorage var11 = new SimpleBitStorage(var5, var3, var9);
                    DataPalette<T> var12 = var4.createPalette(var0, var2);
                    int[] var13 = DataPaletteBlock.reencodeContents(var11, var10, var12);
                    var7 = var12;
                    var6 = new SimpleBitStorage(var4.bitsInMemory(), var3, var13);
                } else {
                    var7 = var4.createPalette(var0, var2);
                    var6 = new SimpleBitStorage(var4.bitsInMemory(), var3, var9);
                }
            }
            catch (SimpleBitStorage.a var10) {
                return DataResult.error(() -> "Failed to read PalettedContainer: " + var10.getMessage());
            }
        }
        return DataResult.success(new DataPaletteBlock<T>(var0, var4, var6, var7));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PalettedContainerRO.a<T> pack(Strategy<T> var0) {
        this.acquire();
        try {
            Optional<LongStream> var7;
            DataBits var1 = this.data.storage;
            DataPalette var2 = this.data.palette;
            DataPaletteHash var3 = new DataPaletteHash(var1.getBits());
            int var4 = var0.entryCount();
            int[] var5 = DataPaletteBlock.reencodeContents(var1, var2, var3);
            Configuration var6 = var0.getConfigurationForPaletteSize(var3.getSize());
            int var8 = var6.bitsInStorage();
            if (var8 != 0) {
                SimpleBitStorage var9 = new SimpleBitStorage(var8, var4, var5);
                var7 = Optional.of(Arrays.stream(var9.getRaw()));
            } else {
                var7 = Optional.empty();
            }
            PalettedContainerRO.a a2 = new PalettedContainerRO.a(var3.getEntries(), var7, var8);
            return a2;
        }
        finally {
            this.release();
        }
    }

    private static <T> int[] reencodeContents(DataBits var0, DataPalette<T> var1, DataPalette<T> var2) {
        int[] var3 = new int[var0.getSize()];
        var0.unpack(var3);
        DataPaletteExpandable var4 = DataPaletteExpandable.noResizeExpected();
        int var5 = -1;
        int var6 = -1;
        for (int var7 = 0; var7 < var3.length; ++var7) {
            int var8 = var3[var7];
            if (var8 != var5) {
                var5 = var8;
                var6 = var2.idFor(var1.valueFor(var8), var4);
            }
            var3[var7] = var6;
        }
        return var3;
    }

    @Override
    public int getSerializedSize() {
        return this.data.getSerializedSize(this.strategy.globalMap());
    }

    @Override
    public int bitsPerEntry() {
        return this.data.storage().getBits();
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        return this.data.palette.maybeHas(var0);
    }

    @Override
    public DataPaletteBlock<T> copy() {
        return new DataPaletteBlock<T>(this);
    }

    @Override
    public DataPaletteBlock<T> recreate() {
        return new DataPaletteBlock(this.data.palette.valueFor(0), this.strategy);
    }

    @Override
    public void count(a<T> var0) {
        if (this.data.palette.getSize() == 1) {
            var0.accept(this.data.palette.valueFor(0), this.data.storage.getSize());
            return;
        }
        Int2IntOpenHashMap var12 = new Int2IntOpenHashMap();
        this.data.storage.getAll((int var1) -> var12.addTo(var1, 1));
        var12.int2IntEntrySet().forEach(var1 -> var0.accept(this.data.palette.valueFor(var1.getIntKey()), var1.getIntValue()));
    }

    static final class b<T>
    extends Record {
        private final Configuration configuration;
        final DataBits storage;
        final DataPalette<T> palette;

        b(Configuration var0, DataBits var1, DataPalette<T> var2) {
            this.configuration = var0;
            this.storage = var1;
            this.palette = var2;
        }

        public void copyFrom(DataPalette<T> var0, DataBits var1) {
            DataPaletteExpandable var2 = DataPaletteExpandable.noResizeExpected();
            for (int var3 = 0; var3 < var1.getSize(); ++var3) {
                T var4 = var0.valueFor(var1.get(var3));
                this.storage.set(var3, this.palette.idFor(var4, var2));
            }
        }

        public int getSerializedSize(Registry<T> var0) {
            return 1 + this.palette.getSerializedSize(var0) + this.storage.getRaw().length * 8;
        }

        public void write(PacketDataSerializer var0, Registry<T> var1) {
            var0.writeByte(this.storage.getBits());
            this.palette.write(var0, var1);
            var0.writeFixedSizeLongArray(this.storage.getRaw());
        }

        public b<T> copy() {
            return new b<T>(this.configuration, this.storage.copy(), this.palette.copy());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "configuration;storage;palette", "configuration", "storage", "palette"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "configuration;storage;palette", "configuration", "storage", "palette"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "configuration;storage;palette", "configuration", "storage", "palette"}, this, var0);
        }

        public Configuration configuration() {
            return this.configuration;
        }

        public DataBits storage() {
            return this.storage;
        }

        public DataPalette<T> palette() {
            return this.palette;
        }
    }

    @FunctionalInterface
    public static interface a<T> {
        public void accept(T var1, int var2);
    }
}

