/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.SessionLock;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import org.slf4j.Logger;

public class Convertable {
    static final Logger LOGGER = LogUtils.getLogger();
    static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();
    public static final String TAG_DATA = "Data";
    private static final PathMatcher NO_SYMLINKS_ALLOWED = var0 -> false;
    public static final String ALLOWED_SYMLINKS_CONFIG_NAME = "allowed_symlinks.txt";
    private static final int UNCOMPRESSED_NBT_QUOTA = 0x6400000;
    private static final int DISK_SPACE_WARNING_THRESHOLD = 0x4000000;
    public final Path baseDir;
    private final Path backupDir;
    final DataFixer fixerUpper;
    private final DirectoryValidator worldDirValidator;

    public Convertable(Path var0, Path var1, DirectoryValidator var2, DataFixer var3) {
        this.fixerUpper = var3;
        try {
            FileUtils.createDirectoriesSafe(var0);
        }
        catch (IOException var4) {
            throw new UncheckedIOException(var4);
        }
        this.baseDir = var0;
        this.backupDir = var1;
        this.worldDirValidator = var2;
    }

    public static DirectoryValidator parseValidator(Path var0) {
        if (Files.exists(var0, new LinkOption[0])) {
            DirectoryValidator directoryValidator;
            block9: {
                BufferedReader var1 = Files.newBufferedReader(var0);
                try {
                    directoryValidator = new DirectoryValidator(PathAllowList.readPlain(var1));
                    if (var1 == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (var1 != null) {
                            try {
                                var1.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception var12) {
                        LOGGER.error("Failed to parse {}, disallowing all symbolic links", (Object)ALLOWED_SYMLINKS_CONFIG_NAME, (Object)var12);
                    }
                }
                var1.close();
            }
            return directoryValidator;
        }
        return new DirectoryValidator(NO_SYMLINKS_ALLOWED);
    }

    public static Convertable createDefault(Path var0) {
        DirectoryValidator var1 = Convertable.parseValidator(var0.resolve(ALLOWED_SYMLINKS_CONFIG_NAME));
        return new Convertable(var0, var0.resolve("../backups"), var1, DataConverterRegistry.getDataFixer());
    }

    public static WorldDataConfiguration readDataConfig(Dynamic<?> var0) {
        return WorldDataConfiguration.CODEC.parse(var0).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(WorldDataConfiguration.DEFAULT);
    }

    public static WorldLoader.d getPackConfig(Dynamic<?> var0, ResourcePackRepository var1, boolean var2) {
        return new WorldLoader.d(var1, Convertable.readDataConfig(var0), var2, false);
    }

    public static LevelDataAndDimensions getLevelDataAndDimensions(Dynamic<?> var0, WorldDataConfiguration var1, IRegistry<WorldDimension> var2, HolderLookup.a var3) {
        Dynamic<?> var4 = RegistryOps.injectRegistryContext(var0, var3);
        Dynamic var5 = var4.get("WorldGenSettings").orElseEmptyMap();
        GeneratorSettings var6 = (GeneratorSettings)GeneratorSettings.CODEC.parse(var5).getOrThrow();
        WorldSettings var7 = WorldSettings.parse(var4, var1);
        WorldDimensions.b var8 = var6.dimensions().bake(var2);
        Lifecycle var9 = var8.lifecycle().add(var3.allRegistriesLifecycle());
        WorldDataServer var10 = WorldDataServer.parse(var4, var7, var8.specialWorldProperty(), var6.options(), var9);
        return new LevelDataAndDimensions(var10, var8);
    }

    public String getName() {
        return "Anvil";
    }

    public a findLevelCandidates() throws LevelStorageException {
        a a2;
        block9: {
            if (!Files.isDirectory(this.baseDir, new LinkOption[0])) {
                throw new LevelStorageException(IChatBaseComponent.translatable("selectWorld.load_folder_access"));
            }
            Stream<Path> var02 = Files.list(this.baseDir);
            try {
                List<b> var1 = var02.filter(var0 -> Files.isDirectory(var0, new LinkOption[0])).map(b::new).filter(var0 -> Files.isRegularFile(var0.dataFile(), new LinkOption[0]) || Files.isRegularFile(var0.oldDataFile(), new LinkOption[0])).toList();
                a2 = new a(var1);
                if (var02 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (var02 != null) {
                        try {
                            var02.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException var03) {
                    throw new LevelStorageException(IChatBaseComponent.translatable("selectWorld.load_folder_access"));
                }
            }
            var02.close();
        }
        return a2;
    }

    public CompletableFuture<List<WorldInfo>> loadLevelSummaries(a var02) {
        ArrayList<CompletableFuture<WorldInfo>> var1 = new ArrayList<CompletableFuture<WorldInfo>>(var02.levels.size());
        for (b var3 : var02.levels) {
            var1.add(CompletableFuture.supplyAsync(() -> {
                boolean var1;
                try {
                    var1 = SessionLock.isLocked(var3.path());
                }
                catch (Exception var2) {
                    LOGGER.warn("Failed to read {} lock", (Object)var3.path(), (Object)var2);
                    return null;
                }
                try {
                    return this.readLevelSummary(var3, var1);
                }
                catch (OutOfMemoryError var2) {
                    MemoryReserve.release();
                    String var3 = "Ran out of memory trying to read summary of world folder \"" + var3.directoryName() + "\"";
                    LOGGER.error(LogUtils.FATAL_MARKER, var3);
                    OutOfMemoryError var4 = new OutOfMemoryError("Ran out of memory reading level data");
                    var4.initCause(var2);
                    CrashReport var5 = CrashReport.forThrowable(var4, var3);
                    CrashReportSystemDetails var6 = var5.addCategory("World details");
                    var6.setDetail("Folder Name", var3.directoryName());
                    try {
                        long var7 = Files.size(var3.dataFile());
                        var6.setDetail("level.dat size", var7);
                    }
                    catch (IOException var9) {
                        var6.setDetailError("level.dat size", var9);
                    }
                    throw new ReportedException(var5);
                }
            }, SystemUtils.backgroundExecutor().forName("loadLevelSummaries")));
        }
        return SystemUtils.sequenceFailFastAndCancel(var1).thenApply(var0 -> var0.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int getStorageVersion() {
        return 19133;
    }

    static NBTTagCompound readLevelDataTagRaw(Path var0) throws IOException {
        return NBTCompressedStreamTools.readCompressed(var0, NBTReadLimiter.create(0x6400000L));
    }

    static Dynamic<?> readLevelDataTagFixed(Path var0, DataFixer var1) throws IOException {
        NBTTagCompound var22 = Convertable.readLevelDataTagRaw(var0);
        NBTTagCompound var3 = var22.getCompoundOrEmpty(TAG_DATA);
        int var4 = GameProfileSerializer.getDataVersion(var3, -1);
        Dynamic var5 = DataFixTypes.LEVEL.updateToCurrentVersion(var1, new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var3), var4);
        var5 = var5.update("Player", var2 -> DataFixTypes.PLAYER.updateToCurrentVersion(var1, var2, var4));
        var5 = var5.update("WorldGenSettings", var2 -> DataFixTypes.WORLD_GEN_SETTINGS.updateToCurrentVersion(var1, var2, var4));
        return var5;
    }

    private WorldInfo readLevelSummary(b var0, boolean var1) {
        Path var2 = var0.dataFile();
        if (Files.exists(var2, new LinkOption[0])) {
            try {
                Object var3;
                if (Files.isSymbolicLink(var2) && !(var3 = this.worldDirValidator.validateSymlink(var2)).isEmpty()) {
                    LOGGER.warn("{}", (Object)ContentValidationException.getMessage(var2, (List<ForbiddenSymlinkInfo>)var3));
                    return new WorldInfo.c(var0.directoryName(), var0.iconFile());
                }
                var3 = Convertable.readLightweightData(var2);
                if (var3 instanceof NBTTagCompound) {
                    NBTTagCompound var4 = (NBTTagCompound)var3;
                    NBTTagCompound var5 = var4.getCompoundOrEmpty(TAG_DATA);
                    int var6 = GameProfileSerializer.getDataVersion(var5, -1);
                    Dynamic var7 = DataFixTypes.LEVEL_SUMMARY.updateToCurrentVersion(this.fixerUpper, new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var5), var6);
                    return this.makeLevelSummary(var7, var0, var1);
                }
                LOGGER.warn("Invalid root tag in {}", (Object)var2);
            }
            catch (Exception var3) {
                LOGGER.error("Exception reading {}", (Object)var2, (Object)var3);
            }
        }
        return new WorldInfo.b(var0.directoryName(), var0.iconFile(), Convertable.getFileModificationTime(var0));
    }

    private static long getFileModificationTime(b var0) {
        Instant var1 = Convertable.getFileModificationTime(var0.dataFile());
        if (var1 == null) {
            var1 = Convertable.getFileModificationTime(var0.oldDataFile());
        }
        return var1 == null ? -1L : var1.toEpochMilli();
    }

    @Nullable
    static Instant getFileModificationTime(Path var0) {
        try {
            return Files.getLastModifiedTime(var0, new LinkOption[0]).toInstant();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    WorldInfo makeLevelSummary(Dynamic<?> var0, b var1, boolean var2) {
        LevelVersion var3 = LevelVersion.parse(var0);
        int var4 = var3.levelDataVersion();
        if (var4 == 19132 || var4 == 19133) {
            boolean var5 = var4 != this.getStorageVersion();
            Path var6 = var1.iconFile();
            WorldDataConfiguration var7 = Convertable.readDataConfig(var0);
            WorldSettings var8 = WorldSettings.parse(var0, var7);
            FeatureFlagSet var9 = Convertable.parseFeatureFlagsFromSummary(var0);
            boolean var10 = FeatureFlags.isExperimental(var9);
            return new WorldInfo(var8, var3, var1.directoryName(), var5, var2, var10, var6);
        }
        throw new NbtFormatException("Unknown data version: " + Integer.toHexString(var4));
    }

    private static FeatureFlagSet parseFeatureFlagsFromSummary(Dynamic<?> var02) {
        Set<MinecraftKey> var1 = var02.get("enabled_features").asStream().flatMap(var0 -> var0.asString().result().map(MinecraftKey::tryParse).stream()).collect(Collectors.toSet());
        return FeatureFlags.REGISTRY.fromNames(var1, var0 -> {});
    }

    @Nullable
    private static NBTBase readLightweightData(Path var0) throws IOException {
        SkipFields var1 = new SkipFields(new FieldSelector(TAG_DATA, NBTTagCompound.TYPE, "Player"), new FieldSelector(TAG_DATA, NBTTagCompound.TYPE, "WorldGenSettings"));
        NBTCompressedStreamTools.parseCompressed(var0, (StreamTagVisitor)var1, NBTReadLimiter.create(0x6400000L));
        return var1.getResult();
    }

    public boolean isNewLevelIdAcceptable(String var0) {
        try {
            Path var1 = this.getLevelPath(var0);
            Files.createDirectory(var1, new FileAttribute[0]);
            Files.deleteIfExists(var1);
            return true;
        }
        catch (IOException var1) {
            return false;
        }
    }

    public boolean levelExists(String var0) {
        try {
            return Files.isDirectory(this.getLevelPath(var0), new LinkOption[0]);
        }
        catch (InvalidPathException var1) {
            return false;
        }
    }

    public Path getLevelPath(String var0) {
        return this.baseDir.resolve(var0);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path getBackupPath() {
        return this.backupDir;
    }

    public ConversionSession validateAndCreateAccess(String var0) throws IOException, ContentValidationException {
        Path var1 = this.getLevelPath(var0);
        List<ForbiddenSymlinkInfo> var2 = this.worldDirValidator.validateDirectory(var1, true);
        if (!var2.isEmpty()) {
            throw new ContentValidationException(var1, var2);
        }
        return new ConversionSession(var0, var1);
    }

    public ConversionSession createAccess(String var0) throws IOException {
        Path var1 = this.getLevelPath(var0);
        return new ConversionSession(var0, var1);
    }

    public DirectoryValidator getWorldDirValidator() {
        return this.worldDirValidator;
    }

    public static final class a
    extends Record
    implements Iterable<b> {
        final List<b> levels;

        public a(List<b> var0) {
            this.levels = var0;
        }

        public boolean isEmpty() {
            return this.levels.isEmpty();
        }

        @Override
        public Iterator<b> iterator() {
            return this.levels.iterator();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "levels", "levels"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "levels", "levels"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "levels", "levels"}, this, var0);
        }

        public List<b> levels() {
            return this.levels;
        }
    }

    public static final class b
    extends Record {
        final Path path;

        public b(Path var0) {
            this.path = var0;
        }

        public String directoryName() {
            return this.path.getFileName().toString();
        }

        public Path dataFile() {
            return this.resourcePath(SavedFile.LEVEL_DATA_FILE);
        }

        public Path oldDataFile() {
            return this.resourcePath(SavedFile.OLD_LEVEL_DATA_FILE);
        }

        public Path corruptedDataFile(LocalDateTime var0) {
            return this.path.resolve(SavedFile.LEVEL_DATA_FILE.getId() + "_corrupted_" + var0.format(FORMATTER));
        }

        public Path rawDataFile(LocalDateTime var0) {
            return this.path.resolve(SavedFile.LEVEL_DATA_FILE.getId() + "_raw_" + var0.format(FORMATTER));
        }

        public Path iconFile() {
            return this.resourcePath(SavedFile.ICON_FILE);
        }

        public Path lockFile() {
            return this.resourcePath(SavedFile.LOCK_FILE);
        }

        public Path resourcePath(SavedFile var0) {
            return this.path.resolve(var0.getId());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "path", "path"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "path", "path"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "path", "path"}, this, var0);
        }

        public Path path() {
            return this.path;
        }
    }

    public class ConversionSession
    implements AutoCloseable {
        final SessionLock lock;
        public final b levelDirectory;
        private final String levelId;
        private final Map<SavedFile, Path> resources = Maps.newHashMap();

        ConversionSession(String var1, Path var2) throws IOException {
            this.levelId = var1;
            this.levelDirectory = new b(var2);
            this.lock = SessionLock.create(var2);
        }

        public long estimateDiskSpace() {
            try {
                return Files.getFileStore(this.levelDirectory.path).getUsableSpace();
            }
            catch (Exception var0) {
                return Long.MAX_VALUE;
            }
        }

        public boolean checkForLowDiskSpace() {
            return this.estimateDiskSpace() < 0x4000000L;
        }

        public void safeClose() {
            try {
                this.close();
            }
            catch (IOException var0) {
                LOGGER.warn("Failed to unlock access to level {}", (Object)this.getLevelId(), (Object)var0);
            }
        }

        public Convertable parent() {
            return Convertable.this;
        }

        public b getLevelDirectory() {
            return this.levelDirectory;
        }

        public String getLevelId() {
            return this.levelId;
        }

        public Path getLevelPath(SavedFile var0) {
            return this.resources.computeIfAbsent(var0, this.levelDirectory::resourcePath);
        }

        public Path getDimensionPath(ResourceKey<World> var0) {
            return DimensionManager.getStorageFolder(var0, this.levelDirectory.path());
        }

        private void checkLock() {
            if (!this.lock.isValid()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public WorldNBTStorage createPlayerStorage() {
            this.checkLock();
            return new WorldNBTStorage(this, Convertable.this.fixerUpper);
        }

        public WorldInfo getSummary(Dynamic<?> var0) {
            this.checkLock();
            return Convertable.this.makeLevelSummary(var0, this.levelDirectory, false);
        }

        public Dynamic<?> getDataTag() throws IOException {
            return this.getDataTag(false);
        }

        public Dynamic<?> getDataTagFallback() throws IOException {
            return this.getDataTag(true);
        }

        private Dynamic<?> getDataTag(boolean var0) throws IOException {
            this.checkLock();
            return Convertable.readLevelDataTagFixed(var0 ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile(), Convertable.this.fixerUpper);
        }

        public void saveDataTag(IRegistryCustom var0, SaveData var1) {
            this.saveDataTag(var0, var1, null);
        }

        public void saveDataTag(IRegistryCustom var0, SaveData var1, @Nullable NBTTagCompound var2) {
            NBTTagCompound var3 = var1.createTag(var0, var2);
            NBTTagCompound var4 = new NBTTagCompound();
            var4.put(Convertable.TAG_DATA, var3);
            this.saveLevelData(var4);
        }

        private void saveLevelData(NBTTagCompound var0) {
            Path var1 = this.levelDirectory.path();
            try {
                Path var2 = Files.createTempFile(var1, "level", ".dat", new FileAttribute[0]);
                NBTCompressedStreamTools.writeCompressed(var0, var2);
                Path var3 = this.levelDirectory.oldDataFile();
                Path var4 = this.levelDirectory.dataFile();
                SystemUtils.safeReplaceFile(var4, var2, var3);
            }
            catch (Exception var2) {
                LOGGER.error("Failed to save level {}", (Object)var1, (Object)var2);
            }
        }

        public Optional<Path> getIconFile() {
            if (!this.lock.isValid()) {
                return Optional.empty();
            }
            return Optional.of(this.levelDirectory.iconFile());
        }

        public void deleteLevel() throws IOException {
            this.checkLock();
            final Path var0 = this.levelDirectory.lockFile();
            LOGGER.info("Deleting level {}", (Object)this.levelId);
            for (int var1 = 1; var1 <= 5; ++var1) {
                LOGGER.info("Attempt {}...", (Object)var1);
                try {
                    Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path var02, BasicFileAttributes var1) throws IOException {
                            if (!var02.equals(var0)) {
                                LOGGER.debug("Deleting {}", (Object)var02);
                                Files.delete(var02);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path var02, @Nullable IOException var1) throws IOException {
                            if (var1 != null) {
                                throw var1;
                            }
                            if (var02.equals(ConversionSession.this.levelDirectory.path())) {
                                ConversionSession.this.lock.close();
                                Files.deleteIfExists(var0);
                            }
                            Files.delete(var02);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public /* synthetic */ FileVisitResult postVisitDirectory(Object object, @Nullable IOException iOException) throws IOException {
                            return this.postVisitDirectory((Path)object, iOException);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                            return this.visitFile((Path)object, basicFileAttributes);
                        }
                    });
                    break;
                }
                catch (IOException var2) {
                    if (var1 < 5) {
                        LOGGER.warn("Failed to delete {}", (Object)this.levelDirectory.path(), (Object)var2);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw var2;
                }
            }
        }

        public void renameLevel(String var0) throws IOException {
            this.modifyLevelDataWithoutDatafix(var1 -> var1.putString("LevelName", var0.trim()));
        }

        public void renameAndDropPlayer(String var0) throws IOException {
            this.modifyLevelDataWithoutDatafix(var1 -> {
                var1.putString("LevelName", var0.trim());
                var1.remove("Player");
            });
        }

        private void modifyLevelDataWithoutDatafix(Consumer<NBTTagCompound> var0) throws IOException {
            this.checkLock();
            NBTTagCompound var1 = Convertable.readLevelDataTagRaw(this.levelDirectory.dataFile());
            var0.accept(var1.getCompoundOrEmpty(Convertable.TAG_DATA));
            this.saveLevelData(var1);
        }

        public long makeWorldBackup() throws IOException {
            this.checkLock();
            String var0 = LocalDateTime.now().format(FORMATTER) + "_" + this.levelId;
            Path var1 = Convertable.this.getBackupPath();
            try {
                FileUtils.createDirectoriesSafe(var1);
            }
            catch (IOException var2) {
                throw new RuntimeException(var2);
            }
            Path var2 = var1.resolve(FileUtils.findAvailableName(var1, var0, ".zip"));
            try (final ZipOutputStream var3 = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(var2, new OpenOption[0])));){
                final Path var4 = Paths.get(this.levelId, new String[0]);
                Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path var0, BasicFileAttributes var1) throws IOException {
                        if (var0.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String var2 = var4.resolve(ConversionSession.this.levelDirectory.path().relativize(var0)).toString().replace('\\', '/');
                        ZipEntry var32 = new ZipEntry(var2);
                        var3.putNextEntry(var32);
                        com.google.common.io.Files.asByteSource((File)var0.toFile()).copyTo((OutputStream)var3);
                        var3.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.visitFile((Path)object, basicFileAttributes);
                    }
                });
            }
            return Files.size(var2);
        }

        public boolean hasWorldData() {
            return Files.exists(this.levelDirectory.dataFile(), new LinkOption[0]) || Files.exists(this.levelDirectory.oldDataFile(), new LinkOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.lock.close();
        }

        public boolean restoreLevelDataFromOld() {
            return SystemUtils.safeReplaceOrMoveFile(this.levelDirectory.dataFile(), this.levelDirectory.oldDataFile(), this.levelDirectory.corruptedDataFile(LocalDateTime.now()), true);
        }

        @Nullable
        public Instant getFileModificationTime(boolean var0) {
            return Convertable.getFileModificationTime(var0 ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile());
        }
    }
}

