/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootTableInfo {
    private final LootParams params;
    private final RandomSource random;
    private final HolderGetter.a lootDataResolver;
    private final Set<e<?>> visitedElements = Sets.newLinkedHashSet();

    LootTableInfo(LootParams var0, RandomSource var1, HolderGetter.a var2) {
        this.params = var0;
        this.random = var1;
        this.lootDataResolver = var2;
    }

    public boolean hasParameter(ContextKey<?> var0) {
        return this.params.contextMap().has(var0);
    }

    public <T> T getParameter(ContextKey<T> var0) {
        return this.params.contextMap().getOrThrow(var0);
    }

    @Nullable
    public <T> T getOptionalParameter(ContextKey<T> var0) {
        return this.params.contextMap().getOptional(var0);
    }

    public void addDynamicDrops(MinecraftKey var0, Consumer<ItemStack> var1) {
        this.params.addDynamicDrops(var0, var1);
    }

    public boolean hasVisitedElement(e<?> var0) {
        return this.visitedElements.contains(var0);
    }

    public boolean pushVisitedElement(e<?> var0) {
        return this.visitedElements.add(var0);
    }

    public void popVisitedElement(e<?> var0) {
        this.visitedElements.remove(var0);
    }

    public HolderGetter.a getResolver() {
        return this.lootDataResolver;
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public float getLuck() {
        return this.params.getLuck();
    }

    public WorldServer getLevel() {
        return this.params.getLevel();
    }

    public static e<LootTable> createVisitedEntry(LootTable var0) {
        return new e<LootTable>(LootDataType.TABLE, var0);
    }

    public static e<LootItemCondition> createVisitedEntry(LootItemCondition var0) {
        return new e<LootItemCondition>(LootDataType.PREDICATE, var0);
    }

    public static e<LootItemFunction> createVisitedEntry(LootItemFunction var0) {
        return new e<LootItemFunction>(LootDataType.MODIFIER, var0);
    }

    public record e<T>(LootDataType<T> type, T value) {
    }

    public static final class d
    extends Enum<d>
    implements INamable {
        public static final /* enum */ d TOOL = new d("tool", LootContextParameters.TOOL);
        private final String name;
        private final ContextKey<? extends ItemStack> param;
        private static final /* synthetic */ d[] d;

        public static d[] values() {
            return (d[])d.clone();
        }

        public static d valueOf(String var0) {
            return Enum.valueOf(d.class, var0);
        }

        private d(String var2, ContextKey var3) {
            this.name = var2;
            this.param = var3;
        }

        public ContextKey<? extends ItemStack> getParam() {
            return this.param;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ d[] b() {
            return new d[]{TOOL};
        }

        static {
            d = net.minecraft.world.level.storage.loot.LootTableInfo$d.b();
        }
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a BLOCK_ENTITY = new a("block_entity", LootContextParameters.BLOCK_ENTITY);
        private final String name;
        private final ContextKey<? extends TileEntity> param;
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2, ContextKey var3) {
            this.name = var2;
            this.param = var3;
        }

        public ContextKey<? extends TileEntity> getParam() {
            return this.param;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ a[] b() {
            return new a[]{BLOCK_ENTITY};
        }

        static {
            d = a.b();
        }
    }

    public static final class EntityTarget
    extends Enum<EntityTarget>
    implements INamable {
        public static final /* enum */ EntityTarget THIS = new EntityTarget("this", LootContextParameters.THIS_ENTITY);
        public static final /* enum */ EntityTarget ATTACKER = new EntityTarget("attacker", LootContextParameters.ATTACKING_ENTITY);
        public static final /* enum */ EntityTarget DIRECT_ATTACKER = new EntityTarget("direct_attacker", LootContextParameters.DIRECT_ATTACKING_ENTITY);
        public static final /* enum */ EntityTarget ATTACKING_PLAYER = new EntityTarget("attacking_player", LootContextParameters.LAST_DAMAGE_PLAYER);
        public static final /* enum */ EntityTarget TARGET_ENTITY = new EntityTarget("target_entity", LootContextParameters.TARGET_ENTITY);
        public static final /* enum */ EntityTarget INTERACTING_ENTITY = new EntityTarget("interacting_entity", LootContextParameters.INTERACTING_ENTITY);
        public static final INamable.a<EntityTarget> CODEC;
        private final String name;
        private final ContextKey<? extends Entity> param;
        private static final /* synthetic */ EntityTarget[] j;

        public static EntityTarget[] values() {
            return (EntityTarget[])j.clone();
        }

        public static EntityTarget valueOf(String var0) {
            return Enum.valueOf(EntityTarget.class, var0);
        }

        private EntityTarget(String var2, ContextKey var3) {
            this.name = var2;
            this.param = var3;
        }

        public ContextKey<? extends Entity> getParam() {
            return this.param;
        }

        public static EntityTarget getByName(String var0) {
            EntityTarget var1 = CODEC.byName(var0);
            if (var1 != null) {
                return var1;
            }
            throw new IllegalArgumentException("Invalid entity target " + var0);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ EntityTarget[] b() {
            return new EntityTarget[]{THIS, ATTACKER, DIRECT_ATTACKER, ATTACKING_PLAYER, TARGET_ENTITY, INTERACTING_ENTITY};
        }

        static {
            j = EntityTarget.b();
            CODEC = INamable.fromEnum(EntityTarget::values);
        }
    }

    public static class Builder {
        private final LootParams params;
        @Nullable
        private RandomSource random;

        public Builder(LootParams var0) {
            this.params = var0;
        }

        public Builder withOptionalRandomSeed(long var0) {
            if (var0 != 0L) {
                this.random = RandomSource.create(var0);
            }
            return this;
        }

        public Builder withOptionalRandomSource(RandomSource var0) {
            this.random = var0;
            return this;
        }

        public WorldServer getLevel() {
            return this.params.getLevel();
        }

        public LootTableInfo create(Optional<MinecraftKey> var0) {
            WorldServer var1 = this.getLevel();
            MinecraftServer var2 = var1.getServer();
            RandomSource var3 = Optional.ofNullable(this.random).or(() -> var0.map(var1::getRandomSequence)).orElseGet(var1::getRandom);
            return new LootTableInfo(this.params, var3, var2.reloadableRegistries().lookup());
        }
    }
}

