/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class SetCustomModelDataFunction
extends LootItemFunctionConditional {
    private static final Codec<NumberProvider> COLOR_PROVIDER_CODEC = Codec.withAlternative(NumberProviders.CODEC, ExtraCodecs.RGB_COLOR_CODEC, ConstantValue::new);
    public static final MapCodec<SetCustomModelDataFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetCustomModelDataFunction.commonFields(var02).and(var02.group((App)ListOperation.e.codec(NumberProviders.CODEC, Integer.MAX_VALUE).optionalFieldOf("floats").forGetter(var0 -> var0.floats), (App)ListOperation.e.codec(Codec.BOOL, Integer.MAX_VALUE).optionalFieldOf("flags").forGetter(var0 -> var0.flags), (App)ListOperation.e.codec(Codec.STRING, Integer.MAX_VALUE).optionalFieldOf("strings").forGetter(var0 -> var0.strings), (App)ListOperation.e.codec(COLOR_PROVIDER_CODEC, Integer.MAX_VALUE).optionalFieldOf("colors").forGetter(var0 -> var0.colors))).apply((Applicative)var02, SetCustomModelDataFunction::new));
    private final Optional<ListOperation.e<NumberProvider>> floats;
    private final Optional<ListOperation.e<Boolean>> flags;
    private final Optional<ListOperation.e<String>> strings;
    private final Optional<ListOperation.e<NumberProvider>> colors;

    public SetCustomModelDataFunction(List<LootItemCondition> var0, Optional<ListOperation.e<NumberProvider>> var1, Optional<ListOperation.e<Boolean>> var2, Optional<ListOperation.e<String>> var3, Optional<ListOperation.e<NumberProvider>> var4) {
        super(var0);
        this.floats = var1;
        this.flags = var2;
        this.strings = var3;
        this.colors = var4;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Stream.concat(this.floats.stream(), this.colors.stream()).flatMap(var0 -> var0.value().stream()).flatMap(var0 -> var0.getReferencedContextParams().stream()).collect(Collectors.toSet());
    }

    public LootItemFunctionType<SetCustomModelDataFunction> getType() {
        return LootItemFunctions.SET_CUSTOM_MODEL_DATA;
    }

    private static <T> List<T> apply(Optional<ListOperation.e<T>> var0, List<T> var12) {
        return var0.map(var1 -> var1.apply(var12)).orElse(var12);
    }

    private static <T, E> List<E> apply(Optional<ListOperation.e<T>> var0, List<E> var1, Function<T, E> var22) {
        return var0.map(var2 -> {
            List var3 = var2.value().stream().map(var22).toList();
            return var2.operation().apply(var1, var3);
        }).orElse(var1);
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var12) {
        CustomModelData var2 = var0.getOrDefault(DataComponents.CUSTOM_MODEL_DATA, CustomModelData.EMPTY);
        var0.set(DataComponents.CUSTOM_MODEL_DATA, new CustomModelData(SetCustomModelDataFunction.apply(this.floats, var2.floats(), var1 -> Float.valueOf(var1.getFloat(var12))), SetCustomModelDataFunction.apply(this.flags, var2.flags()), SetCustomModelDataFunction.apply(this.strings, var2.strings()), SetCustomModelDataFunction.apply(this.colors, var2.colors(), var1 -> var1.getInt(var12))));
        return var0;
    }
}

