/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.InstrumentComponent;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetInstrumentFunction
extends LootItemFunctionConditional {
    public static final MapCodec<SetInstrumentFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetInstrumentFunction.commonFields(var02).and((App)TagKey.hashedCodec(Registries.INSTRUMENT).fieldOf("options").forGetter(var0 -> var0.options)).apply((Applicative)var02, SetInstrumentFunction::new));
    private final TagKey<Instrument> options;

    private SetInstrumentFunction(List<LootItemCondition> var0, TagKey<Instrument> var1) {
        super(var0);
        this.options = var1;
    }

    public LootItemFunctionType<SetInstrumentFunction> getType() {
        return LootItemFunctions.SET_INSTRUMENT;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        HolderLookup.b var2 = var1.getLevel().registryAccess().lookupOrThrow(Registries.INSTRUMENT);
        Optional var3 = var2.getRandomElementOf(this.options, var1.getRandom());
        if (var3.isPresent()) {
            var0.set(DataComponents.INSTRUMENT, new InstrumentComponent((Holder)var3.get()));
        }
        return var0;
    }

    public static LootItemFunctionConditional.a<?> setInstrumentOptions(TagKey<Instrument> var0) {
        return SetInstrumentFunction.simpleBuilder(var1 -> new SetInstrumentFunction((List<LootItemCondition>)var1, var0));
    }
}

