/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollisionEntity;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class MinecartCollisionContext
extends VoxelShapeCollisionEntity {
    @Nullable
    private BlockPosition ingoreBelow;
    @Nullable
    private BlockPosition slopeIgnore;

    protected MinecartCollisionContext(EntityMinecartAbstract var0, boolean var1) {
        super(var0, var1, false);
        this.setupContext(var0);
    }

    private void setupContext(EntityMinecartAbstract var0) {
        BlockPosition var1 = var0.getCurrentBlockPosOrRailBelow();
        IBlockData var2 = var0.level().getBlockState(var1);
        boolean var3 = BlockMinecartTrackAbstract.isRail(var2);
        if (var3) {
            this.ingoreBelow = var1.below();
            BlockPropertyTrackPosition var4 = var2.getValue(((BlockMinecartTrackAbstract)var2.getBlock()).getShapeProperty());
            if (var4.isSlope()) {
                this.slopeIgnore = switch (var4) {
                    case BlockPropertyTrackPosition.ASCENDING_EAST -> var1.east();
                    case BlockPropertyTrackPosition.ASCENDING_WEST -> var1.west();
                    case BlockPropertyTrackPosition.ASCENDING_NORTH -> var1.north();
                    case BlockPropertyTrackPosition.ASCENDING_SOUTH -> var1.south();
                    default -> null;
                };
            }
        }
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, ICollisionAccess var1, BlockPosition var2) {
        if (var2.equals(this.ingoreBelow) || var2.equals(this.slopeIgnore)) {
            return VoxelShapes.empty();
        }
        return super.getCollisionShape(var0, var1, var2);
    }
}

