/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt.visitors;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;

public class CollectToTag
implements StreamTagVisitor {
    private final Deque<b> containerStack = new ArrayDeque<b>();

    public CollectToTag() {
        this.containerStack.addLast(new d());
    }

    @Nullable
    public NBTBase getResult() {
        return this.containerStack.getFirst().build();
    }

    protected int depth() {
        return this.containerStack.size() - 1;
    }

    private void appendEntry(NBTBase var0) {
        this.containerStack.getLast().acceptValue(var0);
    }

    @Override
    public StreamTagVisitor.b visitEnd() {
        this.appendEntry(NBTTagEnd.INSTANCE);
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(String var0) {
        this.appendEntry(NBTTagString.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(byte var0) {
        this.appendEntry(NBTTagByte.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(short var0) {
        this.appendEntry(NBTTagShort.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(int var0) {
        this.appendEntry(NBTTagInt.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(long var0) {
        this.appendEntry(NBTTagLong.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(float var0) {
        this.appendEntry(NBTTagFloat.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(double var0) {
        this.appendEntry(NBTTagDouble.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(byte[] var0) {
        this.appendEntry(new NBTTagByteArray(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(int[] var0) {
        this.appendEntry(new NBTTagIntArray(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(long[] var0) {
        this.appendEntry(new NBTTagLongArray(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visitList(NBTTagType<?> var0, int var1) {
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.a visitElement(NBTTagType<?> var0, int var1) {
        this.enterContainerIfNeeded(var0);
        return StreamTagVisitor.a.ENTER;
    }

    @Override
    public StreamTagVisitor.a visitEntry(NBTTagType<?> var0) {
        return StreamTagVisitor.a.ENTER;
    }

    @Override
    public StreamTagVisitor.a visitEntry(NBTTagType<?> var0, String var1) {
        this.containerStack.getLast().acceptKey(var1);
        this.enterContainerIfNeeded(var0);
        return StreamTagVisitor.a.ENTER;
    }

    private void enterContainerIfNeeded(NBTTagType<?> var0) {
        if (var0 == NBTTagList.TYPE) {
            this.containerStack.addLast(new c());
        } else if (var0 == NBTTagCompound.TYPE) {
            this.containerStack.addLast(new a());
        }
    }

    @Override
    public StreamTagVisitor.b visitContainerEnd() {
        b var0 = this.containerStack.removeLast();
        NBTBase var1 = var0.build();
        if (var1 != null) {
            this.containerStack.getLast().acceptValue(var1);
        }
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visitRootEntry(NBTTagType<?> var0) {
        this.enterContainerIfNeeded(var0);
        return StreamTagVisitor.b.CONTINUE;
    }

    static class d
    implements b {
        @Nullable
        private NBTBase result;

        d() {
        }

        @Override
        public void acceptValue(NBTBase var0) {
            this.result = var0;
        }

        @Override
        @Nullable
        public NBTBase build() {
            return this.result;
        }
    }

    static interface b {
        default public void acceptKey(String var0) {
        }

        public void acceptValue(NBTBase var1);

        @Nullable
        public NBTBase build();
    }

    static class c
    implements b {
        private final NBTTagList list = new NBTTagList();

        c() {
        }

        @Override
        public void acceptValue(NBTBase var0) {
            this.list.addAndUnwrap(var0);
        }

        @Override
        public NBTBase build() {
            return this.list;
        }
    }

    static class a
    implements b {
        private final NBTTagCompound compound = new NBTTagCompound();
        private String lastId = "";

        a() {
        }

        @Override
        public void acceptKey(String var0) {
            this.lastId = var0;
        }

        @Override
        public void acceptValue(NBTBase var0) {
            this.compound.put(this.lastId, var0);
        }

        @Override
        public NBTBase build() {
            return this.compound;
        }
    }
}

