/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;

public class VarInt {
    private static final int MAX_VARINT_SIZE = 5;
    private static final int DATA_BITS_MASK = 127;
    private static final int CONTINUATION_BIT_MASK = 128;
    private static final int DATA_BITS_PER_BYTE = 7;

    public static int getByteSize(int var0) {
        for (int var1 = 1; var1 < 5; ++var1) {
            if ((var0 & -1 << var1 * 7) != 0) continue;
            return var1;
        }
        return 5;
    }

    public static boolean hasContinuationBit(byte var0) {
        return (var0 & 0x80) == 128;
    }

    public static int read(ByteBuf var0) {
        byte var3;
        int var1 = 0;
        int var2 = 0;
        do {
            var3 = var0.readByte();
            var1 |= (var3 & 0x7F) << var2++ * 7;
            if (var2 <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while (VarInt.hasContinuationBit(var3));
        return var1;
    }

    public static ByteBuf write(ByteBuf var0, int var1) {
        while (true) {
            if ((var1 & 0xFFFFFF80) == 0) {
                var0.writeByte(var1);
                return var0;
            }
            var0.writeByte(var1 & 0x7F | 0x80);
            var1 >>>= 7;
        }
    }
}

