/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.IoSupplier;

public interface IResourcePack
extends AutoCloseable {
    public static final String METADATA_EXTENSION = ".mcmeta";
    public static final String PACK_META = "pack.mcmeta";

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... var1);

    @Nullable
    public IoSupplier<InputStream> getResource(EnumResourcePackType var1, MinecraftKey var2);

    public void listResources(EnumResourcePackType var1, String var2, String var3, a var4);

    public Set<String> getNamespaces(EnumResourcePackType var1);

    @Nullable
    public <T> T getMetadataSection(MetadataSectionType<T> var1) throws IOException;

    public PackLocationInfo location();

    default public String packId() {
        return this.location().id();
    }

    default public Optional<KnownPack> knownPackInfo() {
        return this.location().knownPackInfo();
    }

    @Override
    public void close();

    @FunctionalInterface
    public static interface a
    extends BiConsumer<MinecraftKey, IoSupplier<InputStream>> {
    }
}

