/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.JsonListEntry;

public abstract class ExpirableListEntry<T>
extends JsonListEntry<T> {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    public static final String EXPIRES_NEVER = "forever";
    protected final Date created;
    protected final String source;
    @Nullable
    protected final Date expires;
    protected final String reason;

    public ExpirableListEntry(@Nullable T var0, @Nullable Date var1, @Nullable String var2, @Nullable Date var3, @Nullable String var4) {
        super(var0);
        this.created = var1 == null ? new Date() : var1;
        this.source = var2 == null ? "(Unknown)" : var2;
        this.expires = var3;
        this.reason = var4 == null ? "Banned by an operator." : var4;
    }

    protected ExpirableListEntry(@Nullable T var0, JsonObject var1) {
        super(var0);
        Date var3;
        Date var2;
        try {
            var2 = var1.has("created") ? DATE_FORMAT.parse(var1.get("created").getAsString()) : new Date();
        }
        catch (ParseException var32) {
            var2 = new Date();
        }
        this.created = var2;
        this.source = var1.has("source") ? var1.get("source").getAsString() : "(Unknown)";
        try {
            var3 = var1.has("expires") ? DATE_FORMAT.parse(var1.get("expires").getAsString()) : null;
        }
        catch (ParseException var4) {
            var3 = null;
        }
        this.expires = var3;
        this.reason = var1.has("reason") ? var1.get("reason").getAsString() : "Banned by an operator.";
    }

    public Date getCreated() {
        return this.created;
    }

    public String getSource() {
        return this.source;
    }

    @Nullable
    public Date getExpires() {
        return this.expires;
    }

    public String getReason() {
        return this.reason;
    }

    public abstract IChatBaseComponent getDisplayName();

    @Override
    boolean hasExpired() {
        if (this.expires == null) {
            return false;
        }
        return this.expires.before(new Date());
    }

    @Override
    protected void serialize(JsonObject var0) {
        var0.addProperty("created", DATE_FORMAT.format(this.created));
        var0.addProperty("source", this.source);
        var0.addProperty("expires", this.expires == null ? EXPIRES_NEVER : DATE_FORMAT.format(this.expires));
        var0.addProperty("reason", this.reason);
    }
}

