/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class DataConverterCustomNameEntity
extends DataFix {
    public DataConverterCustomNameEntity(Schema var0) {
        super(var0, true);
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.ENTITY);
        Type var1 = this.getOutputSchema().getType(DataConverterTypes.ENTITY);
        OpticFinder var2 = DSL.fieldFinder((String)"id", DataConverterSchemaNamed.namespacedString());
        OpticFinder var3 = var0.findField("CustomName");
        Type var42 = var1.findFieldType("CustomName");
        return this.fixTypeEverywhereTyped("EntityCustomNameToComponentFix", var0, var1, var4 -> DataConverterCustomNameEntity.fixEntity(var4, var1, (OpticFinder<String>)var2, (OpticFinder<String>)var3, var42));
    }

    private static <T> Typed<?> fixEntity(Typed<?> var02, Type<?> var1, OpticFinder<String> var2, OpticFinder<String> var3, Type<T> var4) {
        Optional var5 = var02.getOptional(var3);
        if (var5.isEmpty()) {
            return ExtraDataFixUtils.cast(var1, var02);
        }
        if (((String)var5.get()).isEmpty()) {
            return SystemUtils.writeAndReadTypedOrThrow(var02, var1, var0 -> var0.remove("CustomName"));
        }
        String var6 = var02.getOptional(var2).orElse("");
        Dynamic<T> var7 = DataConverterCustomNameEntity.fixCustomName(var02.getOps(), (String)var5.get(), var6);
        return var02.set(var3, SystemUtils.readTypedOrThrow(var4, var7));
    }

    private static <T> Dynamic<T> fixCustomName(DynamicOps<T> var0, String var1, String var2) {
        if ("minecraft:commandblock_minecart".equals(var2)) {
            return new Dynamic(var0, var0.createString(var1));
        }
        return LegacyComponentDataFixUtils.createPlainTextComponent(var0, var1);
    }
}

