/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debugchart;

import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.minecraft.SystemUtils;
import net.minecraft.network.protocol.game.ClientboundDebugSamplePacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.debugchart.RemoteDebugSampleType;

public class DebugSampleSubscriptionTracker {
    public static final int STOP_SENDING_AFTER_TICKS = 200;
    public static final int STOP_SENDING_AFTER_MS = 10000;
    private final PlayerList playerList;
    private final Map<RemoteDebugSampleType, Map<EntityPlayer, b>> subscriptions;
    private final Queue<a> subscriptionRequestQueue = new LinkedList<a>();

    public DebugSampleSubscriptionTracker(PlayerList var02) {
        this.playerList = var02;
        this.subscriptions = SystemUtils.makeEnumMap(RemoteDebugSampleType.class, var0 -> Maps.newHashMap());
    }

    public boolean shouldLogSamples(RemoteDebugSampleType var0) {
        return !this.subscriptions.get((Object)var0).isEmpty();
    }

    public void broadcast(ClientboundDebugSamplePacket var0) {
        Set<EntityPlayer> var1 = this.subscriptions.get((Object)var0.debugSampleType()).keySet();
        for (EntityPlayer var3 : var1) {
            var3.connection.send(var0);
        }
    }

    public void subscribe(EntityPlayer var0, RemoteDebugSampleType var1) {
        if (this.playerList.isOp(var0.getGameProfile())) {
            this.subscriptionRequestQueue.add(new a(var0, var1));
        }
    }

    public void tick(int var0) {
        long var1 = SystemUtils.getMillis();
        this.handleSubscriptions(var1, var0);
        this.handleUnsubscriptions(var1, var0);
    }

    private void handleSubscriptions(long var0, int var2) {
        for (a var4 : this.subscriptionRequestQueue) {
            this.subscriptions.get((Object)var4.sampleType()).put(var4.player(), new b(var0, var2));
        }
    }

    private void handleUnsubscriptions(long var0, int var2) {
        for (Map<EntityPlayer, b> var4 : this.subscriptions.values()) {
            var4.entrySet().removeIf(var3 -> {
                boolean var4 = !this.playerList.isOp(((EntityPlayer)var3.getKey()).getGameProfile());
                b var5 = (b)var3.getValue();
                return var4 || var2 > var5.tick() + 200 && var0 > var5.millis() + 10000L;
            });
        }
    }

    record a(EntityPlayer player, RemoteDebugSampleType sampleType) {
    }

    record b(long millis, int tick) {
    }
}

