/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;

public interface IInventory
extends Clearable,
Iterable<ItemStack> {
    public static final float DEFAULT_DISTANCE_BUFFER = 4.0f;

    public int getContainerSize();

    public boolean isEmpty();

    public ItemStack getItem(int var1);

    public ItemStack removeItem(int var1, int var2);

    public ItemStack removeItemNoUpdate(int var1);

    public void setItem(int var1, ItemStack var2);

    default public int getMaxStackSize() {
        return 99;
    }

    default public int getMaxStackSize(ItemStack var0) {
        return Math.min(this.getMaxStackSize(), var0.getMaxStackSize());
    }

    public void setChanged();

    public boolean stillValid(EntityHuman var1);

    default public void startOpen(EntityHuman var0) {
    }

    default public void stopOpen(EntityHuman var0) {
    }

    default public boolean canPlaceItem(int var0, ItemStack var1) {
        return true;
    }

    default public boolean canTakeItem(IInventory var0, int var1, ItemStack var2) {
        return true;
    }

    default public int countItem(Item var0) {
        int var1 = 0;
        for (ItemStack var3 : this) {
            if (!var3.getItem().equals(var0)) continue;
            var1 += var3.getCount();
        }
        return var1;
    }

    default public boolean hasAnyOf(Set<Item> var0) {
        return this.hasAnyMatching(var1 -> !var1.isEmpty() && var0.contains(var1.getItem()));
    }

    default public boolean hasAnyMatching(Predicate<ItemStack> var0) {
        for (ItemStack var2 : this) {
            if (!var0.test(var2)) continue;
            return true;
        }
        return false;
    }

    public static boolean stillValidBlockEntity(TileEntity var0, EntityHuman var1) {
        return IInventory.stillValidBlockEntity(var0, var1, 4.0f);
    }

    public static boolean stillValidBlockEntity(TileEntity var0, EntityHuman var1, float var2) {
        World var3 = var0.getLevel();
        BlockPosition var4 = var0.getBlockPos();
        if (var3 == null) {
            return false;
        }
        if (var3.getBlockEntity(var4) != var0) {
            return false;
        }
        return var1.canInteractWithBlock(var4, var2);
    }

    @Override
    default public Iterator<ItemStack> iterator() {
        return new a(this);
    }

    public static class a
    implements Iterator<ItemStack> {
        private final IInventory container;
        private int index;
        private final int size;

        public a(IInventory var0) {
            this.container = var0;
            this.size = var0.getContainerSize();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public ItemStack next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.container.getItem(this.index++);
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }
}

