/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalMoveThroughVillage
extends PathfinderGoal {
    protected final EntityCreature mob;
    private final double speedModifier;
    @Nullable
    private PathEntity path;
    private BlockPosition poiPos;
    private final boolean onlyAtNight;
    private final List<BlockPosition> visited = Lists.newArrayList();
    private final int distanceToPoi;
    private final BooleanSupplier canDealWithDoors;

    public PathfinderGoalMoveThroughVillage(EntityCreature var0, double var1, boolean var3, int var4, BooleanSupplier var5) {
        this.mob = var0;
        this.speedModifier = var1;
        this.onlyAtNight = var3;
        this.distanceToPoi = var4;
        this.canDealWithDoors = var5;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        if (!PathfinderGoalUtil.hasGroundPathNavigation(var0)) {
            throw new IllegalArgumentException("Unsupported mob for MoveThroughVillageGoal");
        }
    }

    @Override
    public boolean canUse() {
        BlockPosition var1;
        if (!PathfinderGoalUtil.hasGroundPathNavigation(this.mob)) {
            return false;
        }
        this.updateVisited();
        if (this.onlyAtNight && this.mob.level().isBrightOutside()) {
            return false;
        }
        WorldServer var02 = (WorldServer)this.mob.level();
        if (!var02.isCloseToVillage(var1 = this.mob.blockPosition(), 6)) {
            return false;
        }
        Vec3D var22 = LandRandomPos.getPos(this.mob, 15, 7, var2 -> {
            if (!var02.isVillage((BlockPosition)var2)) {
                return Double.NEGATIVE_INFINITY;
            }
            Optional<BlockPosition> var3 = var02.getPoiManager().find(var0 -> var0.is(PoiTypeTags.VILLAGE), this::hasNotVisited, (BlockPosition)var2, 10, VillagePlace.Occupancy.IS_OCCUPIED);
            return var3.map(var1 -> -var1.distSqr(var1)).orElse(Double.NEGATIVE_INFINITY);
        });
        if (var22 == null) {
            return false;
        }
        Optional<BlockPosition> var3 = var02.getPoiManager().find(var0 -> var0.is(PoiTypeTags.VILLAGE), this::hasNotVisited, BlockPosition.containing(var22), 10, VillagePlace.Occupancy.IS_OCCUPIED);
        if (var3.isEmpty()) {
            return false;
        }
        this.poiPos = var3.get().immutable();
        Navigation var4 = (Navigation)this.mob.getNavigation();
        var4.setCanOpenDoors(this.canDealWithDoors.getAsBoolean());
        this.path = var4.createPath(this.poiPos, 0);
        var4.setCanOpenDoors(true);
        if (this.path == null) {
            Vec3D var5 = DefaultRandomPos.getPosTowards(this.mob, 10, 7, Vec3D.atBottomCenterOf(this.poiPos), 1.5707963705062866);
            if (var5 == null) {
                return false;
            }
            var4.setCanOpenDoors(this.canDealWithDoors.getAsBoolean());
            this.path = this.mob.getNavigation().createPath(var5.x, var5.y, var5.z, 0);
            var4.setCanOpenDoors(true);
            if (this.path == null) {
                return false;
            }
        }
        for (int var5 = 0; var5 < this.path.getNodeCount(); ++var5) {
            PathPoint var6 = this.path.getNode(var5);
            BlockPosition var7 = new BlockPosition(var6.x, var6.y + 1, var6.z);
            if (!BlockDoor.isWoodenDoor(this.mob.level(), var7)) continue;
            this.path = this.mob.getNavigation().createPath(var6.x, (double)var6.y, var6.z, 0);
            break;
        }
        return this.path != null;
    }

    @Override
    public boolean canContinueToUse() {
        if (this.mob.getNavigation().isDone()) {
            return false;
        }
        return !this.poiPos.closerToCenterThan(this.mob.position(), this.mob.getBbWidth() + (float)this.distanceToPoi);
    }

    @Override
    public void start() {
        this.mob.getNavigation().moveTo(this.path, this.speedModifier);
    }

    @Override
    public void stop() {
        if (this.mob.getNavigation().isDone() || this.poiPos.closerToCenterThan(this.mob.position(), this.distanceToPoi)) {
            this.visited.add(this.poiPos);
        }
    }

    private boolean hasNotVisited(BlockPosition var0) {
        for (BlockPosition var2 : this.visited) {
            if (!Objects.equals(var0, var2)) continue;
            return false;
        }
        return true;
    }

    private void updateVisited() {
        if (this.visited.size() > 15) {
            this.visited.remove(0);
        }
    }
}

