/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class MobSensor<T extends EntityLiving>
extends Sensor<T> {
    private final BiPredicate<T, EntityLiving> mobTest;
    private final Predicate<T> readyTest;
    private final MemoryModuleType<Boolean> toSet;
    private final int memoryTimeToLive;

    public MobSensor(int var0, BiPredicate<T, EntityLiving> var1, Predicate<T> var2, MemoryModuleType<Boolean> var3, int var4) {
        super(var0);
        this.mobTest = var1;
        this.readyTest = var2;
        this.toSet = var3;
        this.memoryTimeToLive = var4;
    }

    @Override
    protected void doTick(WorldServer var0, T var1) {
        if (!this.readyTest.test(var1)) {
            this.clearMemory(var1);
        } else {
            this.checkForMobsNearby(var1);
        }
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return Set.of(MemoryModuleType.NEAREST_LIVING_ENTITIES);
    }

    public void checkForMobsNearby(T var0) {
        Optional<List<EntityLiving>> var12 = ((EntityLiving)var0).getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES);
        if (var12.isEmpty()) {
            return;
        }
        boolean var2 = var12.get().stream().anyMatch(var1 -> this.mobTest.test((EntityLiving)var0, (EntityLiving)var1));
        if (var2) {
            this.mobDetected(var0);
        }
    }

    public void mobDetected(T var0) {
        ((EntityLiving)var0).getBrain().setMemoryWithExpiry(this.toSet, true, this.memoryTimeToLive);
    }

    public void clearMemory(T var0) {
        ((EntityLiving)var0).getBrain().eraseMemory(this.toSet);
    }
}

