/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.targeting;

import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;

public class PathfinderTargetCondition {
    public static final PathfinderTargetCondition DEFAULT = PathfinderTargetCondition.forCombat();
    private static final double MIN_VISIBILITY_DISTANCE_FOR_INVISIBLE_TARGET = 2.0;
    private final boolean isCombat;
    private double range = -1.0;
    private boolean checkLineOfSight = true;
    private boolean testInvisible = true;
    @Nullable
    private a selector;

    private PathfinderTargetCondition(boolean var0) {
        this.isCombat = var0;
    }

    public static PathfinderTargetCondition forCombat() {
        return new PathfinderTargetCondition(true);
    }

    public static PathfinderTargetCondition forNonCombat() {
        return new PathfinderTargetCondition(false);
    }

    public PathfinderTargetCondition copy() {
        PathfinderTargetCondition var0 = this.isCombat ? PathfinderTargetCondition.forCombat() : PathfinderTargetCondition.forNonCombat();
        var0.range = this.range;
        var0.checkLineOfSight = this.checkLineOfSight;
        var0.testInvisible = this.testInvisible;
        var0.selector = this.selector;
        return var0;
    }

    public PathfinderTargetCondition range(double var0) {
        this.range = var0;
        return this;
    }

    public PathfinderTargetCondition ignoreLineOfSight() {
        this.checkLineOfSight = false;
        return this;
    }

    public PathfinderTargetCondition ignoreInvisibilityTesting() {
        this.testInvisible = false;
        return this;
    }

    public PathfinderTargetCondition selector(@Nullable a var0) {
        this.selector = var0;
        return this;
    }

    public boolean test(WorldServer var0, @Nullable EntityLiving var1, EntityLiving var2) {
        if (var1 == var2) {
            return false;
        }
        if (!var2.canBeSeenByAnyone()) {
            return false;
        }
        if (this.selector != null && !this.selector.test(var2, var0)) {
            return false;
        }
        if (var1 == null) {
            if (this.isCombat && (!var2.canBeSeenAsEnemy() || var0.getDifficulty() == EnumDifficulty.PEACEFUL)) {
                return false;
            }
        } else {
            EntityInsentient var3;
            if (this.isCombat && (!var1.canAttack(var2) || !var1.canAttackType(var2.getType()) || var1.isAlliedTo(var2))) {
                return false;
            }
            if (this.range > 0.0) {
                double var32 = this.testInvisible ? var2.getVisibilityPercent(var1) : 1.0;
                double var5 = Math.max(this.range * var32, 2.0);
                double var7 = var1.distanceToSqr(var2.getX(), var2.getY(), var2.getZ());
                if (var7 > var5 * var5) {
                    return false;
                }
            }
            if (this.checkLineOfSight && var1 instanceof EntityInsentient && !(var3 = (EntityInsentient)var1).getSensing().hasLineOfSight(var2)) {
                return false;
            }
        }
        return true;
    }

    @FunctionalInterface
    public static interface a {
        public boolean test(EntityLiving var1, WorldServer var2);
    }
}

