/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int PARENT_AGE_AFTER_BREEDING = 6000;
    private static final int DEFAULT_IN_LOVE_TIME = 0;
    public int inLove = 0;
    @Nullable
    public EntityReference<EntityPlayer> loveCause;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> var0, World var1) {
        super((EntityTypes<? extends EntityAgeable>)var0, var1);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeProvider.Builder createAnimalAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.TEMPT_RANGE, 10.0);
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        super.customServerAiStep(var0);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double var0 = this.random.nextGaussian() * 0.02;
                double var2 = this.random.nextGaussian() * 0.02;
                double var4 = this.random.nextGaussian() * 0.02;
                this.level().addParticle(Particles.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), var0, var2, var4);
            }
        }
    }

    @Override
    protected void actuallyHurt(WorldServer var0, DamageSource var1, float var2) {
        this.resetLove();
        super.actuallyHurt(var0, var1, var2);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (var1.getBlockState(var0.below()).is(Blocks.GRASS_BLOCK)) {
            return 10.0f;
        }
        return var1.getPathfindingCostFromLightLevels(var0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("InLove", this.inLove);
        EntityReference.store(this.loveCause, var0, "LoveCause");
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.inLove = var0.getIntOr("InLove", 0);
        this.loveCause = EntityReference.read(var0, "LoveCause");
    }

    public static boolean checkAnimalSpawnRules(EntityTypes<? extends EntityAnimal> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        boolean var5 = EntitySpawnReason.ignoresLightRequirements(var2) || EntityAnimal.isBrightEnoughToSpawn(var1, var3);
        return var1.getBlockState(var3.below()).is(TagsBlock.ANIMALS_SPAWNABLE_ON) && var5;
    }

    protected static boolean isBrightEnoughToSpawn(IBlockLightAccess var0, BlockPosition var1) {
        return var0.getRawBrightness(var1, 0) > 8;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 120;
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return false;
    }

    @Override
    protected int getBaseExperienceReward(WorldServer var0) {
        return 1 + this.random.nextInt(3);
    }

    public abstract boolean isFood(ItemStack var1);

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (this.isFood(var2)) {
            int var3 = this.getAge();
            if (var0 instanceof EntityPlayer) {
                EntityPlayer var4 = (EntityPlayer)var0;
                if (var3 == 0 && this.canFallInLove()) {
                    this.usePlayerItem(var0, var1, var2);
                    this.setInLove(var4);
                    this.playEatingSound();
                    return EnumInteractionResult.SUCCESS_SERVER;
                }
            }
            if (this.isBaby()) {
                this.usePlayerItem(var0, var1, var2);
                this.ageUp(EntityAnimal.getSpeedUpSecondsWhenFeeding(-var3), true);
                this.playEatingSound();
                return EnumInteractionResult.SUCCESS;
            }
            if (this.level().isClientSide) {
                return EnumInteractionResult.CONSUME;
            }
        }
        return super.mobInteract(var0, var1);
    }

    protected void playEatingSound() {
    }

    protected void usePlayerItem(EntityHuman var0, EnumHand var1, ItemStack var2) {
        int var3 = var2.getCount();
        UseRemainder var4 = var2.get(DataComponents.USE_REMAINDER);
        var2.consume(1, var0);
        if (var4 != null) {
            ItemStack var5 = var4.convertIntoRemainder(var2, var3, var0.hasInfiniteMaterials(), var0::handleExtraItemsCreatedOnUse);
            var0.setItemInHand(var1, var5);
        }
    }

    public boolean canFallInLove() {
        return this.inLove <= 0;
    }

    public void setInLove(@Nullable EntityHuman var0) {
        this.inLove = 600;
        if (var0 instanceof EntityPlayer) {
            EntityPlayer var1 = (EntityPlayer)var0;
            this.loveCause = new EntityReference<EntityPlayer>(var1);
        }
        this.level().broadcastEntityEvent(this, (byte)18);
    }

    public void setInLoveTime(int var0) {
        this.inLove = var0;
    }

    public int getInLoveTime() {
        return this.inLove;
    }

    @Nullable
    public EntityPlayer getLoveCause() {
        return EntityReference.get(this.loveCause, this.level()::getPlayerByUUID, EntityPlayer.class);
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void resetLove() {
        this.inLove = 0;
    }

    public boolean canMate(EntityAnimal var0) {
        if (var0 == this) {
            return false;
        }
        if (var0.getClass() != this.getClass()) {
            return false;
        }
        return this.isInLove() && var0.isInLove();
    }

    public void spawnChildFromBreeding(WorldServer var0, EntityAnimal var1) {
        EntityAgeable var2 = this.getBreedOffspring(var0, var1);
        if (var2 == null) {
            return;
        }
        var2.setBaby(true);
        var2.snapTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
        this.finalizeSpawnChildFromBreeding(var0, var1, var2);
        var0.addFreshEntityWithPassengers(var2);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer var0, EntityAnimal var1, @Nullable EntityAgeable var22) {
        Optional.ofNullable(this.getLoveCause()).or(() -> Optional.ofNullable(var1.getLoveCause())).ifPresent(var2 -> {
            var2.awardStat(StatisticList.ANIMALS_BRED);
            CriterionTriggers.BRED_ANIMALS.trigger((EntityPlayer)var2, this, var1, var22);
        });
        this.setAge(6000);
        var1.setAge(6000);
        this.resetLove();
        var1.resetLove();
        var0.broadcastEntityEvent(this, (byte)18);
        if (var0.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            var0.addFreshEntity(new EntityExperienceOrb(var0, this.getX(), this.getY(), this.getZ(), this.getRandom().nextInt(7) + 1));
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 18) {
            for (int var1 = 0; var1 < 7; ++var1) {
                double var2 = this.random.nextGaussian() * 0.02;
                double var4 = this.random.nextGaussian() * 0.02;
                double var6 = this.random.nextGaussian() * 0.02;
                this.level().addParticle(Particles.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), var2, var4, var6);
            }
        } else {
            super.handleEntityEvent(var0);
        }
    }
}

