/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityHorseChestedAbstract
extends EntityHorseAbstract {
    private static final DataWatcherObject<Boolean> DATA_ID_CHEST = DataWatcher.defineId(EntityHorseChestedAbstract.class, DataWatcherRegistry.BOOLEAN);
    private static final boolean DEFAULT_HAS_CHEST = false;
    private final EntitySize babyDimensions;

    protected EntityHorseChestedAbstract(EntityTypes<? extends EntityHorseChestedAbstract> var0, World var1) {
        super((EntityTypes<? extends EntityHorseAbstract>)var0, var1);
        this.canGallop = false;
        this.babyDimensions = var0.getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, var0.getHeight() - 0.15625f, 0.0f)).scale(0.5f);
    }

    @Override
    protected void randomizeAttributes(RandomSource var0) {
        this.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(EntityHorseChestedAbstract.generateMaxHealth(var0::nextInt));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_ID_CHEST, false);
    }

    public static AttributeProvider.Builder createBaseChestedHorseAttributes() {
        return EntityHorseChestedAbstract.createBaseHorseAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.175f).add(GenericAttributes.JUMP_STRENGTH, 0.5);
    }

    public boolean hasChest() {
        return this.entityData.get(DATA_ID_CHEST);
    }

    public void setChest(boolean var0) {
        this.entityData.set(DATA_ID_CHEST, var0);
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return this.isBaby() ? this.babyDimensions : super.getDefaultDimensions(var0);
    }

    @Override
    protected void dropEquipment(WorldServer var0) {
        super.dropEquipment(var0);
        if (this.hasChest()) {
            this.spawnAtLocation(var0, Blocks.CHEST);
            this.setChest(false);
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("ChestedHorse", this.hasChest());
        if (this.hasChest()) {
            ValueOutput.a<ItemStackWithSlot> var1 = var0.list("Items", ItemStackWithSlot.CODEC);
            for (int var2 = 0; var2 < this.inventory.getContainerSize(); ++var2) {
                ItemStack var3 = this.inventory.getItem(var2);
                if (var3.isEmpty()) continue;
                var1.add(new ItemStackWithSlot(var2, var3));
            }
        }
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setChest(var0.getBooleanOr("ChestedHorse", false));
        this.createInventory();
        if (this.hasChest()) {
            for (ItemStackWithSlot var2 : var0.listOrEmpty("Items", ItemStackWithSlot.CODEC)) {
                if (!var2.isValidInContainer(this.inventory.getContainerSize())) continue;
                this.inventory.setItem(var2.slot(), var2.stack());
            }
        }
    }

    @Override
    public SlotAccess getSlot(int var0) {
        if (var0 == 499) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return EntityHorseChestedAbstract.this.hasChest() ? new ItemStack(Items.CHEST) : ItemStack.EMPTY;
                }

                @Override
                public boolean set(ItemStack var0) {
                    if (var0.isEmpty()) {
                        if (EntityHorseChestedAbstract.this.hasChest()) {
                            EntityHorseChestedAbstract.this.setChest(false);
                            EntityHorseChestedAbstract.this.createInventory();
                        }
                        return true;
                    }
                    if (var0.is(Items.CHEST)) {
                        if (!EntityHorseChestedAbstract.this.hasChest()) {
                            EntityHorseChestedAbstract.this.setChest(true);
                            EntityHorseChestedAbstract.this.createInventory();
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
        return super.getSlot(var0);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        boolean var2;
        boolean bl = var2 = !this.isBaby() && this.isTamed() && var0.isSecondaryUseActive();
        if (this.isVehicle() || var2) {
            return super.mobInteract(var0, var1);
        }
        ItemStack var3 = var0.getItemInHand(var1);
        if (!var3.isEmpty()) {
            if (this.isFood(var3)) {
                return this.fedFood(var0, var3);
            }
            if (!this.isTamed()) {
                this.makeMad();
                return EnumInteractionResult.SUCCESS;
            }
            if (!this.hasChest() && var3.is(Items.CHEST)) {
                this.equipChest(var0, var3);
                return EnumInteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(var0, var1);
    }

    private void equipChest(EntityHuman var0, ItemStack var1) {
        this.setChest(true);
        this.playChestEquipsSound();
        var1.consume(1, var0);
        this.createInventory();
    }

    @Override
    public Vec3D[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets(this, 0.04, 0.41, 0.18, 0.73);
    }

    protected void playChestEquipsSound() {
        this.playSound(SoundEffects.DONKEY_CHEST, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public int getInventoryColumns() {
        return this.hasChest() ? 5 : 0;
    }
}

