/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRestrictSun;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;

public abstract class EntitySkeletonAbstract
extends EntityMonster
implements IRangedEntity {
    private static final int HARD_ATTACK_INTERVAL = 20;
    private static final int NORMAL_ATTACK_INTERVAL = 40;
    private final PathfinderGoalBowShoot<EntitySkeletonAbstract> bowGoal = new PathfinderGoalBowShoot<EntitySkeletonAbstract>(this, 1.0, 20, 15.0f);
    private final PathfinderGoalMeleeAttack meleeGoal = new PathfinderGoalMeleeAttack(this, 1.2, false){

        @Override
        public void stop() {
            super.stop();
            EntitySkeletonAbstract.this.setAggressive(false);
        }

        @Override
        public void start() {
            super.start();
            EntitySkeletonAbstract.this.setAggressive(true);
        }
    };

    protected EntitySkeletonAbstract(EntityTypes<? extends EntitySkeletonAbstract> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
        this.reassessWeaponGoal();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(2, new PathfinderGoalRestrictSun(this));
        this.goalSelector.addGoal(3, new PathfinderGoalFleeSun(this, 1.0));
        this.goalSelector.addGoal(3, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.goalSelector.addGoal(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(6, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.BABY_ON_LAND_SELECTOR));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    abstract SoundEffect getStepSound();

    @Override
    public void aiStep() {
        boolean var0 = this.isSunBurnTick();
        if (var0) {
            ItemStack var1 = this.getItemBySlot(EnumItemSlot.HEAD);
            if (!var1.isEmpty()) {
                if (var1.isDamageableItem()) {
                    Item var2 = var1.getItem();
                    var1.setDamageValue(var1.getDamageValue() + this.random.nextInt(2));
                    if (var1.getDamageValue() >= var1.getMaxDamage()) {
                        this.onEquippedItemBroken(var2, EnumItemSlot.HEAD);
                        this.setItemSlot(EnumItemSlot.HEAD, ItemStack.EMPTY);
                    }
                }
                var0 = false;
            }
            if (var0) {
                this.igniteForSeconds(8.0f);
            }
        }
        super.aiStep();
    }

    @Override
    public void rideTick() {
        super.rideTick();
        Entity entity = this.getControlledVehicle();
        if (entity instanceof EntityCreature) {
            EntityCreature var0 = (EntityCreature)entity;
            this.yBodyRot = var0.yBodyRot;
        }
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource var0, DifficultyDamageScaler var1) {
        super.populateDefaultEquipmentSlots(var0, var1);
        this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.BOW));
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        var3 = super.finalizeSpawn(var0, var1, var2, var3);
        RandomSource var4 = var0.getRandom();
        this.populateDefaultEquipmentSlots(var4, var1);
        this.populateDefaultEquipmentEnchantments(var0, var4, var1);
        this.reassessWeaponGoal();
        this.setCanPickUpLoot(var4.nextFloat() < 0.55f * var1.getSpecialMultiplier());
        if (this.getItemBySlot(EnumItemSlot.HEAD).isEmpty()) {
            LocalDate var5 = LocalDate.now();
            int var6 = var5.get(ChronoField.DAY_OF_MONTH);
            int var7 = var5.get(ChronoField.MONTH_OF_YEAR);
            if (var7 == 10 && var6 == 31 && var4.nextFloat() < 0.25f) {
                this.setItemSlot(EnumItemSlot.HEAD, new ItemStack(var4.nextFloat() < 0.1f ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN));
                this.setDropChance(EnumItemSlot.HEAD, 0.0f);
            }
        }
        return var3;
    }

    public void reassessWeaponGoal() {
        if (this.level() == null || this.level().isClientSide) {
            return;
        }
        this.goalSelector.removeGoal(this.meleeGoal);
        this.goalSelector.removeGoal(this.bowGoal);
        ItemStack var0 = this.getItemInHand(ProjectileHelper.getWeaponHoldingHand(this, Items.BOW));
        if (var0.is(Items.BOW)) {
            int var1 = this.getHardAttackInterval();
            if (this.level().getDifficulty() != EnumDifficulty.HARD) {
                var1 = this.getAttackInterval();
            }
            this.bowGoal.setMinAttackInterval(var1);
            this.goalSelector.addGoal(4, this.bowGoal);
        } else {
            this.goalSelector.addGoal(4, this.meleeGoal);
        }
    }

    protected int getHardAttackInterval() {
        return 20;
    }

    protected int getAttackInterval() {
        return 40;
    }

    @Override
    public void performRangedAttack(EntityLiving var0, float var1) {
        ItemStack var2 = this.getItemInHand(ProjectileHelper.getWeaponHoldingHand(this, Items.BOW));
        ItemStack var3 = this.getProjectile(var2);
        EntityArrow var4 = this.getArrow(var3, var1, var2);
        double var5 = var0.getX() - this.getX();
        double var7 = var0.getY(0.3333333333333333) - var4.getY();
        double var9 = var0.getZ() - this.getZ();
        double var11 = Math.sqrt(var5 * var5 + var9 * var9);
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var13 = (WorldServer)world;
            IProjectile.spawnProjectileUsingShoot(var4, var13, var3, var5, var7 + var11 * (double)0.2f, var9, 1.6f, 14 - var13.getDifficulty().getId() * 4);
        }
        this.playSound(SoundEffects.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    protected EntityArrow getArrow(ItemStack var0, float var1, @Nullable ItemStack var2) {
        return ProjectileHelper.getMobArrow(this, var0, var1, var2);
    }

    @Override
    public boolean canFireProjectileWeapon(ItemProjectileWeapon var0) {
        return var0 == Items.BOW;
    }

    @Override
    public TagKey<Item> getPreferredWeaponType() {
        return TagsItem.SKELETON_PREFERRED_WEAPONS;
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.reassessWeaponGoal();
    }

    @Override
    public void onEquipItem(EnumItemSlot var0, ItemStack var1, ItemStack var2) {
        super.onEquipItem(var0, var1, var2);
        if (!this.level().isClientSide) {
            this.reassessWeaponGoal();
        }
    }

    public boolean isShaking() {
        return this.isFullyFrozen();
    }
}

