/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> DATA_VILLAGER_DATA = DataWatcher.defineId(EntityVillager.class, DataWatcherRegistry.VILLAGER_DATA);
    public static final int BREEDING_FOOD_THRESHOLD = 12;
    public static final Map<Item, Integer> FOOD_POINTS = ImmutableMap.of((Object)Items.BREAD, (Object)4, (Object)Items.POTATO, (Object)1, (Object)Items.CARROT, (Object)1, (Object)Items.BEETROOT, (Object)1);
    private static final int TRADES_PER_LEVEL = 2;
    private static final int MAX_GOSSIP_TOPICS = 10;
    private static final int GOSSIP_COOLDOWN = 1200;
    private static final int GOSSIP_DECAY_INTERVAL = 24000;
    private static final int HOW_FAR_AWAY_TO_TALK_TO_OTHER_VILLAGERS_ABOUT_GOLEMS = 10;
    private static final int HOW_MANY_VILLAGERS_NEED_TO_AGREE_TO_SPAWN_A_GOLEM = 5;
    private static final long TIME_SINCE_SLEEPING_FOR_GOLEM_SPAWNING = 24000L;
    @VisibleForTesting
    public static final float SPEED_MODIFIER = 0.5f;
    private static final int DEFAULT_XP = 0;
    private static final byte DEFAULT_FOOD_LEVEL = 0;
    private static final int DEFAULT_LAST_RESTOCK = 0;
    private static final int DEFAULT_LAST_GOSSIP_DECAY = 0;
    private static final int DEFAULT_RESTOCKS_TODAY = 0;
    private static final boolean DEFAULT_ASSIGN_PROFESSION_WHEN_SPAWNED = false;
    private int updateMerchantTimer;
    private boolean increaseProfessionLevelOnUpdate;
    @Nullable
    private EntityHuman lastTradedPlayer;
    private boolean chasing;
    private int foodLevel = 0;
    private final Reputation gossips = new Reputation();
    private long lastGossipTime;
    private long lastGossipDecayTime = 0L;
    private int villagerXp = 0;
    private long lastRestockGameTime = 0L;
    private int numberOfRestocksToday = 0;
    private long lastRestockCheckDayTime;
    private boolean assignProfessionWhenSpawned = false;
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.HOME, MemoryModuleType.JOB_SITE, MemoryModuleType.POTENTIAL_JOB_SITE, MemoryModuleType.MEETING_POINT, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.VISIBLE_VILLAGER_BABIES, MemoryModuleType.NEAREST_PLAYERS, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, (Object[])new MemoryModuleType[]{MemoryModuleType.WALK_TARGET, MemoryModuleType.LOOK_TARGET, MemoryModuleType.INTERACTION_TARGET, MemoryModuleType.BREED_TARGET, MemoryModuleType.PATH, MemoryModuleType.DOORS_TO_CLOSE, MemoryModuleType.NEAREST_BED, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.NEAREST_HOSTILE, MemoryModuleType.SECONDARY_JOB_SITE, MemoryModuleType.HIDING_PLACE, MemoryModuleType.HEARD_BELL_TIME, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.LAST_SLEPT, MemoryModuleType.LAST_WOKEN, MemoryModuleType.LAST_WORKED_AT_POI, MemoryModuleType.GOLEM_DETECTED_RECENTLY});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS, SensorType.NEAREST_ITEMS, SensorType.NEAREST_BED, SensorType.HURT_BY, SensorType.VILLAGER_HOSTILES, SensorType.VILLAGER_BABIES, SensorType.SECONDARY_POIS, SensorType.GOLEM_DETECTED);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> POI_MEMORIES = ImmutableMap.of(MemoryModuleType.HOME, (var0, var1) -> var1.is(PoiTypes.HOME), MemoryModuleType.JOB_SITE, (var0, var1) -> var0.getVillagerData().profession().value().heldJobSite().test((Holder<VillagePlaceType>)var1), MemoryModuleType.POTENTIAL_JOB_SITE, (var0, var1) -> VillagerProfession.ALL_ACQUIRABLE_JOBS.test((Holder<VillagePlaceType>)var1), MemoryModuleType.MEETING_POINT, (var0, var1) -> var1.is(PoiTypes.MEETING));

    public EntityVillager(EntityTypes<? extends EntityVillager> var0, World var1) {
        this(var0, var1, VillagerType.PLAINS);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> var0, World var1, ResourceKey<VillagerType> var2) {
        this(var0, var1, var1.registryAccess().getOrThrow(var2));
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> var0, World var1, Holder<VillagerType> var2) {
        super((EntityTypes<? extends EntityVillagerAbstract>)var0, var1);
        ((Navigation)this.getNavigation()).setCanOpenDoors(true);
        this.getNavigation().setCanFloat(true);
        this.getNavigation().setRequiredPathLength(48.0f);
        this.setCanPickUpLoot(true);
        this.setVillagerData(this.getVillagerData().withType(var2).withProfession(var1.registryAccess(), VillagerProfession.NONE));
    }

    public BehaviorController<EntityVillager> getBrain() {
        return super.getBrain();
    }

    protected BehaviorController.b<EntityVillager> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        BehaviorController<EntityVillager> var1 = this.brainProvider().makeBrain(var0);
        this.registerBrainGoals(var1);
        return var1;
    }

    public void refreshBrain(WorldServer var0) {
        BehaviorController<EntityVillager> var1 = this.getBrain();
        var1.stopAll(var0, this);
        this.brain = var1.copyWithoutBehaviors();
        this.registerBrainGoals(this.getBrain());
    }

    private void registerBrainGoals(BehaviorController<EntityVillager> var0) {
        Holder<VillagerProfession> var1 = this.getVillagerData().profession();
        if (this.isBaby()) {
            var0.setSchedule(Schedule.VILLAGER_BABY);
            var0.addActivity(Activity.PLAY, Behaviors.getPlayPackage(0.5f));
        } else {
            var0.setSchedule(Schedule.VILLAGER_DEFAULT);
            var0.addActivityWithConditions(Activity.WORK, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.getWorkPackage(var1, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT))));
        }
        var0.addActivity(Activity.CORE, Behaviors.getCorePackage(var1, 0.5f));
        var0.addActivityWithConditions(Activity.MEET, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.getMeetPackage(var1, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.MEETING_POINT, (Object)((Object)MemoryStatus.VALUE_PRESENT))));
        var0.addActivity(Activity.REST, Behaviors.getRestPackage(var1, 0.5f));
        var0.addActivity(Activity.IDLE, Behaviors.getIdlePackage(var1, 0.5f));
        var0.addActivity(Activity.PANIC, Behaviors.getPanicPackage(var1, 0.5f));
        var0.addActivity(Activity.PRE_RAID, Behaviors.getPreRaidPackage(var1, 0.5f));
        var0.addActivity(Activity.RAID, Behaviors.getRaidPackage(var1, 0.5f));
        var0.addActivity(Activity.HIDE, Behaviors.getHidePackage(var1, 0.5f));
        var0.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        var0.setDefaultActivity(Activity.IDLE);
        var0.setActiveActivityIfPossible(Activity.IDLE);
        var0.updateActivityFromSchedule(this.level().getDayTime(), this.level().getGameTime());
    }

    @Override
    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (this.level() instanceof WorldServer) {
            this.refreshBrain((WorldServer)this.level());
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.5);
    }

    public boolean assignProfessionWhenSpawned() {
        return this.assignProfessionWhenSpawned;
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        Raid var2;
        GameProfilerFiller var1 = Profiler.get();
        var1.push("villagerBrain");
        this.getBrain().tick(var0, this);
        var1.pop();
        if (this.assignProfessionWhenSpawned) {
            this.assignProfessionWhenSpawned = false;
        }
        if (!this.isTrading() && this.updateMerchantTimer > 0) {
            --this.updateMerchantTimer;
            if (this.updateMerchantTimer <= 0) {
                if (this.increaseProfessionLevelOnUpdate) {
                    this.increaseMerchantCareer();
                    this.increaseProfessionLevelOnUpdate = false;
                }
                this.addEffect(new MobEffect(MobEffects.REGENERATION, 200, 0));
            }
        }
        if (this.lastTradedPlayer != null) {
            var0.onReputationEvent(ReputationEvent.TRADE, this.lastTradedPlayer, this);
            var0.broadcastEntityEvent(this, (byte)14);
            this.lastTradedPlayer = null;
        }
        if (!this.isNoAi() && this.random.nextInt(100) == 0 && (var2 = var0.getRaidAt(this.blockPosition())) != null && var2.isActive() && !var2.isOver()) {
            var0.broadcastEntityEvent(this, (byte)42);
        }
        if (this.getVillagerData().profession().is(VillagerProfession.NONE) && this.isTrading()) {
            this.stopTrading();
        }
        super.customServerAiStep(var0);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getUnhappyCounter() > 0) {
            this.setUnhappyCounter(this.getUnhappyCounter() - 1);
        }
        this.maybeDecayGossip();
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (!var2.is(Items.VILLAGER_SPAWN_EGG) && this.isAlive() && !this.isTrading() && !this.isSleeping()) {
            if (this.isBaby()) {
                this.setUnhappy();
                return EnumInteractionResult.SUCCESS;
            }
            if (!this.level().isClientSide) {
                boolean var3 = this.getOffers().isEmpty();
                if (var1 == EnumHand.MAIN_HAND) {
                    if (var3) {
                        this.setUnhappy();
                    }
                    var0.awardStat(StatisticList.TALKED_TO_VILLAGER);
                }
                if (var3) {
                    return EnumInteractionResult.CONSUME;
                }
                this.startTrading(var0);
            }
            return EnumInteractionResult.SUCCESS;
        }
        return super.mobInteract(var0, var1);
    }

    public void setUnhappy() {
        this.setUnhappyCounter(40);
        if (!this.level().isClientSide()) {
            this.makeSound(SoundEffects.VILLAGER_NO);
        }
    }

    private void startTrading(EntityHuman var0) {
        this.updateSpecialPrices(var0);
        this.setTradingPlayer(var0);
        this.openTradingScreen(var0, this.getDisplayName(), this.getVillagerData().level());
    }

    @Override
    public void setTradingPlayer(@Nullable EntityHuman var0) {
        boolean var1 = this.getTradingPlayer() != null && var0 == null;
        super.setTradingPlayer(var0);
        if (var1) {
            this.stopTrading();
        }
    }

    @Override
    protected void stopTrading() {
        super.stopTrading();
        this.resetSpecialPrices();
    }

    private void resetSpecialPrices() {
        if (this.level().isClientSide()) {
            return;
        }
        for (MerchantRecipe var1 : this.getOffers()) {
            var1.resetSpecialPriceDiff();
        }
    }

    @Override
    public boolean canRestock() {
        return true;
    }

    public void restock() {
        this.updateDemand();
        for (MerchantRecipe var1 : this.getOffers()) {
            var1.resetUses();
        }
        this.resendOffersToTradingPlayer();
        this.lastRestockGameTime = this.level().getGameTime();
        ++this.numberOfRestocksToday;
    }

    private void resendOffersToTradingPlayer() {
        MerchantRecipeList var0 = this.getOffers();
        EntityHuman var1 = this.getTradingPlayer();
        if (var1 != null && !var0.isEmpty()) {
            var1.sendMerchantOffers(var1.containerMenu.containerId, var0, this.getVillagerData().level(), this.getVillagerXp(), this.showProgressBar(), this.canRestock());
        }
    }

    private boolean needsToRestock() {
        for (MerchantRecipe var1 : this.getOffers()) {
            if (!var1.needsRestock()) continue;
            return true;
        }
        return false;
    }

    private boolean allowedToRestock() {
        return this.numberOfRestocksToday == 0 || this.numberOfRestocksToday < 2 && this.level().getGameTime() > this.lastRestockGameTime + 2400L;
    }

    public boolean shouldRestock() {
        long var0 = this.lastRestockGameTime + 12000L;
        long var2 = this.level().getGameTime();
        boolean var4 = var2 > var0;
        long var5 = this.level().getDayTime();
        if (this.lastRestockCheckDayTime > 0L) {
            long var9 = var5 / 24000L;
            long var7 = this.lastRestockCheckDayTime / 24000L;
            var4 |= var9 > var7;
        }
        this.lastRestockCheckDayTime = var5;
        if (var4) {
            this.lastRestockGameTime = var2;
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.needsToRestock();
    }

    private void catchUpDemand() {
        int var0 = 2 - this.numberOfRestocksToday;
        if (var0 > 0) {
            for (MerchantRecipe var2 : this.getOffers()) {
                var2.resetUses();
            }
        }
        for (int var1 = 0; var1 < var0; ++var1) {
            this.updateDemand();
        }
        this.resendOffersToTradingPlayer();
    }

    private void updateDemand() {
        for (MerchantRecipe var1 : this.getOffers()) {
            var1.updateDemand();
        }
    }

    private void updateSpecialPrices(EntityHuman var0) {
        int var1 = this.getPlayerReputation(var0);
        if (var1 != 0) {
            for (MerchantRecipe var3 : this.getOffers()) {
                var3.addToSpecialPriceDiff(-MathHelper.floor((float)var1 * var3.getPriceMultiplier()));
            }
        }
        if (var0.hasEffect(MobEffects.HERO_OF_THE_VILLAGE)) {
            MobEffect var2 = var0.getEffect(MobEffects.HERO_OF_THE_VILLAGE);
            int var3 = var2.getAmplifier();
            for (MerchantRecipe var5 : this.getOffers()) {
                double var6 = 0.3 + 0.0625 * (double)var3;
                int var8 = (int)Math.floor(var6 * (double)var5.getBaseCostA().getCount());
                var5.addToSpecialPriceDiff(-Math.max(var8, 1));
            }
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_VILLAGER_DATA, EntityVillager.createDefaultVillagerData());
    }

    public static VillagerData createDefaultVillagerData() {
        return new VillagerData(BuiltInRegistries.VILLAGER_TYPE.getOrThrow(VillagerType.PLAINS), BuiltInRegistries.VILLAGER_PROFESSION.getOrThrow(VillagerProfession.NONE), 1);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.store("VillagerData", VillagerData.CODEC, this.getVillagerData());
        var0.putByte("FoodLevel", (byte)this.foodLevel);
        var0.store("Gossips", Reputation.CODEC, this.gossips);
        var0.putInt("Xp", this.villagerXp);
        var0.putLong("LastRestock", this.lastRestockGameTime);
        var0.putLong("LastGossipDecay", this.lastGossipDecayTime);
        var0.putInt("RestocksToday", this.numberOfRestocksToday);
        if (this.assignProfessionWhenSpawned) {
            var0.putBoolean("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.entityData.set(DATA_VILLAGER_DATA, var0.read("VillagerData", VillagerData.CODEC).orElseGet(EntityVillager::createDefaultVillagerData));
        this.foodLevel = var0.getByteOr("FoodLevel", (byte)0);
        this.gossips.clear();
        var0.read("Gossips", Reputation.CODEC).ifPresent(this.gossips::putAll);
        this.villagerXp = var0.getIntOr("Xp", 0);
        this.lastRestockGameTime = var0.getLongOr("LastRestock", 0L);
        this.lastGossipDecayTime = var0.getLongOr("LastGossipDecay", 0L);
        if (this.level() instanceof WorldServer) {
            this.refreshBrain((WorldServer)this.level());
        }
        this.numberOfRestocksToday = var0.getIntOr("RestocksToday", 0);
        this.assignProfessionWhenSpawned = var0.getBooleanOr("AssignProfessionWhenSpawned", false);
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        if (this.isSleeping()) {
            return null;
        }
        if (this.isTrading()) {
            return SoundEffects.VILLAGER_TRADE;
        }
        return SoundEffects.VILLAGER_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.VILLAGER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.VILLAGER_DEATH;
    }

    public void playWorkSound() {
        this.makeSound(this.getVillagerData().profession().value().workSound());
    }

    @Override
    public void setVillagerData(VillagerData var0) {
        VillagerData var1 = this.getVillagerData();
        if (!var1.profession().equals(var0.profession())) {
            this.offers = null;
        }
        this.entityData.set(DATA_VILLAGER_DATA, var0);
    }

    @Override
    public VillagerData getVillagerData() {
        return this.entityData.get(DATA_VILLAGER_DATA);
    }

    @Override
    protected void rewardTradeXp(MerchantRecipe var0) {
        int var1 = 3 + this.random.nextInt(4);
        this.villagerXp += var0.getXp();
        this.lastTradedPlayer = this.getTradingPlayer();
        if (this.shouldIncreaseLevel()) {
            this.updateMerchantTimer = 40;
            this.increaseProfessionLevelOnUpdate = true;
            var1 += 5;
        }
        if (var0.shouldRewardExp()) {
            this.level().addFreshEntity(new EntityExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), var1));
        }
    }

    @Override
    public void setLastHurtByMob(@Nullable EntityLiving var0) {
        if (var0 != null && this.level() instanceof WorldServer) {
            ((WorldServer)this.level()).onReputationEvent(ReputationEvent.VILLAGER_HURT, var0, this);
            if (this.isAlive() && var0 instanceof EntityHuman) {
                this.level().broadcastEntityEvent(this, (byte)13);
            }
        }
        super.setLastHurtByMob(var0);
    }

    @Override
    public void die(DamageSource var0) {
        LOGGER.info("Villager {} died, message: '{}'", (Object)this, (Object)var0.getLocalizedDeathMessage(this).getString());
        Entity var1 = var0.getEntity();
        if (var1 != null) {
            this.tellWitnessesThatIWasMurdered(var1);
        }
        this.releaseAllPois();
        super.die(var0);
    }

    public void releaseAllPois() {
        this.releasePoi(MemoryModuleType.HOME);
        this.releasePoi(MemoryModuleType.JOB_SITE);
        this.releasePoi(MemoryModuleType.POTENTIAL_JOB_SITE);
        this.releasePoi(MemoryModuleType.MEETING_POINT);
    }

    private void tellWitnessesThatIWasMurdered(Entity var0) {
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var1 = (WorldServer)world;
        Optional<NearestVisibleLivingEntities> var22 = this.brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        if (var22.isEmpty()) {
            return;
        }
        var22.get().findAll(ReputationHandler.class::isInstance).forEach(var2 -> var1.onReputationEvent(ReputationEvent.VILLAGER_KILLED, var0, (ReputationHandler)((Object)var2)));
    }

    public void releasePoi(MemoryModuleType<GlobalPos> var0) {
        if (!(this.level() instanceof WorldServer)) {
            return;
        }
        MinecraftServer var1 = ((WorldServer)this.level()).getServer();
        this.brain.getMemory(var0).ifPresent(var2 -> {
            WorldServer var3 = var1.getLevel(var2.dimension());
            if (var3 == null) {
                return;
            }
            VillagePlace var4 = var3.getPoiManager();
            Optional<Holder<VillagePlaceType>> var5 = var4.getType(var2.pos());
            BiPredicate<EntityVillager, Holder<VillagePlaceType>> var6 = POI_MEMORIES.get(var0);
            if (var5.isPresent() && var6.test(this, var5.get())) {
                var4.release(var2.pos());
                PacketDebug.sendPoiTicketCountPacket(var3, var2.pos());
            }
        });
    }

    @Override
    public boolean canBreed() {
        return this.foodLevel + this.countFoodPointsInInventory() >= 12 && !this.isSleeping() && this.getAge() == 0;
    }

    private boolean hungry() {
        return this.foodLevel < 12;
    }

    private void eatUntilFull() {
        if (!this.hungry() || this.countFoodPointsInInventory() == 0) {
            return;
        }
        for (int var0 = 0; var0 < this.getInventory().getContainerSize(); ++var0) {
            int var3;
            Integer var2;
            ItemStack var1 = this.getInventory().getItem(var0);
            if (var1.isEmpty() || (var2 = FOOD_POINTS.get(var1.getItem())) == null) continue;
            for (int var4 = var3 = var1.getCount(); var4 > 0; --var4) {
                this.foodLevel += var2.intValue();
                this.getInventory().removeItem(var0, 1);
                if (this.hungry()) continue;
                return;
            }
        }
    }

    public int getPlayerReputation(EntityHuman var02) {
        return this.gossips.getReputation(var02.getUUID(), var0 -> true);
    }

    private void digestFood(int var0) {
        this.foodLevel -= var0;
    }

    public void eatAndDigestFood() {
        this.eatUntilFull();
        this.digestFood(12);
    }

    public void setOffers(MerchantRecipeList var0) {
        this.offers = var0;
    }

    private boolean shouldIncreaseLevel() {
        int var0 = this.getVillagerData().level();
        return VillagerData.canLevelUp(var0) && this.villagerXp >= VillagerData.getMaxXpPerLevel(var0);
    }

    public void increaseMerchantCareer() {
        this.setVillagerData(this.getVillagerData().withLevel(this.getVillagerData().level() + 1));
        this.updateTrades();
    }

    @Override
    protected IChatBaseComponent getTypeName() {
        return this.getVillagerData().profession().value().name();
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 12) {
            this.addParticlesAroundSelf(Particles.HEART);
        } else if (var0 == 13) {
            this.addParticlesAroundSelf(Particles.ANGRY_VILLAGER);
        } else if (var0 == 14) {
            this.addParticlesAroundSelf(Particles.HAPPY_VILLAGER);
        } else if (var0 == 42) {
            this.addParticlesAroundSelf(Particles.SPLASH);
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        if (var2 == EntitySpawnReason.BREEDING) {
            this.setVillagerData(this.getVillagerData().withProfession(var0.registryAccess(), VillagerProfession.NONE));
        }
        if (var2 == EntitySpawnReason.COMMAND || var2 == EntitySpawnReason.SPAWN_ITEM_USE || EntitySpawnReason.isSpawner(var2) || var2 == EntitySpawnReason.DISPENSER) {
            this.setVillagerData(this.getVillagerData().withType(var0.registryAccess(), VillagerType.byBiome(var0.getBiome(this.blockPosition()))));
        }
        if (var2 == EntitySpawnReason.STRUCTURE) {
            this.assignProfessionWhenSpawned = true;
        }
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    @Nullable
    public EntityVillager getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        double var3 = this.random.nextDouble();
        Holder<VillagerType> var2 = var3 < 0.5 ? var0.registryAccess().getOrThrow(VillagerType.byBiome(var0.getBiome(this.blockPosition()))) : (var3 < 0.75 ? this.getVillagerData().type() : ((EntityVillager)var1).getVillagerData().type());
        EntityVillager var5 = new EntityVillager(EntityTypes.VILLAGER, (World)var0, var2);
        var5.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var5.blockPosition()), EntitySpawnReason.BREEDING, null);
        return var5;
    }

    @Override
    public void thunderHit(WorldServer var0, EntityLightning var12) {
        if (var0.getDifficulty() != EnumDifficulty.PEACEFUL) {
            LOGGER.info("Villager {} was struck by lightning {}.", (Object)this, (Object)var12);
            EntityWitch var2 = this.convertTo(EntityTypes.WITCH, ConversionParams.single(this, false, false), var1 -> {
                var1.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var1.blockPosition()), EntitySpawnReason.CONVERSION, null);
                var1.setPersistenceRequired();
                this.releaseAllPois();
            });
            if (var2 == null) {
                super.thunderHit(var0, var12);
            }
        } else {
            super.thunderHit(var0, var12);
        }
    }

    @Override
    protected void pickUpItem(WorldServer var0, EntityItem var1) {
        InventoryCarrier.pickUpItem(var0, this, this, var1);
    }

    @Override
    public boolean wantsToPickUp(WorldServer var0, ItemStack var1) {
        Item var2 = var1.getItem();
        return (var1.is(TagsItem.VILLAGER_PICKS_UP) || this.getVillagerData().profession().value().requestedItems().contains((Object)var2)) && this.getInventory().canAddItem(var1);
    }

    public boolean hasExcessFood() {
        return this.countFoodPointsInInventory() >= 24;
    }

    public boolean wantsMoreFood() {
        return this.countFoodPointsInInventory() < 12;
    }

    private int countFoodPointsInInventory() {
        InventorySubcontainer var0 = this.getInventory();
        return FOOD_POINTS.entrySet().stream().mapToInt(var1 -> var0.countItem((Item)var1.getKey()) * (Integer)var1.getValue()).sum();
    }

    public boolean hasFarmSeeds() {
        return this.getInventory().hasAnyMatching(var0 -> var0.is(TagsItem.VILLAGER_PLANTABLE_SEEDS));
    }

    @Override
    protected void updateTrades() {
        VillagerTrades.IMerchantRecipeOption[] var3;
        VillagerData var0 = this.getVillagerData();
        ResourceKey var1 = var0.profession().unwrapKey().orElse(null);
        if (var1 == null) {
            return;
        }
        Object var2 = this.level().enabledFeatures().contains(FeatureFlags.TRADE_REBALANCE) ? ((var3 = VillagerTrades.EXPERIMENTAL_TRADES.get(var1)) != null ? var3 : VillagerTrades.TRADES.get(var1)) : VillagerTrades.TRADES.get(var1);
        if (var2 == null || var2.isEmpty()) {
            return;
        }
        var3 = (VillagerTrades.IMerchantRecipeOption[])var2.get(var0.level());
        if (var3 == null) {
            return;
        }
        MerchantRecipeList var4 = this.getOffers();
        this.addOffersFromItemListings(var4, var3, 2);
    }

    public void gossip(WorldServer var0, EntityVillager var1, long var2) {
        if (var2 >= this.lastGossipTime && var2 < this.lastGossipTime + 1200L || var2 >= var1.lastGossipTime && var2 < var1.lastGossipTime + 1200L) {
            return;
        }
        this.gossips.transferFrom(var1.gossips, this.random, 10);
        this.lastGossipTime = var2;
        var1.lastGossipTime = var2;
        this.spawnGolemIfNeeded(var0, var2, 5);
    }

    private void maybeDecayGossip() {
        long var0 = this.level().getGameTime();
        if (this.lastGossipDecayTime == 0L) {
            this.lastGossipDecayTime = var0;
            return;
        }
        if (var0 < this.lastGossipDecayTime + 24000L) {
            return;
        }
        this.gossips.decay();
        this.lastGossipDecayTime = var0;
    }

    public void spawnGolemIfNeeded(WorldServer var0, long var1, int var3) {
        if (!this.wantsToSpawnGolem(var1)) {
            return;
        }
        AxisAlignedBB var4 = this.getBoundingBox().inflate(10.0, 10.0, 10.0);
        List<EntityVillager> var5 = var0.getEntitiesOfClass(EntityVillager.class, var4);
        List<EntityVillager> var6 = var5.stream().filter(var2 -> var2.wantsToSpawnGolem(var1)).limit(5L).toList();
        if (var6.size() < var3) {
            return;
        }
        if (SpawnUtil.trySpawnMob(EntityTypes.IRON_GOLEM, EntitySpawnReason.MOB_SUMMONED, var0, this.blockPosition(), 10, 8, 6, SpawnUtil.a.LEGACY_IRON_GOLEM, false).isEmpty()) {
            return;
        }
        var5.forEach(SensorGolemLastSeen::golemDetected);
    }

    public boolean wantsToSpawnGolem(long var0) {
        if (!this.golemSpawnConditionsMet(this.level().getGameTime())) {
            return false;
        }
        return !this.brain.hasMemoryValue(MemoryModuleType.GOLEM_DETECTED_RECENTLY);
    }

    @Override
    public void onReputationEventFrom(ReputationEvent var0, Entity var1) {
        if (var0 == ReputationEvent.ZOMBIE_VILLAGER_CURED) {
            this.gossips.add(var1.getUUID(), ReputationType.MAJOR_POSITIVE, 20);
            this.gossips.add(var1.getUUID(), ReputationType.MINOR_POSITIVE, 25);
        } else if (var0 == ReputationEvent.TRADE) {
            this.gossips.add(var1.getUUID(), ReputationType.TRADING, 2);
        } else if (var0 == ReputationEvent.VILLAGER_HURT) {
            this.gossips.add(var1.getUUID(), ReputationType.MINOR_NEGATIVE, 25);
        } else if (var0 == ReputationEvent.VILLAGER_KILLED) {
            this.gossips.add(var1.getUUID(), ReputationType.MAJOR_NEGATIVE, 25);
        }
    }

    @Override
    public int getVillagerXp() {
        return this.villagerXp;
    }

    public void setVillagerXp(int var0) {
        this.villagerXp = var0;
    }

    private void resetNumberOfRestocks() {
        this.catchUpDemand();
        this.numberOfRestocksToday = 0;
    }

    public Reputation getGossips() {
        return this.gossips;
    }

    public void setGossips(Reputation var0) {
        this.gossips.putAll(var0);
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    @Override
    public void startSleeping(BlockPosition var0) {
        super.startSleeping(var0);
        this.brain.setMemory(MemoryModuleType.LAST_SLEPT, this.level().getGameTime());
        this.brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        this.brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
    }

    @Override
    public void stopSleeping() {
        super.stopSleeping();
        this.brain.setMemory(MemoryModuleType.LAST_WOKEN, this.level().getGameTime());
    }

    private boolean golemSpawnConditionsMet(long var0) {
        Optional<Long> var22 = this.brain.getMemory(MemoryModuleType.LAST_SLEPT);
        return var22.filter(var2 -> var0 - var2 < 24000L).isPresent();
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.VILLAGER_VARIANT) {
            return EntityVillager.castComponentValue(var0, this.getVillagerData().type());
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.VILLAGER_VARIANT);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.VILLAGER_VARIANT) {
            Holder<VillagerType> var2 = EntityVillager.castComponentValue(DataComponents.VILLAGER_VARIANT, var1);
            this.setVillagerData(this.getVillagerData().withType(var2));
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }
}

