/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;

public class EntityEnderSignal
extends Entity
implements ItemSupplier {
    private static final float MIN_CAMERA_DISTANCE_SQUARED = 12.25f;
    private static final float TOO_FAR_SIGNAL_HEIGHT = 8.0f;
    private static final float TOO_FAR_DISTANCE = 12.0f;
    private static final DataWatcherObject<ItemStack> DATA_ITEM_STACK = DataWatcher.defineId(EntityEnderSignal.class, DataWatcherRegistry.ITEM_STACK);
    @Nullable
    public Vec3D target;
    public int life;
    public boolean surviveAfterDeath;

    public EntityEnderSignal(EntityTypes<? extends EntityEnderSignal> var0, World var1) {
        super(var0, var1);
    }

    public EntityEnderSignal(World var0, double var1, double var3, double var5) {
        this((EntityTypes<? extends EntityEnderSignal>)EntityTypes.EYE_OF_ENDER, var0);
        this.setPos(var1, var3, var5);
    }

    public void setItem(ItemStack var0) {
        if (var0.isEmpty()) {
            this.getEntityData().set(DATA_ITEM_STACK, this.getDefaultItem());
        } else {
            this.getEntityData().set(DATA_ITEM_STACK, var0.copyWithCount(1));
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM_STACK);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_ITEM_STACK, this.getDefaultItem());
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        if (this.tickCount < 2 && var0 < 12.25) {
            return false;
        }
        double var2 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(var2)) {
            var2 = 4.0;
        }
        return var0 < (var2 *= 64.0) * var2;
    }

    public void signalTo(Vec3D var0) {
        Vec3D var1 = var0.subtract(this.position());
        double var2 = var1.horizontalDistance();
        this.target = var2 > 12.0 ? this.position().add(var1.x / var2 * 12.0, 8.0, var1.z / var2 * 12.0) : var0;
        this.life = 0;
        this.surviveAfterDeath = this.random.nextInt(5) > 0;
    }

    @Override
    public void tick() {
        super.tick();
        Vec3D var0 = this.position().add(this.getDeltaMovement());
        if (!this.level().isClientSide() && this.target != null) {
            this.setDeltaMovement(EntityEnderSignal.updateDeltaMovement(this.getDeltaMovement(), var0, this.target));
        }
        if (this.level().isClientSide()) {
            Vec3D var1 = var0.subtract(this.getDeltaMovement().scale(0.25));
            this.spawnParticles(var1, this.getDeltaMovement());
        }
        this.setPos(var0);
        if (!this.level().isClientSide()) {
            ++this.life;
            if (this.life > 80 && !this.level().isClientSide) {
                this.playSound(SoundEffects.ENDER_EYE_DEATH, 1.0f, 1.0f);
                this.discard();
                if (this.surviveAfterDeath) {
                    this.level().addFreshEntity(new EntityItem(this.level(), this.getX(), this.getY(), this.getZ(), this.getItem()));
                } else {
                    this.level().levelEvent(2003, this.blockPosition(), 0);
                }
            }
        }
    }

    private void spawnParticles(Vec3D var0, Vec3D var1) {
        if (this.isInWater()) {
            for (int var2 = 0; var2 < 4; ++var2) {
                this.level().addParticle(Particles.BUBBLE, var0.x, var0.y, var0.z, var1.x, var1.y, var1.z);
            }
        } else {
            this.level().addParticle(Particles.PORTAL, var0.x + this.random.nextDouble() * 0.6 - 0.3, var0.y - 0.5, var0.z + this.random.nextDouble() * 0.6 - 0.3, var1.x, var1.y, var1.z);
        }
    }

    private static Vec3D updateDeltaMovement(Vec3D var0, Vec3D var1, Vec3D var2) {
        Vec3D var3 = new Vec3D(var2.x - var1.x, 0.0, var2.z - var1.z);
        double var4 = var3.length();
        double var6 = MathHelper.lerp(0.0025, var0.horizontalDistance(), var4);
        double var8 = var0.y;
        if (var4 < 1.0) {
            var6 *= 0.8;
            var8 *= 0.8;
        }
        double var10 = var1.y - var0.y < var2.y ? 1.0 : -1.0;
        return var3.scale(var6 / var4).add(0.0, var8 + (var10 - var8) * 0.015, 0.0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        var0.store("Item", ItemStack.CODEC, this.getItem());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        this.setItem(var0.read("Item", ItemStack.CODEC).orElse(this.getDefaultItem()));
    }

    private ItemStack getDefaultItem() {
        return new ItemStack(Items.ENDER_EYE);
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        return false;
    }
}

