/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityLlamaSpit
extends IProjectile {
    public EntityLlamaSpit(EntityTypes<? extends EntityLlamaSpit> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
    }

    public EntityLlamaSpit(World var0, EntityLlama var1) {
        this((EntityTypes<? extends EntityLlamaSpit>)EntityTypes.LLAMA_SPIT, var0);
        this.setOwner(var1);
        this.setPos(var1.getX() - (double)(var1.getBbWidth() + 1.0f) * 0.5 * (double)MathHelper.sin(var1.yBodyRot * ((float)Math.PI / 180)), var1.getEyeY() - (double)0.1f, var1.getZ() + (double)(var1.getBbWidth() + 1.0f) * 0.5 * (double)MathHelper.cos(var1.yBodyRot * ((float)Math.PI / 180)));
    }

    @Override
    protected double getDefaultGravity() {
        return 0.06;
    }

    @Override
    public void tick() {
        super.tick();
        Vec3D var0 = this.getDeltaMovement();
        MovingObjectPosition var1 = ProjectileHelper.getHitResultOnMoveVector(this, this::canHitEntity);
        this.hitTargetOrDeflectSelf(var1);
        double var2 = this.getX() + var0.x;
        double var4 = this.getY() + var0.y;
        double var6 = this.getZ() + var0.z;
        this.updateRotation();
        float var8 = 0.99f;
        if (this.level().getBlockStates(this.getBoundingBox()).noneMatch(BlockBase.BlockData::isAir)) {
            this.discard();
            return;
        }
        if (this.isInWater()) {
            this.discard();
            return;
        }
        this.setDeltaMovement(var0.scale(0.99f));
        this.applyGravity();
        this.setPos(var2, var4, var6);
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        Entity entity = this.getOwner();
        if (entity instanceof EntityLiving) {
            WorldServer var4;
            EntityLiving var1 = (EntityLiving)entity;
            Entity var2 = var0.getEntity();
            DamageSource var3 = this.damageSources().spit(this, var1);
            World world = this.level();
            if (world instanceof WorldServer && var2.hurtServer(var4 = (WorldServer)world, var3, 1.0f)) {
                EnchantmentManager.doPostAttackEffects(var4, var2, var3);
            }
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        super.onHitBlock(var0);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        double var1 = var0.getXa();
        double var3 = var0.getYa();
        double var5 = var0.getZa();
        for (int var7 = 0; var7 < 7; ++var7) {
            double var8 = 0.4 + 0.1 * (double)var7;
            this.level().addParticle(Particles.SPIT, this.getX(), this.getY(), this.getZ(), var1 * var8, var3, var5 * var8);
        }
        this.setDeltaMovement(var1, var3, var5);
    }
}

