/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityShulkerBullet
extends IProjectile {
    private static final double SPEED = 0.15;
    @Nullable
    private EntityReference<Entity> finalTarget;
    @Nullable
    private EnumDirection currentMoveDirection;
    private int flightSteps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;

    public EntityShulkerBullet(EntityTypes<? extends EntityShulkerBullet> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
        this.noPhysics = true;
    }

    public EntityShulkerBullet(World var0, EntityLiving var1, Entity var2, EnumDirection.EnumAxis var3) {
        this((EntityTypes<? extends EntityShulkerBullet>)EntityTypes.SHULKER_BULLET, var0);
        this.setOwner(var1);
        Vec3D var4 = var1.getBoundingBox().getCenter();
        this.snapTo(var4.x, var4.y, var4.z, this.getYRot(), this.getXRot());
        this.finalTarget = new EntityReference<Entity>(var2);
        this.currentMoveDirection = EnumDirection.UP;
        this.selectNextMoveDirection(var3, var2);
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        if (this.finalTarget != null) {
            var0.store("Target", UUIDUtil.CODEC, this.finalTarget.getUUID());
        }
        var0.storeNullable("Dir", EnumDirection.LEGACY_ID_CODEC, this.currentMoveDirection);
        var0.putInt("Steps", this.flightSteps);
        var0.putDouble("TXD", this.targetDeltaX);
        var0.putDouble("TYD", this.targetDeltaY);
        var0.putDouble("TZD", this.targetDeltaZ);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.flightSteps = var0.getIntOr("Steps", 0);
        this.targetDeltaX = var0.getDoubleOr("TXD", 0.0);
        this.targetDeltaY = var0.getDoubleOr("TYD", 0.0);
        this.targetDeltaZ = var0.getDoubleOr("TZD", 0.0);
        this.currentMoveDirection = var0.read("Dir", EnumDirection.LEGACY_ID_CODEC).orElse(null);
        this.finalTarget = EntityReference.read(var0, "Target");
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
    }

    @Nullable
    private EnumDirection getMoveDirection() {
        return this.currentMoveDirection;
    }

    private void setMoveDirection(@Nullable EnumDirection var0) {
        this.currentMoveDirection = var0;
    }

    private void selectNextMoveDirection(@Nullable EnumDirection.EnumAxis var0, @Nullable Entity var1) {
        BlockPosition var2;
        double var3 = 0.5;
        if (var1 == null) {
            var2 = this.blockPosition().below();
        } else {
            var3 = (double)var1.getBbHeight() * 0.5;
            var2 = BlockPosition.containing(var1.getX(), var1.getY() + var3, var1.getZ());
        }
        double var5 = (double)var2.getX() + 0.5;
        double var7 = (double)var2.getY() + var3;
        double var9 = (double)var2.getZ() + 0.5;
        EnumDirection var11 = null;
        if (!var2.closerToCenterThan(this.position(), 2.0)) {
            BlockPosition var12 = this.blockPosition();
            ArrayList var13 = Lists.newArrayList();
            if (var0 != EnumDirection.EnumAxis.X) {
                if (var12.getX() < var2.getX() && this.level().isEmptyBlock(var12.east())) {
                    var13.add(EnumDirection.EAST);
                } else if (var12.getX() > var2.getX() && this.level().isEmptyBlock(var12.west())) {
                    var13.add(EnumDirection.WEST);
                }
            }
            if (var0 != EnumDirection.EnumAxis.Y) {
                if (var12.getY() < var2.getY() && this.level().isEmptyBlock(var12.above())) {
                    var13.add(EnumDirection.UP);
                } else if (var12.getY() > var2.getY() && this.level().isEmptyBlock(var12.below())) {
                    var13.add(EnumDirection.DOWN);
                }
            }
            if (var0 != EnumDirection.EnumAxis.Z) {
                if (var12.getZ() < var2.getZ() && this.level().isEmptyBlock(var12.south())) {
                    var13.add(EnumDirection.SOUTH);
                } else if (var12.getZ() > var2.getZ() && this.level().isEmptyBlock(var12.north())) {
                    var13.add(EnumDirection.NORTH);
                }
            }
            var11 = EnumDirection.getRandom(this.random);
            if (var13.isEmpty()) {
                for (int var14 = 5; !this.level().isEmptyBlock(var12.relative(var11)) && var14 > 0; --var14) {
                    var11 = EnumDirection.getRandom(this.random);
                }
            } else {
                var11 = (EnumDirection)var13.get(this.random.nextInt(var13.size()));
            }
            var5 = this.getX() + (double)var11.getStepX();
            var7 = this.getY() + (double)var11.getStepY();
            var9 = this.getZ() + (double)var11.getStepZ();
        }
        this.setMoveDirection(var11);
        double var12 = var5 - this.getX();
        double var14 = var7 - this.getY();
        double var16 = var9 - this.getZ();
        double var18 = Math.sqrt(var12 * var12 + var14 * var14 + var16 * var16);
        if (var18 == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = var12 / var18 * 0.15;
            this.targetDeltaY = var14 / var18 * 0.15;
            this.targetDeltaZ = var16 / var18 * 0.15;
        }
        this.hasImpulse = true;
        this.flightSteps = 10 + this.random.nextInt(5) * 10;
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == EnumDifficulty.PEACEFUL) {
            this.discard();
        }
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        Vec3D var2;
        super.tick();
        Entity var0 = !this.level().isClientSide() ? EntityReference.get(this.finalTarget, this.level(), Entity.class) : null;
        MovingObjectPosition var1 = null;
        if (!this.level().isClientSide) {
            if (var0 == null) {
                this.finalTarget = null;
            }
            if (!(var0 == null || !var0.isAlive() || var0 instanceof EntityHuman && var0.isSpectator())) {
                this.targetDeltaX = MathHelper.clamp(this.targetDeltaX * 1.025, -1.0, 1.0);
                this.targetDeltaY = MathHelper.clamp(this.targetDeltaY * 1.025, -1.0, 1.0);
                this.targetDeltaZ = MathHelper.clamp(this.targetDeltaZ * 1.025, -1.0, 1.0);
                var2 = this.getDeltaMovement();
                this.setDeltaMovement(var2.add((this.targetDeltaX - var2.x) * 0.2, (this.targetDeltaY - var2.y) * 0.2, (this.targetDeltaZ - var2.z) * 0.2));
            } else {
                this.applyGravity();
            }
            var1 = ProjectileHelper.getHitResultOnMoveVector(this, this::canHitEntity);
        }
        var2 = this.getDeltaMovement();
        this.setPos(this.position().add(var2));
        this.applyEffectsFromBlocks();
        if (this.portalProcess != null && this.portalProcess.isInsidePortalThisTick()) {
            this.handlePortal();
        }
        if (var1 != null && this.isAlive() && var1.getType() != MovingObjectPosition.EnumMovingObjectType.MISS) {
            this.hitTargetOrDeflectSelf(var1);
        }
        ProjectileHelper.rotateTowardsMovement(this, 0.5f);
        if (this.level().isClientSide) {
            this.level().addParticle(Particles.END_ROD, this.getX() - var2.x, this.getY() - var2.y + 0.15, this.getZ() - var2.z, 0.0, 0.0, 0.0);
        } else if (var0 != null) {
            if (this.flightSteps > 0) {
                --this.flightSteps;
                if (this.flightSteps == 0) {
                    this.selectNextMoveDirection(this.currentMoveDirection == null ? null : this.currentMoveDirection.getAxis(), var0);
                }
            }
            if (this.currentMoveDirection != null) {
                BlockPosition var3 = this.blockPosition();
                EnumDirection.EnumAxis var4 = this.currentMoveDirection.getAxis();
                if (this.level().loadedAndEntityCanStandOn(var3.relative(this.currentMoveDirection), this)) {
                    this.selectNextMoveDirection(var4, var0);
                } else {
                    BlockPosition var5 = var0.blockPosition();
                    if (var4 == EnumDirection.EnumAxis.X && var3.getX() == var5.getX() || var4 == EnumDirection.EnumAxis.Z && var3.getZ() == var5.getZ() || var4 == EnumDirection.EnumAxis.Y && var3.getY() == var5.getY()) {
                        this.selectNextMoveDirection(var4, var0);
                    }
                }
            }
        }
    }

    @Override
    protected boolean isAffectedByBlocks() {
        return !this.isRemoved();
    }

    @Override
    protected boolean canHitEntity(Entity var0) {
        return super.canHitEntity(var0) && !var0.noPhysics;
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        return var0 < 16384.0;
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        Entity var1 = var0.getEntity();
        Entity var2 = this.getOwner();
        EntityLiving var3 = var2 instanceof EntityLiving ? (EntityLiving)var2 : null;
        DamageSource var4 = this.damageSources().mobProjectile(this, var3);
        boolean var5 = var1.hurtOrSimulate(var4, 4.0f);
        if (var5) {
            Object var6;
            World world = this.level();
            if (world instanceof WorldServer) {
                var6 = (WorldServer)world;
                EnchantmentManager.doPostAttackEffects((WorldServer)var6, var1, var4);
            }
            if (var1 instanceof EntityLiving) {
                var6 = (EntityLiving)var1;
                ((EntityLiving)var6).addEffect(new MobEffect(MobEffects.LEVITATION, 200), (Entity)MoreObjects.firstNonNull((Object)var2, (Object)this));
            }
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        super.onHitBlock(var0);
        ((WorldServer)this.level()).sendParticles(Particles.EXPLOSION, this.getX(), this.getY(), this.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
        this.playSound(SoundEffects.SHULKER_BULLET_HIT, 1.0f, 1.0f);
    }

    private void destroy() {
        this.discard();
        this.level().gameEvent(GameEvent.ENTITY_DAMAGE, this.position(), GameEvent.a.of(this));
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        this.destroy();
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public boolean hurtClient(DamageSource var0) {
        return true;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        this.playSound(SoundEffects.SHULKER_BULLET_HURT, 1.0f, 1.0f);
        var0.sendParticles(Particles.CRIT, this.getX(), this.getY(), this.getZ(), 15, 0.2, 0.2, 0.2, 0.0);
        this.destroy();
        return true;
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        double var1 = var0.getXa();
        double var3 = var0.getYa();
        double var5 = var0.getZa();
        this.setDeltaMovement(var1, var3, var5);
    }
}

