/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.mojang.datafixers.util.Pair;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class NewMinecartBehavior
extends MinecartBehavior {
    public static final int POS_ROT_LERP_TICKS = 3;
    public static final double ON_RAIL_Y_OFFSET = 0.1;
    public static final double OPPOSING_SLOPES_REST_AT_SPEED_THRESHOLD = 0.005;
    @Nullable
    private b cacheIndexAlpha;
    private int cachedLerpDelay;
    private float cachedPartialTick;
    private int lerpDelay = 0;
    public final List<a> lerpSteps = new LinkedList<a>();
    public final List<a> currentLerpSteps = new LinkedList<a>();
    public double currentLerpStepsTotalWeight = 0.0;
    public a oldLerp = a.ZERO;

    public NewMinecartBehavior(EntityMinecartAbstract var0) {
        super(var0);
    }

    @Override
    public void tick() {
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            this.lerpClientPositionAndRotation();
            boolean var1 = BlockMinecartTrackAbstract.isRail(this.level().getBlockState(this.minecart.getCurrentBlockPosOrRailBelow()));
            this.minecart.setOnRails(var1);
            return;
        }
        WorldServer var0 = (WorldServer)world;
        BlockPosition var1 = this.minecart.getCurrentBlockPosOrRailBelow();
        IBlockData var2 = this.level().getBlockState(var1);
        if (this.minecart.isFirstTick()) {
            this.minecart.setOnRails(BlockMinecartTrackAbstract.isRail(var2));
            this.adjustToRails(var1, var2, true);
        }
        this.minecart.applyGravity();
        this.minecart.moveAlongTrack(var0);
    }

    private void lerpClientPositionAndRotation() {
        if (--this.lerpDelay <= 0) {
            this.setOldLerpValues();
            this.currentLerpSteps.clear();
            if (!this.lerpSteps.isEmpty()) {
                this.currentLerpSteps.addAll(this.lerpSteps);
                this.lerpSteps.clear();
                this.currentLerpStepsTotalWeight = 0.0;
                for (a var1 : this.currentLerpSteps) {
                    this.currentLerpStepsTotalWeight += (double)var1.weight;
                }
                int n2 = this.lerpDelay = this.currentLerpStepsTotalWeight == 0.0 ? 0 : 3;
            }
        }
        if (this.cartHasPosRotLerp()) {
            this.setPos(this.getCartLerpPosition(1.0f));
            this.setDeltaMovement(this.getCartLerpMovements(1.0f));
            this.setXRot(this.getCartLerpXRot(1.0f));
            this.setYRot(this.getCartLerpYRot(1.0f));
        }
    }

    public void setOldLerpValues() {
        this.oldLerp = new a(this.position(), this.getDeltaMovement(), this.getYRot(), this.getXRot(), 0.0f);
    }

    public boolean cartHasPosRotLerp() {
        return !this.currentLerpSteps.isEmpty();
    }

    public float getCartLerpXRot(float var0) {
        b var1 = this.getCurrentLerpStep(var0);
        return MathHelper.rotLerp(var1.partialTicksInStep, var1.previousStep.xRot, var1.currentStep.xRot);
    }

    public float getCartLerpYRot(float var0) {
        b var1 = this.getCurrentLerpStep(var0);
        return MathHelper.rotLerp(var1.partialTicksInStep, var1.previousStep.yRot, var1.currentStep.yRot);
    }

    public Vec3D getCartLerpPosition(float var0) {
        b var1 = this.getCurrentLerpStep(var0);
        return MathHelper.lerp((double)var1.partialTicksInStep, var1.previousStep.position, var1.currentStep.position);
    }

    public Vec3D getCartLerpMovements(float var0) {
        b var1 = this.getCurrentLerpStep(var0);
        return MathHelper.lerp((double)var1.partialTicksInStep, var1.previousStep.movement, var1.currentStep.movement);
    }

    private b getCurrentLerpStep(float var0) {
        int var3;
        if (var0 == this.cachedPartialTick && this.lerpDelay == this.cachedLerpDelay && this.cacheIndexAlpha != null) {
            return this.cacheIndexAlpha;
        }
        float var1 = ((float)(3 - this.lerpDelay) + var0) / 3.0f;
        float var2 = 0.0f;
        float var4 = 1.0f;
        boolean var5 = false;
        for (var3 = 0; var3 < this.currentLerpSteps.size(); ++var3) {
            float var6 = this.currentLerpSteps.get((int)var3).weight;
            if (var6 <= 0.0f || !((double)(var2 += var6) >= this.currentLerpStepsTotalWeight * (double)var1)) continue;
            float var7 = var2 - var6;
            var4 = (float)(((double)var1 * this.currentLerpStepsTotalWeight - (double)var7) / (double)var6);
            var5 = true;
            break;
        }
        if (!var5) {
            var3 = this.currentLerpSteps.size() - 1;
        }
        a var6 = this.currentLerpSteps.get(var3);
        a var7 = var3 > 0 ? this.currentLerpSteps.get(var3 - 1) : this.oldLerp;
        this.cacheIndexAlpha = new b(var4, var6, var7);
        this.cachedLerpDelay = this.lerpDelay;
        this.cachedPartialTick = var0;
        return this.cacheIndexAlpha;
    }

    public void adjustToRails(BlockPosition var0, IBlockData var1, boolean var2) {
        boolean var15;
        Vec3D var11;
        Vec3D var13;
        boolean var12;
        if (!BlockMinecartTrackAbstract.isRail(var1)) {
            return;
        }
        BlockPropertyTrackPosition var3 = var1.getValue(((BlockMinecartTrackAbstract)var1.getBlock()).getShapeProperty());
        Pair<BaseBlockPosition, BaseBlockPosition> var4 = EntityMinecartAbstract.exits(var3);
        Vec3D var5 = new Vec3D((BaseBlockPosition)var4.getFirst()).scale(0.5);
        Vec3D var6 = new Vec3D((BaseBlockPosition)var4.getSecond()).scale(0.5);
        Vec3D var7 = var5.horizontal();
        Vec3D var8 = var6.horizontal();
        if (this.getDeltaMovement().length() > (double)1.0E-5f && this.getDeltaMovement().dot(var7) < this.getDeltaMovement().dot(var8) || this.isDecending(var8, var3)) {
            Vec3D var9 = var7;
            var7 = var8;
            var8 = var9;
        }
        float var9 = 180.0f - (float)(Math.atan2(var7.z, var7.x) * 180.0 / Math.PI);
        var9 += this.minecart.isFlipped() ? 180.0f : 0.0f;
        Vec3D var10 = this.position();
        boolean bl = var12 = var5.x() != var6.x() && var5.z() != var6.z();
        if (var12) {
            var13 = var6.subtract(var5);
            Vec3D var14 = var10.subtract(var0.getBottomCenter()).subtract(var5);
            Vec3D var152 = var13.scale(var13.dot(var14) / var13.dot(var13));
            var11 = var0.getBottomCenter().add(var5).add(var152);
            var9 = 180.0f - (float)(Math.atan2(var152.z, var152.x) * 180.0 / Math.PI);
            var9 += this.minecart.isFlipped() ? 180.0f : 0.0f;
        } else {
            boolean var132 = var5.subtract((Vec3D)var6).x != 0.0;
            boolean var14 = var5.subtract((Vec3D)var6).z != 0.0;
            var11 = new Vec3D(var14 ? var0.getCenter().x : var10.x, var0.getY(), var132 ? var0.getCenter().z : var10.z);
        }
        var13 = var11.subtract(var10);
        this.setPos(var10.add(var13));
        float var14 = 0.0f;
        boolean bl2 = var15 = var5.y() != var6.y();
        if (var15) {
            Vec3D var16 = var0.getBottomCenter().add(var8);
            double var17 = var16.distanceTo(this.position());
            this.setPos(this.position().add(0.0, var17 + 0.1, 0.0));
            var14 = this.minecart.isFlipped() ? 45.0f : -45.0f;
        } else {
            this.setPos(this.position().add(0.0, 0.1, 0.0));
        }
        this.setRotation(var9, var14);
        double var16 = var10.distanceTo(this.position());
        if (var16 > 0.0) {
            this.lerpSteps.add(new a(this.position(), this.getDeltaMovement(), this.getYRot(), this.getXRot(), var2 ? 0.0f : (float)var16));
        }
    }

    private void setRotation(float var0, float var1) {
        double var2 = Math.abs(var0 - this.getYRot());
        if (var2 >= 175.0 && var2 <= 185.0) {
            this.minecart.setFlipped(!this.minecart.isFlipped());
            var0 -= 180.0f;
            var1 *= -1.0f;
        }
        var1 = Math.clamp(var1, -45.0f, 45.0f);
        this.setXRot(var1 % 360.0f);
        this.setYRot(var0 % 360.0f);
    }

    @Override
    public void moveAlongTrack(WorldServer var0) {
        c var1 = new c();
        while (var1.shouldIterate() && this.minecart.isAlive()) {
            Vec3D var7;
            Object var6;
            Vec3D var2 = this.getDeltaMovement();
            BlockPosition var3 = this.minecart.getCurrentBlockPosOrRailBelow();
            IBlockData var4 = this.level().getBlockState(var3);
            boolean var5 = BlockMinecartTrackAbstract.isRail(var4);
            if (this.minecart.isOnRails() != var5) {
                this.minecart.setOnRails(var5);
                this.adjustToRails(var3, var4, false);
            }
            if (var5) {
                this.minecart.resetFallDistance();
                this.minecart.setOldPosAndRot();
                if (var4.is(Blocks.ACTIVATOR_RAIL)) {
                    this.minecart.activateMinecart(var3.getX(), var3.getY(), var3.getZ(), var4.getValue(BlockPoweredRail.POWERED));
                }
                var6 = var4.getValue(((BlockMinecartTrackAbstract)var4.getBlock()).getShapeProperty());
                var7 = this.calculateTrackSpeed(var0, var2.horizontal(), var1, var3, var4, (BlockPropertyTrackPosition)var6);
                var1.movementLeft = var1.firstIteration ? var7.horizontalDistance() : (var1.movementLeft += var7.horizontalDistance() - var2.horizontalDistance());
                this.setDeltaMovement(var7);
                var1.movementLeft = this.minecart.makeStepAlongTrack(var3, (BlockPropertyTrackPosition)var6, var1.movementLeft);
            } else {
                this.minecart.comeOffTrack(var0);
                var1.movementLeft = 0.0;
            }
            var6 = this.position();
            var7 = ((Vec3D)var6).subtract(this.minecart.oldPosition());
            double var8 = var7.length();
            if (var8 > (double)1.0E-5f) {
                if (var7.horizontalDistanceSqr() > (double)1.0E-5f) {
                    float var10 = 180.0f - (float)(Math.atan2(var7.z, var7.x) * 180.0 / Math.PI);
                    float var11 = this.minecart.onGround() && !this.minecart.isOnRails() ? 0.0f : 90.0f - (float)(Math.atan2(var7.horizontalDistance(), var7.y) * 180.0 / Math.PI);
                    this.setRotation(var10 += this.minecart.isFlipped() ? 180.0f : 0.0f, var11 *= this.minecart.isFlipped() ? -1.0f : 1.0f);
                } else if (!this.minecart.isOnRails()) {
                    this.setXRot(this.minecart.onGround() ? 0.0f : MathHelper.rotLerp(0.2f, this.getXRot(), 0.0f));
                }
                this.lerpSteps.add(new a((Vec3D)var6, this.getDeltaMovement(), this.getYRot(), this.getXRot(), (float)Math.min(var8, this.getMaxSpeed(var0))));
            } else if (var2.horizontalDistanceSqr() > 0.0) {
                this.lerpSteps.add(new a((Vec3D)var6, this.getDeltaMovement(), this.getYRot(), this.getXRot(), 1.0f));
            }
            if (var8 > (double)1.0E-5f || var1.firstIteration) {
                this.minecart.applyEffectsFromBlocks();
                this.minecart.applyEffectsFromBlocks();
            }
            var1.firstIteration = false;
        }
    }

    private Vec3D calculateTrackSpeed(WorldServer var0, Vec3D var1, c var2, BlockPosition var3, IBlockData var4, BlockPropertyTrackPosition var5) {
        Vec3D var7;
        Vec3D var72;
        Vec3D var6 = var1;
        if (!var2.hasGainedSlopeSpeed && (var72 = this.calculateSlopeSpeed(var6, var5)).horizontalDistanceSqr() != var6.horizontalDistanceSqr()) {
            var2.hasGainedSlopeSpeed = true;
            var6 = var72;
        }
        if (var2.firstIteration && (var72 = this.calculatePlayerInputSpeed(var6)).horizontalDistanceSqr() != var6.horizontalDistanceSqr()) {
            var2.hasHalted = true;
            var6 = var72;
        }
        if (!var2.hasHalted && (var72 = this.calculateHaltTrackSpeed(var6, var4)).horizontalDistanceSqr() != var6.horizontalDistanceSqr()) {
            var2.hasHalted = true;
            var6 = var72;
        }
        if (var2.firstIteration && (var6 = this.minecart.applyNaturalSlowdown(var6)).lengthSqr() > 0.0) {
            double var73 = Math.min(var6.length(), this.minecart.getMaxSpeed(var0));
            var6 = var6.normalize().scale(var73);
        }
        if (!var2.hasBoosted && (var7 = this.calculateBoostTrackSpeed(var6, var3, var4)).horizontalDistanceSqr() != var6.horizontalDistanceSqr()) {
            var2.hasBoosted = true;
            var6 = var7;
        }
        return var6;
    }

    private Vec3D calculateSlopeSpeed(Vec3D var0, BlockPropertyTrackPosition var1) {
        double var2 = Math.max(0.0078125, var0.horizontalDistance() * 0.02);
        if (this.minecart.isInWater()) {
            var2 *= 0.2;
        }
        return switch (var1) {
            case BlockPropertyTrackPosition.ASCENDING_EAST -> var0.add(-var2, 0.0, 0.0);
            case BlockPropertyTrackPosition.ASCENDING_WEST -> var0.add(var2, 0.0, 0.0);
            case BlockPropertyTrackPosition.ASCENDING_NORTH -> var0.add(0.0, 0.0, var2);
            case BlockPropertyTrackPosition.ASCENDING_SOUTH -> var0.add(0.0, 0.0, -var2);
            default -> var0;
        };
    }

    private Vec3D calculatePlayerInputSpeed(Vec3D var0) {
        Entity entity = this.minecart.getFirstPassenger();
        if (!(entity instanceof EntityPlayer)) {
            return var0;
        }
        EntityPlayer var1 = (EntityPlayer)entity;
        Vec3D var2 = var1.getLastClientMoveIntent();
        if (var2.lengthSqr() > 0.0) {
            Vec3D var3 = var2.normalize();
            double var4 = var0.horizontalDistanceSqr();
            if (var3.lengthSqr() > 0.0 && var4 < 0.01) {
                return var0.add(new Vec3D(var3.x, 0.0, var3.z).normalize().scale(0.001));
            }
        }
        return var0;
    }

    private Vec3D calculateHaltTrackSpeed(Vec3D var0, IBlockData var1) {
        if (!var1.is(Blocks.POWERED_RAIL) || var1.getValue(BlockPoweredRail.POWERED).booleanValue()) {
            return var0;
        }
        if (var0.length() < 0.03) {
            return Vec3D.ZERO;
        }
        return var0.scale(0.5);
    }

    private Vec3D calculateBoostTrackSpeed(Vec3D var0, BlockPosition var1, IBlockData var2) {
        if (!var2.is(Blocks.POWERED_RAIL) || !var2.getValue(BlockPoweredRail.POWERED).booleanValue()) {
            return var0;
        }
        if (var0.length() > 0.01) {
            return var0.normalize().scale(var0.length() + 0.06);
        }
        Vec3D var3 = this.minecart.getRedstoneDirection(var1);
        if (var3.lengthSqr() <= 0.0) {
            return var0;
        }
        return var3.scale(var0.length() + 0.2);
    }

    @Override
    public double stepAlongTrack(BlockPosition var0, BlockPropertyTrackPosition var1, double var2) {
        if (var2 < (double)1.0E-5f) {
            return 0.0;
        }
        Vec3D var4 = this.position();
        Pair<BaseBlockPosition, BaseBlockPosition> var5 = EntityMinecartAbstract.exits(var1);
        BaseBlockPosition var6 = (BaseBlockPosition)var5.getFirst();
        BaseBlockPosition var7 = (BaseBlockPosition)var5.getSecond();
        Vec3D var8 = this.getDeltaMovement().horizontal();
        if (var8.length() < (double)1.0E-5f) {
            this.setDeltaMovement(Vec3D.ZERO);
            return 0.0;
        }
        boolean var9 = var6.getY() != var7.getY();
        Vec3D var10 = new Vec3D(var7).scale(0.5).horizontal();
        Vec3D var11 = new Vec3D(var6).scale(0.5).horizontal();
        if (var8.dot(var11) < var8.dot(var10)) {
            var11 = var10;
        }
        Vec3D var12 = var0.getBottomCenter().add(var11).add(0.0, 0.1, 0.0).add(var11.normalize().scale(1.0E-5f));
        if (var9 && !this.isDecending(var8, var1)) {
            var12 = var12.add(0.0, 1.0, 0.0);
        }
        Vec3D var13 = var12.subtract(this.position()).normalize();
        var8 = var13.scale(var8.length() / var13.horizontalDistance());
        Vec3D var14 = var4.add(var8.normalize().scale(var2 * (double)(var9 ? MathHelper.SQRT_OF_TWO : 1.0f)));
        if (var4.distanceToSqr(var12) <= var4.distanceToSqr(var14)) {
            var2 = var12.subtract(var14).horizontalDistance();
            var14 = var12;
        } else {
            var2 = 0.0;
        }
        this.minecart.move(EnumMoveType.SELF, var14.subtract(var4));
        IBlockData var15 = this.level().getBlockState(BlockPosition.containing(var14));
        if (var9) {
            BlockPropertyTrackPosition var16;
            if (BlockMinecartTrackAbstract.isRail(var15) && this.restAtVShape(var1, var16 = var15.getValue(((BlockMinecartTrackAbstract)var15.getBlock()).getShapeProperty()))) {
                return 0.0;
            }
            double var162 = var12.horizontal().distanceTo(this.position().horizontal());
            double var18 = var12.y + (this.isDecending(var8, var1) ? var162 : -var162);
            if (this.position().y < var18) {
                this.setPos(this.position().x, var18, this.position().z);
            }
        }
        if (this.position().distanceTo(var4) < (double)1.0E-5f && var14.distanceTo(var4) > (double)1.0E-5f) {
            this.setDeltaMovement(Vec3D.ZERO);
            return 0.0;
        }
        this.setDeltaMovement(var8);
        return var2;
    }

    private boolean restAtVShape(BlockPropertyTrackPosition var0, BlockPropertyTrackPosition var1) {
        if (this.getDeltaMovement().lengthSqr() < 0.005 && var1.isSlope() && this.isDecending(this.getDeltaMovement(), var0) && !this.isDecending(this.getDeltaMovement(), var1)) {
            this.setDeltaMovement(Vec3D.ZERO);
            return true;
        }
        return false;
    }

    @Override
    public double getMaxSpeed(WorldServer var0) {
        return (double)var0.getGameRules().getInt(GameRules.RULE_MINECART_MAX_SPEED) * (this.minecart.isInWater() ? 0.5 : 1.0) / 20.0;
    }

    private boolean isDecending(Vec3D var0, BlockPropertyTrackPosition var1) {
        return switch (var1) {
            case BlockPropertyTrackPosition.ASCENDING_EAST -> {
                if (var0.x < 0.0) {
                    yield true;
                }
                yield false;
            }
            case BlockPropertyTrackPosition.ASCENDING_WEST -> {
                if (var0.x > 0.0) {
                    yield true;
                }
                yield false;
            }
            case BlockPropertyTrackPosition.ASCENDING_NORTH -> {
                if (var0.z > 0.0) {
                    yield true;
                }
                yield false;
            }
            case BlockPropertyTrackPosition.ASCENDING_SOUTH -> {
                if (var0.z < 0.0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public double getSlowdownFactor() {
        return this.minecart.isVehicle() ? 0.997 : 0.975;
    }

    @Override
    public boolean pushAndPickupEntities() {
        boolean var0 = this.pickupEntities(this.minecart.getBoundingBox().inflate(0.2, 0.0, 0.2));
        if (this.minecart.horizontalCollision || this.minecart.verticalCollision) {
            boolean var1 = this.pushEntities(this.minecart.getBoundingBox().inflate(1.0E-7));
            return var0 && !var1;
        }
        return false;
    }

    public boolean pickupEntities(AxisAlignedBB var0) {
        List<Entity> var1;
        if (this.minecart.isRideable() && !this.minecart.isVehicle() && !(var1 = this.level().getEntities(this.minecart, var0, IEntitySelector.pushableBy(this.minecart))).isEmpty()) {
            for (Entity var3 : var1) {
                boolean var4;
                if (var3 instanceof EntityHuman || var3 instanceof EntityIronGolem || var3 instanceof EntityMinecartAbstract || this.minecart.isVehicle() || var3.isPassenger() || !(var4 = var3.startRiding(this.minecart))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean pushEntities(AxisAlignedBB var0) {
        boolean var1;
        block3: {
            block2: {
                var1 = false;
                if (!this.minecart.isRideable()) break block2;
                List<Entity> var2 = this.level().getEntities(this.minecart, var0, IEntitySelector.pushableBy(this.minecart));
                if (var2.isEmpty()) break block3;
                for (Entity var4 : var2) {
                    if (!(var4 instanceof EntityHuman) && !(var4 instanceof EntityIronGolem) && !(var4 instanceof EntityMinecartAbstract) && !this.minecart.isVehicle() && !var4.isPassenger()) continue;
                    var4.push(this.minecart);
                    var1 = true;
                }
                break block3;
            }
            for (Entity var3 : this.level().getEntities(this.minecart, var0)) {
                if (this.minecart.hasPassenger(var3) || !var3.isPushable() || !(var3 instanceof EntityMinecartAbstract)) continue;
                var3.push(this.minecart);
                var1 = true;
            }
        }
        return var1;
    }

    public static final class a
    extends Record {
        final Vec3D position;
        final Vec3D movement;
        final float yRot;
        final float xRot;
        final float weight;
        public static final StreamCodec<ByteBuf, a> STREAM_CODEC = StreamCodec.composite(Vec3D.STREAM_CODEC, a::position, Vec3D.STREAM_CODEC, a::movement, ByteBufCodecs.ROTATION_BYTE, a::yRot, ByteBufCodecs.ROTATION_BYTE, a::xRot, ByteBufCodecs.FLOAT, a::weight, a::new);
        public static a ZERO = new a(Vec3D.ZERO, Vec3D.ZERO, 0.0f, 0.0f, 0.0f);

        public a(Vec3D var0, Vec3D var1, float var2, float var3, float var4) {
            this.position = var0;
            this.movement = var1;
            this.yRot = var2;
            this.xRot = var3;
            this.weight = var4;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "position;movement;yRot;xRot;weight", "position", "movement", "yRot", "xRot", "weight"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "position;movement;yRot;xRot;weight", "position", "movement", "yRot", "xRot", "weight"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "position;movement;yRot;xRot;weight", "position", "movement", "yRot", "xRot", "weight"}, this, var0);
        }

        public Vec3D position() {
            return this.position;
        }

        public Vec3D movement() {
            return this.movement;
        }

        public float yRot() {
            return this.yRot;
        }

        public float xRot() {
            return this.xRot;
        }

        public float weight() {
            return this.weight;
        }
    }

    static final class b
    extends Record {
        final float partialTicksInStep;
        final a currentStep;
        final a previousStep;

        b(float var0, a var1, a var2) {
            this.partialTicksInStep = var0;
            this.currentStep = var1;
            this.previousStep = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "partialTicksInStep;currentStep;previousStep", "partialTicksInStep", "currentStep", "previousStep"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "partialTicksInStep;currentStep;previousStep", "partialTicksInStep", "currentStep", "previousStep"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "partialTicksInStep;currentStep;previousStep", "partialTicksInStep", "currentStep", "previousStep"}, this, var0);
        }

        public float partialTicksInStep() {
            return this.partialTicksInStep;
        }

        public a currentStep() {
            return this.currentStep;
        }

        public a previousStep() {
            return this.previousStep;
        }
    }

    static class c {
        double movementLeft = 0.0;
        boolean firstIteration = true;
        boolean hasGainedSlopeSpeed = false;
        boolean hasHalted = false;
        boolean hasBoosted = false;

        c() {
        }

        public boolean shouldIterate() {
            return this.firstIteration || this.movementLeft > (double)1.0E-5f;
        }
    }
}

