/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class Item
implements FeatureElement,
IMaterial {
    public static final Codec<Holder<Item>> CODEC = BuiltInRegistries.ITEM.holderByNameCodec().validate(var0 -> var0.is(Items.AIR.builtInRegistryHolder()) ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)var0));
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.ITEM);
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<Block, Item> BY_BLOCK = Maps.newHashMap();
    public static final MinecraftKey BASE_ATTACK_DAMAGE_ID = MinecraftKey.withDefaultNamespace("base_attack_damage");
    public static final MinecraftKey BASE_ATTACK_SPEED_ID = MinecraftKey.withDefaultNamespace("base_attack_speed");
    public static final int DEFAULT_MAX_STACK_SIZE = 64;
    public static final int ABSOLUTE_MAX_STACK_SIZE = 99;
    public static final int MAX_BAR_WIDTH = 13;
    protected static final int APPROXIMATELY_INFINITE_USE_DURATION = 72000;
    private final Holder.c<Item> builtInRegistryHolder = BuiltInRegistries.ITEM.createIntrusiveHolder(this);
    private final DataComponentMap components;
    @Nullable
    private final Item craftingRemainingItem;
    protected final String descriptionId;
    private final FeatureFlagSet requiredFeatures;

    public static int getId(Item var0) {
        return var0 == null ? 0 : BuiltInRegistries.ITEM.getId(var0);
    }

    public static Item byId(int var0) {
        return BuiltInRegistries.ITEM.byId(var0);
    }

    @Deprecated
    public static Item byBlock(Block var0) {
        return BY_BLOCK.getOrDefault(var0, Items.AIR);
    }

    public Item(Info var0) {
        String var1;
        this.descriptionId = var0.effectiveDescriptionId();
        this.components = var0.buildAndValidateComponents(IChatBaseComponent.translatable(this.descriptionId), var0.effectiveModel());
        this.craftingRemainingItem = var0.craftingRemainingItem;
        this.requiredFeatures = var0.requiredFeatures;
        if (SharedConstants.IS_RUNNING_IN_IDE && !(var1 = this.getClass().getSimpleName()).endsWith("Item")) {
            LOGGER.error("Item classes should end with Item and {} doesn't.", (Object)var1);
        }
    }

    @Deprecated
    public Holder.c<Item> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    public DataComponentMap components() {
        return this.components;
    }

    public int getDefaultMaxStackSize() {
        return this.components.getOrDefault(DataComponents.MAX_STACK_SIZE, 1);
    }

    public void onUseTick(World var0, EntityLiving var1, ItemStack var2, int var3) {
    }

    public void onDestroyed(EntityItem var0) {
    }

    public void verifyComponentsAfterLoad(ItemStack var0) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canDestroyBlock(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityLiving var4) {
        Tool var5 = var0.get(DataComponents.TOOL);
        if (var5 == null) return true;
        if (var5.canDestroyBlocksInCreative()) return true;
        if (!(var4 instanceof EntityHuman)) return true;
        EntityHuman var6 = (EntityHuman)var4;
        if (var6.getAbilities().instabuild) return false;
        return true;
    }

    @Override
    public Item asItem() {
        return this;
    }

    public EnumInteractionResult useOn(ItemActionContext var0) {
        return EnumInteractionResult.PASS;
    }

    public float getDestroySpeed(ItemStack var0, IBlockData var1) {
        Tool var2 = var0.get(DataComponents.TOOL);
        return var2 != null ? var2.getMiningSpeed(var1) : 1.0f;
    }

    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        Consumable var4 = var3.get(DataComponents.CONSUMABLE);
        if (var4 != null) {
            return var4.startConsuming(var1, var3, var2);
        }
        Equippable var5 = var3.get(DataComponents.EQUIPPABLE);
        if (var5 != null && var5.swappable()) {
            return var5.swapWithEquipmentSlot(var3, var1);
        }
        BlocksAttacks var6 = var3.get(DataComponents.BLOCKS_ATTACKS);
        if (var6 != null) {
            var1.startUsingItem(var2);
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.PASS;
    }

    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var2) {
        Consumable var3 = var0.get(DataComponents.CONSUMABLE);
        if (var3 != null) {
            return var3.onConsume(var1, var2, var0);
        }
        return var0;
    }

    public boolean isBarVisible(ItemStack var0) {
        return var0.isDamaged();
    }

    public int getBarWidth(ItemStack var0) {
        return MathHelper.clamp(Math.round(13.0f - (float)var0.getDamageValue() * 13.0f / (float)var0.getMaxDamage()), 0, 13);
    }

    public int getBarColor(ItemStack var0) {
        int var1 = var0.getMaxDamage();
        float var2 = Math.max(0.0f, ((float)var1 - (float)var0.getDamageValue()) / (float)var1);
        return MathHelper.hsvToRgb(var2 / 3.0f, 1.0f, 1.0f);
    }

    public boolean overrideStackedOnOther(ItemStack var0, Slot var1, ClickAction var2, EntityHuman var3) {
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack var0, ItemStack var1, Slot var2, ClickAction var3, EntityHuman var4, SlotAccess var5) {
        return false;
    }

    public float getAttackDamageBonus(Entity var0, float var1, DamageSource var2) {
        return 0.0f;
    }

    @Nullable
    public DamageSource getDamageSource(EntityLiving var0) {
        return null;
    }

    public void hurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
    }

    public void postHurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
    }

    public boolean mineBlock(ItemStack var0, World var1, IBlockData var2, BlockPosition var3, EntityLiving var4) {
        Tool var5 = var0.get(DataComponents.TOOL);
        if (var5 == null) {
            return false;
        }
        if (!var1.isClientSide && var2.getDestroySpeed(var1, var3) != 0.0f && var5.damagePerBlock() > 0) {
            var0.hurtAndBreak(var5.damagePerBlock(), var4, EnumItemSlot.MAINHAND);
        }
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack var0, IBlockData var1) {
        Tool var2 = var0.get(DataComponents.TOOL);
        return var2 != null && var2.isCorrectForDrops(var1);
    }

    public EnumInteractionResult interactLivingEntity(ItemStack var0, EntityHuman var1, EntityLiving var2, EnumHand var3) {
        return EnumInteractionResult.PASS;
    }

    public String toString() {
        return BuiltInRegistries.ITEM.wrapAsHolder(this).getRegisteredName();
    }

    public final ItemStack getCraftingRemainder() {
        return this.craftingRemainingItem == null ? ItemStack.EMPTY : new ItemStack(this.craftingRemainingItem);
    }

    public void inventoryTick(ItemStack var0, WorldServer var1, Entity var2, @Nullable EnumItemSlot var3) {
    }

    public void onCraftedBy(ItemStack var0, EntityHuman var1) {
        this.onCraftedPostProcess(var0, var1.level());
    }

    public void onCraftedPostProcess(ItemStack var0, World var1) {
    }

    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        Consumable var1 = var0.get(DataComponents.CONSUMABLE);
        if (var1 != null) {
            return var1.animation();
        }
        BlocksAttacks var2 = var0.get(DataComponents.BLOCKS_ATTACKS);
        if (var2 != null) {
            return ItemUseAnimation.BLOCK;
        }
        return ItemUseAnimation.NONE;
    }

    public int getUseDuration(ItemStack var0, EntityLiving var1) {
        Consumable var2 = var0.get(DataComponents.CONSUMABLE);
        if (var2 != null) {
            return var2.consumeTicks();
        }
        BlocksAttacks var3 = var0.get(DataComponents.BLOCKS_ATTACKS);
        if (var3 != null) {
            return 72000;
        }
        return 0;
    }

    public boolean releaseUsing(ItemStack var0, World var1, EntityLiving var2, int var3) {
        return false;
    }

    @Deprecated
    public void appendHoverText(ItemStack var0, b var1, TooltipDisplay var2, Consumer<IChatBaseComponent> var3, TooltipFlag var4) {
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack var0) {
        return Optional.empty();
    }

    @VisibleForTesting
    public final String getDescriptionId() {
        return this.descriptionId;
    }

    public final IChatBaseComponent getName() {
        return this.components.getOrDefault(DataComponents.ITEM_NAME, CommonComponents.EMPTY);
    }

    public IChatBaseComponent getName(ItemStack var0) {
        return var0.getComponents().getOrDefault(DataComponents.ITEM_NAME, CommonComponents.EMPTY);
    }

    public boolean isFoil(ItemStack var0) {
        return var0.isEnchanted();
    }

    protected static MovingObjectPositionBlock getPlayerPOVHitResult(World var0, EntityHuman var1, RayTrace.FluidCollisionOption var2) {
        Vec3D var3 = var1.getEyePosition();
        Vec3D var4 = var3.add(var1.calculateViewVector(var1.getXRot(), var1.getYRot()).scale(var1.blockInteractionRange()));
        return var0.clip(new RayTrace(var3, var4, RayTrace.BlockCollisionOption.OUTLINE, var2, var1));
    }

    public boolean useOnRelease(ItemStack var0) {
        return false;
    }

    public ItemStack getDefaultInstance() {
        return new ItemStack(this);
    }

    public boolean canFitInsideContainerItems() {
        return true;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.requiredFeatures;
    }

    public boolean shouldPrintOpWarning(ItemStack var0, @Nullable EntityHuman var1) {
        return false;
    }

    public static class Info {
        private static final DependantName<Item, String> BLOCK_DESCRIPTION_ID = var0 -> SystemUtils.makeDescriptionId("block", var0.location());
        private static final DependantName<Item, String> ITEM_DESCRIPTION_ID = var0 -> SystemUtils.makeDescriptionId("item", var0.location());
        private final DataComponentMap.a components = DataComponentMap.builder().addAll(DataComponents.COMMON_ITEM_COMPONENTS);
        @Nullable
        Item craftingRemainingItem;
        FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;
        @Nullable
        private ResourceKey<Item> id;
        private DependantName<Item, String> descriptionId = ITEM_DESCRIPTION_ID;
        private DependantName<Item, MinecraftKey> model = ResourceKey::location;

        public Info food(FoodInfo var0) {
            return this.food(var0, Consumables.DEFAULT_FOOD);
        }

        public Info food(FoodInfo var0, Consumable var1) {
            return this.component(DataComponents.FOOD, var0).component(DataComponents.CONSUMABLE, var1);
        }

        public Info usingConvertsTo(Item var0) {
            return this.component(DataComponents.USE_REMAINDER, new UseRemainder(new ItemStack(var0)));
        }

        public Info useCooldown(float var0) {
            return this.component(DataComponents.USE_COOLDOWN, new UseCooldown(var0));
        }

        public Info stacksTo(int var0) {
            return this.component(DataComponents.MAX_STACK_SIZE, var0);
        }

        public Info durability(int var0) {
            this.component(DataComponents.MAX_DAMAGE, var0);
            this.component(DataComponents.MAX_STACK_SIZE, 1);
            this.component(DataComponents.DAMAGE, 0);
            return this;
        }

        public Info craftRemainder(Item var0) {
            this.craftingRemainingItem = var0;
            return this;
        }

        public Info rarity(EnumItemRarity var0) {
            return this.component(DataComponents.RARITY, var0);
        }

        public Info fireResistant() {
            return this.component(DataComponents.DAMAGE_RESISTANT, new DamageResistant(DamageTypeTags.IS_FIRE));
        }

        public Info jukeboxPlayable(ResourceKey<JukeboxSong> var0) {
            return this.component(DataComponents.JUKEBOX_PLAYABLE, new JukeboxPlayable(new EitherHolder<JukeboxSong>(var0)));
        }

        public Info enchantable(int var0) {
            return this.component(DataComponents.ENCHANTABLE, new Enchantable(var0));
        }

        public Info repairable(Item var0) {
            return this.component(DataComponents.REPAIRABLE, new Repairable(HolderSet.direct(var0.builtInRegistryHolder())));
        }

        public Info repairable(TagKey<Item> var0) {
            HolderGetter<Item> var1 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.ITEM);
            return this.component(DataComponents.REPAIRABLE, new Repairable(var1.getOrThrow(var0)));
        }

        public Info equippable(EnumItemSlot var0) {
            return this.component(DataComponents.EQUIPPABLE, Equippable.builder(var0).build());
        }

        public Info equippableUnswappable(EnumItemSlot var0) {
            return this.component(DataComponents.EQUIPPABLE, Equippable.builder(var0).setSwappable(false).build());
        }

        public Info tool(ToolMaterial var0, TagKey<Block> var1, float var2, float var3, float var4) {
            return var0.applyToolProperties(this, var1, var2, var3, var4);
        }

        public Info pickaxe(ToolMaterial var0, float var1, float var2) {
            return this.tool(var0, TagsBlock.MINEABLE_WITH_PICKAXE, var1, var2, 0.0f);
        }

        public Info axe(ToolMaterial var0, float var1, float var2) {
            return this.tool(var0, TagsBlock.MINEABLE_WITH_AXE, var1, var2, 5.0f);
        }

        public Info hoe(ToolMaterial var0, float var1, float var2) {
            return this.tool(var0, TagsBlock.MINEABLE_WITH_HOE, var1, var2, 0.0f);
        }

        public Info shovel(ToolMaterial var0, float var1, float var2) {
            return this.tool(var0, TagsBlock.MINEABLE_WITH_SHOVEL, var1, var2, 0.0f);
        }

        public Info sword(ToolMaterial var0, float var1, float var2) {
            return var0.applySwordProperties(this, var1, var2);
        }

        public Info humanoidArmor(ArmorMaterial var0, ArmorType var1) {
            return this.durability(var1.getDurability(var0.durability())).attributes(var0.createAttributes(var1)).enchantable(var0.enchantmentValue()).component(DataComponents.EQUIPPABLE, Equippable.builder(var1.getSlot()).setEquipSound(var0.equipSound()).setAsset(var0.assetId()).build()).repairable(var0.repairIngredient());
        }

        public Info wolfArmor(ArmorMaterial var0) {
            return this.durability(ArmorType.BODY.getDurability(var0.durability())).attributes(var0.createAttributes(ArmorType.BODY)).repairable(var0.repairIngredient()).component(DataComponents.EQUIPPABLE, Equippable.builder(EnumItemSlot.BODY).setEquipSound(var0.equipSound()).setAsset(var0.assetId()).setAllowedEntities(HolderSet.direct(EntityTypes.WOLF.builtInRegistryHolder())).setCanBeSheared(true).setShearingSound(BuiltInRegistries.SOUND_EVENT.wrapAsHolder(SoundEffects.ARMOR_UNEQUIP_WOLF)).build()).component(DataComponents.BREAK_SOUND, SoundEffects.WOLF_ARMOR_BREAK).stacksTo(1);
        }

        public Info horseArmor(ArmorMaterial var0) {
            HolderGetter<EntityTypes<?>> var1 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.ENTITY_TYPE);
            return this.attributes(var0.createAttributes(ArmorType.BODY)).component(DataComponents.EQUIPPABLE, Equippable.builder(EnumItemSlot.BODY).setEquipSound(SoundEffects.HORSE_ARMOR).setAsset(var0.assetId()).setAllowedEntities(var1.getOrThrow(TagsEntity.CAN_WEAR_HORSE_ARMOR)).setDamageOnHurt(false).setCanBeSheared(true).setShearingSound(SoundEffects.HORSE_ARMOR_UNEQUIP).build()).stacksTo(1);
        }

        public Info trimMaterial(ResourceKey<TrimMaterial> var0) {
            return this.component(DataComponents.PROVIDES_TRIM_MATERIAL, new ProvidesTrimMaterial(var0));
        }

        public Info requiredFeatures(FeatureFlag ... var0) {
            this.requiredFeatures = FeatureFlags.REGISTRY.subset(var0);
            return this;
        }

        public Info setId(ResourceKey<Item> var0) {
            this.id = var0;
            return this;
        }

        public Info overrideDescription(String var0) {
            this.descriptionId = DependantName.fixed(var0);
            return this;
        }

        public Info useBlockDescriptionPrefix() {
            this.descriptionId = BLOCK_DESCRIPTION_ID;
            return this;
        }

        public Info useItemDescriptionPrefix() {
            this.descriptionId = ITEM_DESCRIPTION_ID;
            return this;
        }

        protected String effectiveDescriptionId() {
            return this.descriptionId.get(Objects.requireNonNull(this.id, "Item id not set"));
        }

        public MinecraftKey effectiveModel() {
            return this.model.get(Objects.requireNonNull(this.id, "Item id not set"));
        }

        public <T> Info component(DataComponentType<T> var0, T var1) {
            this.components.set(var0, var1);
            return this;
        }

        public Info attributes(ItemAttributeModifiers var0) {
            return this.component(DataComponents.ATTRIBUTE_MODIFIERS, var0);
        }

        DataComponentMap buildAndValidateComponents(IChatBaseComponent var0, MinecraftKey var1) {
            DataComponentMap var2 = this.components.set(DataComponents.ITEM_NAME, var0).set(DataComponents.ITEM_MODEL, var1).build();
            if (var2.has(DataComponents.DAMAGE) && var2.getOrDefault(DataComponents.MAX_STACK_SIZE, 1) > 1) {
                throw new IllegalStateException("Item cannot have both durability and be stackable");
            }
            return var2;
        }
    }

    public static interface b {
        public static final b EMPTY = new b(){

            @Override
            @Nullable
            public HolderLookup.a registries() {
                return null;
            }

            @Override
            public float tickRate() {
                return 20.0f;
            }

            @Override
            @Nullable
            public WorldMap mapData(MapId var0) {
                return null;
            }
        };

        @Nullable
        public HolderLookup.a registries();

        public float tickRate();

        @Nullable
        public WorldMap mapData(MapId var1);

        public static b of(final @Nullable World var0) {
            if (var0 == null) {
                return EMPTY;
            }
            return new b(){

                @Override
                public HolderLookup.a registries() {
                    return var0.registryAccess();
                }

                @Override
                public float tickRate() {
                    return var0.tickRateManager().tickrate();
                }

                @Override
                public WorldMap mapData(MapId var02) {
                    return var0.getMapData(var02);
                }
            };
        }

        public static b of(final HolderLookup.a var0) {
            return new b(){

                @Override
                public HolderLookup.a registries() {
                    return var0;
                }

                @Override
                public float tickRate() {
                    return 20.0f;
                }

                @Override
                @Nullable
                public WorldMap mapData(MapId var02) {
                    return null;
                }
            };
        }
    }
}

