/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemHoe
extends Item {
    protected static final Map<Block, Pair<Predicate<ItemActionContext>, Consumer<ItemActionContext>>> TILLABLES = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.GRASS_BLOCK, (Object)Pair.of(ItemHoe::onlyIfAirAbove, ItemHoe.changeIntoState(Blocks.FARMLAND.defaultBlockState())), (Object)Blocks.DIRT_PATH, (Object)Pair.of(ItemHoe::onlyIfAirAbove, ItemHoe.changeIntoState(Blocks.FARMLAND.defaultBlockState())), (Object)Blocks.DIRT, (Object)Pair.of(ItemHoe::onlyIfAirAbove, ItemHoe.changeIntoState(Blocks.FARMLAND.defaultBlockState())), (Object)Blocks.COARSE_DIRT, (Object)Pair.of(ItemHoe::onlyIfAirAbove, ItemHoe.changeIntoState(Blocks.DIRT.defaultBlockState())), (Object)Blocks.ROOTED_DIRT, (Object)Pair.of(var0 -> true, ItemHoe.changeIntoStateAndDropItem(Blocks.DIRT.defaultBlockState(), Items.HANGING_ROOTS))));

    public ItemHoe(ToolMaterial var0, float var1, float var2, Item.Info var3) {
        super(var3.hoe(var0, var1, var2));
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var2;
        World var1 = var0.getLevel();
        Pair<Predicate<ItemActionContext>, Consumer<ItemActionContext>> var3 = TILLABLES.get(var1.getBlockState(var2 = var0.getClickedPos()).getBlock());
        if (var3 == null) {
            return EnumInteractionResult.PASS;
        }
        Predicate var4 = (Predicate)var3.getFirst();
        Consumer var5 = (Consumer)var3.getSecond();
        if (var4.test(var0)) {
            EntityHuman var6 = var0.getPlayer();
            var1.playSound((Entity)var6, var2, SoundEffects.HOE_TILL, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!var1.isClientSide) {
                var5.accept(var0);
                if (var6 != null) {
                    var0.getItemInHand().hurtAndBreak(1, (EntityLiving)var6, EntityLiving.getSlotForHand(var0.getHand()));
                }
            }
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    public static Consumer<ItemActionContext> changeIntoState(IBlockData var0) {
        return var1 -> {
            var1.getLevel().setBlock(var1.getClickedPos(), var0, 11);
            var1.getLevel().gameEvent(GameEvent.BLOCK_CHANGE, var1.getClickedPos(), GameEvent.a.of(var1.getPlayer(), var0));
        };
    }

    public static Consumer<ItemActionContext> changeIntoStateAndDropItem(IBlockData var0, IMaterial var1) {
        return var2 -> {
            var2.getLevel().setBlock(var2.getClickedPos(), var0, 11);
            var2.getLevel().gameEvent(GameEvent.BLOCK_CHANGE, var2.getClickedPos(), GameEvent.a.of(var2.getPlayer(), var0));
            Block.popResourceFromFace(var2.getLevel(), var2.getClickedPos(), var2.getClickedFace(), new ItemStack(var1));
        };
    }

    public static boolean onlyIfAirAbove(ItemActionContext var0) {
        return var0.getClickedFace() != EnumDirection.DOWN && var0.getLevel().getBlockState(var0.getClickedPos().above()).isAir();
    }
}

