/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class ItemMonsterEgg
extends Item {
    private static final Map<EntityTypes<? extends EntityInsentient>, ItemMonsterEgg> BY_ID = Maps.newIdentityHashMap();
    private final EntityTypes<?> defaultType;

    public ItemMonsterEgg(EntityTypes<? extends EntityInsentient> var0, Item.Info var1) {
        super(var1);
        this.defaultType = var0;
        BY_ID.put(var0, this);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        EntityTypes<?> var7;
        World var1 = var0.getLevel();
        if (var1.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        ItemStack var2 = var0.getItemInHand();
        BlockPosition var3 = var0.getClickedPos();
        EnumDirection var4 = var0.getClickedFace();
        IBlockData var5 = var1.getBlockState(var3);
        TileEntity tileEntity = var1.getBlockEntity(var3);
        if (tileEntity instanceof Spawner) {
            Spawner var6 = (Spawner)((Object)tileEntity);
            var7 = this.getType(var1.registryAccess(), var2);
            var6.setEntityId(var7, var1.getRandom());
            var1.sendBlockUpdated(var3, var5, var5, 3);
            var1.gameEvent((Entity)var0.getPlayer(), GameEvent.BLOCK_CHANGE, var3);
            var2.shrink(1);
            return EnumInteractionResult.SUCCESS;
        }
        BlockPosition var6 = var5.getCollisionShape(var1, var3).isEmpty() ? var3 : var3.relative(var4);
        var7 = this.getType(var1.registryAccess(), var2);
        if (var7.spawn((WorldServer)var1, var2, var0.getPlayer(), var6, EntitySpawnReason.SPAWN_ITEM_USE, true, !Objects.equals(var3, var6) && var4 == EnumDirection.UP) != null) {
            var2.shrink(1);
            var1.gameEvent((Entity)var0.getPlayer(), GameEvent.ENTITY_PLACE, var3);
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        MovingObjectPositionBlock var4 = ItemMonsterEgg.getPlayerPOVHitResult(var0, var1, RayTrace.FluidCollisionOption.SOURCE_ONLY);
        if (var4.getType() != MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            return EnumInteractionResult.PASS;
        }
        if (!(var0 instanceof WorldServer)) {
            return EnumInteractionResult.SUCCESS;
        }
        WorldServer var5 = (WorldServer)var0;
        MovingObjectPositionBlock var6 = var4;
        BlockPosition var7 = var6.getBlockPos();
        if (!(var0.getBlockState(var7).getBlock() instanceof BlockFluids)) {
            return EnumInteractionResult.PASS;
        }
        if (!var0.mayInteract(var1, var7) || !var1.mayUseItemAt(var7, var6.getDirection(), var3)) {
            return EnumInteractionResult.FAIL;
        }
        EntityTypes<?> var8 = this.getType(var5.registryAccess(), var3);
        Object var9 = var8.spawn(var5, var3, var1, var7, EntitySpawnReason.SPAWN_ITEM_USE, false, false);
        if (var9 == null) {
            return EnumInteractionResult.PASS;
        }
        var3.consume(1, var1);
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        var0.gameEvent((Entity)var1, GameEvent.ENTITY_PLACE, ((Entity)var9).position());
        return EnumInteractionResult.SUCCESS;
    }

    public boolean spawnsEntity(HolderLookup.a var0, ItemStack var1, EntityTypes<?> var2) {
        return Objects.equals(this.getType(var0, var1), var2);
    }

    @Nullable
    public static ItemMonsterEgg byId(@Nullable EntityTypes<?> var0) {
        return BY_ID.get(var0);
    }

    public static Iterable<ItemMonsterEgg> eggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }

    public EntityTypes<?> getType(HolderLookup.a var0, ItemStack var1) {
        EntityTypes<?> var3;
        CustomData var2 = var1.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        if (!var2.isEmpty() && (var3 = var2.parseEntityType(var0, Registries.ENTITY_TYPE)) != null) {
            return var3;
        }
        return this.defaultType;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.defaultType.requiredFeatures();
    }

    public Optional<EntityInsentient> spawnOffspringFromSpawnEgg(EntityHuman var0, EntityInsentient var1, EntityTypes<? extends EntityInsentient> var2, WorldServer var3, Vec3D var4, ItemStack var5) {
        if (!this.spawnsEntity(var3.registryAccess(), var5, var2)) {
            return Optional.empty();
        }
        EntityInsentient var6 = var1 instanceof EntityAgeable ? ((EntityAgeable)var1).getBreedOffspring(var3, (EntityAgeable)var1) : var2.create(var3, EntitySpawnReason.SPAWN_ITEM_USE);
        if (var6 == null) {
            return Optional.empty();
        }
        var6.setBaby(true);
        if (!var6.isBaby()) {
            return Optional.empty();
        }
        var6.snapTo(var4.x(), var4.y(), var4.z(), 0.0f, 0.0f);
        var6.applyComponentsFromItemStack(var5);
        var3.addFreshEntityWithPassengers(var6);
        var5.consume(1, var0);
        return Optional.of(var6);
    }

    @Override
    public boolean shouldPrintOpWarning(ItemStack var0, @Nullable EntityHuman var1) {
        CustomData var2;
        if (var1 != null && var1.getPermissionLevel() >= 2 && (var2 = var0.get(DataComponents.ENTITY_DATA)) != null) {
            EntityTypes<?> var3 = var2.parseEntityType(var1.level().registryAccess(), Registries.ENTITY_TYPE);
            return var3 != null && var3.onlyOpCanSetNbt();
        }
        return false;
    }
}

