/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.World;

public abstract class ItemPotionThrowable
extends ItemPotion
implements ProjectileItem {
    public static float PROJECTILE_SHOOT_POWER = 0.5f;

    public ItemPotionThrowable(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (var0 instanceof WorldServer) {
            WorldServer var4 = (WorldServer)var0;
            IProjectile.spawnProjectileFromRotation(this::createPotion, var4, var3, var1, -20.0f, PROJECTILE_SHOOT_POWER, 1.0f);
        }
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        var3.consume(1, var1);
        return EnumInteractionResult.SUCCESS;
    }

    protected abstract EntityPotion createPotion(WorldServer var1, EntityLiving var2, ItemStack var3);

    protected abstract EntityPotion createPotion(World var1, IPosition var2, ItemStack var3);

    @Override
    public IProjectile asProjectile(World var0, IPosition var1, ItemStack var2, EnumDirection var3) {
        return this.createPotion(var0, var1, var2);
    }

    @Override
    public ProjectileItem.a createDispenseConfig() {
        return ProjectileItem.a.builder().uncertainty(ProjectileItem.a.DEFAULT.uncertainty() * 0.5f).power(ProjectileItem.a.DEFAULT.power() * 1.25f).build();
    }
}

