/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.Codec;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public record JukeboxPlayable(EitherHolder<JukeboxSong> song) implements TooltipProvider
{
    public static final Codec<JukeboxPlayable> CODEC = EitherHolder.codec(Registries.JUKEBOX_SONG, JukeboxSong.CODEC).xmap(JukeboxPlayable::new, JukeboxPlayable::song);
    public static final StreamCodec<RegistryFriendlyByteBuf, JukeboxPlayable> STREAM_CODEC = StreamCodec.composite(EitherHolder.streamCodec(Registries.JUKEBOX_SONG, JukeboxSong.STREAM_CODEC), JukeboxPlayable::song, JukeboxPlayable::new);

    @Override
    public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var12, TooltipFlag var2, DataComponentGetter var3) {
        HolderLookup.a var4 = var0.registries();
        if (var4 != null) {
            this.song.unwrap(var4).ifPresent(var1 -> {
                IChatMutableComponent var2 = ((JukeboxSong)var1.value()).description().copy();
                ChatComponentUtils.mergeStyles(var2, ChatModifier.EMPTY.withColor(EnumChatFormat.GRAY));
                var12.accept(var2);
            });
        }
    }

    public static EnumInteractionResult tryInsertIntoJukebox(World var0, BlockPosition var1, ItemStack var2, EntityHuman var3) {
        JukeboxPlayable var4 = var2.get(DataComponents.JUKEBOX_PLAYABLE);
        if (var4 == null) {
            return EnumInteractionResult.TRY_WITH_EMPTY_HAND;
        }
        IBlockData var5 = var0.getBlockState(var1);
        if (!var5.is(Blocks.JUKEBOX) || var5.getValue(BlockJukeBox.HAS_RECORD).booleanValue()) {
            return EnumInteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!var0.isClientSide) {
            ItemStack var6 = var2.consumeAndReturn(1, var3);
            TileEntity tileEntity = var0.getBlockEntity(var1);
            if (tileEntity instanceof TileEntityJukeBox) {
                TileEntityJukeBox var7 = (TileEntityJukeBox)tileEntity;
                var7.setTheItem(var6);
                var0.gameEvent(GameEvent.BLOCK_CHANGE, var1, GameEvent.a.of(var3, var5));
            }
            var3.awardStat(StatisticList.PLAY_RECORD);
        }
        return EnumInteractionResult.SUCCESS;
    }
}

