/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.player.PlayerAbilities;
import org.jetbrains.annotations.Contract;

public final class EnumGamemode
extends Enum<EnumGamemode>
implements INamable {
    public static final /* enum */ EnumGamemode SURVIVAL = new EnumGamemode(0, "survival");
    public static final /* enum */ EnumGamemode CREATIVE = new EnumGamemode(1, "creative");
    public static final /* enum */ EnumGamemode ADVENTURE = new EnumGamemode(2, "adventure");
    public static final /* enum */ EnumGamemode SPECTATOR = new EnumGamemode(3, "spectator");
    public static final EnumGamemode DEFAULT_MODE;
    public static final INamable.a<EnumGamemode> CODEC;
    private static final IntFunction<EnumGamemode> BY_ID;
    public static final StreamCodec<ByteBuf, EnumGamemode> STREAM_CODEC;
    @Deprecated
    public static final Codec<EnumGamemode> LEGACY_ID_CODEC;
    private static final int NOT_SET = -1;
    private final int id;
    private final String name;
    private final IChatBaseComponent shortName;
    private final IChatBaseComponent longName;
    private static final /* synthetic */ EnumGamemode[] o;

    public static EnumGamemode[] values() {
        return (EnumGamemode[])o.clone();
    }

    public static EnumGamemode valueOf(String var0) {
        return Enum.valueOf(EnumGamemode.class, var0);
    }

    private EnumGamemode(int var2, String var3) {
        this.id = var2;
        this.name = var3;
        this.shortName = IChatBaseComponent.translatable("selectWorld.gameMode." + var3);
        this.longName = IChatBaseComponent.translatable("gameMode." + var3);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public IChatBaseComponent getLongDisplayName() {
        return this.longName;
    }

    public IChatBaseComponent getShortDisplayName() {
        return this.shortName;
    }

    public void updatePlayerAbilities(PlayerAbilities var0) {
        if (this == CREATIVE) {
            var0.mayfly = true;
            var0.instabuild = true;
            var0.invulnerable = true;
        } else if (this == SPECTATOR) {
            var0.mayfly = true;
            var0.instabuild = false;
            var0.invulnerable = true;
            var0.flying = true;
        } else {
            var0.mayfly = false;
            var0.instabuild = false;
            var0.invulnerable = false;
            var0.flying = false;
        }
        var0.mayBuild = !this.isBlockPlacingRestricted();
    }

    public boolean isBlockPlacingRestricted() {
        return this == ADVENTURE || this == SPECTATOR;
    }

    public boolean isCreative() {
        return this == CREATIVE;
    }

    public boolean isSurvival() {
        return this == SURVIVAL || this == ADVENTURE;
    }

    public static EnumGamemode byId(int var0) {
        return BY_ID.apply(var0);
    }

    public static EnumGamemode byName(String var0) {
        return EnumGamemode.byName(var0, SURVIVAL);
    }

    @Nullable
    @Contract(value="_,!null->!null;_,null->_")
    public static EnumGamemode byName(String var0, @Nullable EnumGamemode var1) {
        EnumGamemode var2 = CODEC.byName(var0);
        return var2 != null ? var2 : var1;
    }

    public static int getNullableId(@Nullable EnumGamemode var0) {
        return var0 != null ? var0.id : -1;
    }

    @Nullable
    public static EnumGamemode byNullableId(int var0) {
        if (var0 == -1) {
            return null;
        }
        return EnumGamemode.byId(var0);
    }

    public static boolean isValidId(int var0) {
        return Arrays.stream(EnumGamemode.values()).anyMatch(var1 -> var1.id == var0);
    }

    private static /* synthetic */ EnumGamemode[] i() {
        return new EnumGamemode[]{SURVIVAL, CREATIVE, ADVENTURE, SPECTATOR};
    }

    static {
        o = EnumGamemode.i();
        DEFAULT_MODE = SURVIVAL;
        CODEC = INamable.fromEnum(EnumGamemode::values);
        BY_ID = ByIdMap.continuous(EnumGamemode::getId, EnumGamemode.values(), ByIdMap.a.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, EnumGamemode::getId);
        LEGACY_ID_CODEC = Codec.INT.xmap(EnumGamemode::byId, EnumGamemode::getId);
    }
}

